/*
 * Decompiled with CFR 0.152.
 */
package net.pms.configuration;

import com.sun.jna.Platform;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.pms.Messages;
import net.pms.configuration.Build;
import net.pms.configuration.ConfigurationProgramPaths;
import net.pms.configuration.ConfigurationReader;
import net.pms.configuration.IpFilter;
import net.pms.configuration.PlatformSpecificDefaultPathsFactory;
import net.pms.configuration.ProgramPaths;
import net.pms.configuration.TempFolder;
import net.pms.configuration.WindowsRegistryProgramPaths;
import net.pms.io.SystemUtils;
import net.pms.util.FileUtil;
import net.pms.util.PropertiesUtil;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PmsConfiguration {
    private static final Logger logger;
    private static final int DEFAULT_SERVER_PORT = 5001;
    private static final int MENCODER_MAX_THREADS = 8;
    private static final String KEY_ALTERNATE_SUBTITLE_FOLDER = "alternate_subtitle_folder";
    private static final String KEY_ALTERNATE_THUMB_FOLDER = "alternate_thumb_folder";
    private static final String KEY_SHOW_APERTURE_LIBRARY = "show_aperture_library";
    private static final String KEY_AUDIO_BITRATE = "audio_bitrate";
    private static final String KEY_AUDIO_CHANNEL_COUNT = "audio_channels";
    private static final String KEY_AUDIO_LANGUAGES = "audio_languages";
    private static final String KEY_AUDIO_RESAMPLE = "audio_resample";
    private static final String KEY_AUDIO_SUB_LANGS = "audio_subtitle_languages";
    private static final String KEY_AUDIO_THUMBNAIL_METHOD = "audio_thumbnail_method";
    private static final String KEY_AUTO_UPDATE = "auto_update";
    private static final String KEY_AUTOLOAD_SUBTITLES = "autoload_external_subtitles";
    private static final String KEY_AVISYNTH_CONVERT_FPS = "avisynth_convert_fps";
    private static final String KEY_AVISYNTH_SCRIPT = "avisynth_script";
    private static final String KEY_ASS_MARGIN = "subtitle_ass_margin";
    private static final String KEY_ASS_OUTLINE = "subtitle_ass_outline";
    private static final String KEY_ASS_SCALE = "subtitle_ass_scale";
    private static final String KEY_ASS_SHADOW = "subtitle_ass_shadow";
    private static final String KEY_BUFFER_MAX = "buffer_max";
    private static final String KEY_CHAPTER_INTERVAL = "chapter_interval";
    private static final String KEY_CHAPTER_SUPPORT = "chapter_support";
    private static final String KEY_MENCODER_CODEC_SPECIFIC_SCRIPT = "mencoder_codec_specific_script";
    private static final String KEY_DISABLE_FAKESIZE = "disable_fakesize";
    public static final String KEY_DISABLE_SUBTITLES = "disable_subtitles";
    private static final String KEY_DVD_ISO_THUMBNAILS = "dvd_iso_thumbnails";
    private static final String KEY_AUDIO_EMBED_DTS_IN_PCM = "audio_embed_dts_in_pcm";
    private static final String KEY_ENGINES = "engines";
    private static final String KEY_FFMPEG_ALTERNATIVE_PATH = "alternativeffmpegpath";
    private static final String KEY_FFMPEG_MULTITHREADING = "ffmpeg_multithreading";
    private static final String KEY_FFMPEG_MUX_COMPATIBLE = "ffmpeg_mux_compatible";
    private static final String KEY_FILENAME_FORMAT_LONG = "filename_format_long";
    private static final String KEY_FILENAME_FORMAT_SHORT = "filename_format_short";
    private static final String KEY_FIX_25FPS_AV_MISMATCH = "fix_25fps_av_mismatch";
    private static final String KEY_FONT = "subtitle_font";
    private static final String KEY_FORCED_SUBTITLE_LANGUAGE = "forced_subtitle_language";
    private static final String KEY_FORCED_SUBTITLE_TAGS = "forced_subtitle_tags";
    private static final String KEY_FORCE_TRANSCODE_FOR_EXTENSIONS = "force_transcode_for_extensions";
    private static final String KEY_HIDE_EMPTY_FOLDERS = "hide_empty_folders";
    private static final String KEY_HIDE_ENGINENAMES = "hide_engine_names";
    private static final String KEY_HIDE_EXTENSIONS = "hide_extensions";
    private static final String KEY_HIDE_MEDIA_LIBRARY_FOLDER = "hide_media_library_folder";
    private static final String KEY_HIDE_TRANSCODE_FOLDER = "hide_transcode_folder";
    private static final String KEY_HIDE_VIDEO_SETTINGS = "hide_video_settings";
    private static final String KEY_HTTP_ENGINE_V2 = "http_engine_v2";
    private static final String KEY_IMAGE_THUMBNAILS_ENABLED = "image_thumbnails";
    private static final String KEY_IP_FILTER = "ip_filter";
    private static final String KEY_SHOW_IPHOTO_LIBRARY = "show_iphoto_library";
    private static final String KEY_SHOW_ITUNES_LIBRARY = "show_itunes_library";
    private static final String KEY_LANGUAGE = "language";
    private static final String KEY_MAX_AUDIO_BUFFER = "maximum_audio_buffer_size";
    private static final String KEY_MAX_BITRATE = "maximum_bitrate";
    private static final String KEY_MAX_MEMORY_BUFFER_SIZE = "maximum_video_buffer_size";
    private static final String KEY_MENCODER_ASS = "mencoder_ass";
    private static final String KEY_MENCODER_AC3_FIXED = "mencoder_ac3_fixed";
    private static final String KEY_MENCODER_ASS_DEFAULTSTYLE = "mencoder_ass_defaultstyle";
    private static final String KEY_MENCODER_CUSTOM_OPTIONS = "mencoder_custom_options";
    private static final String KEY_MENCODER_FONT_CONFIG = "mencoder_fontconfig";
    private static final String KEY_MENCODER_FORCE_FPS = "mencoder_forcefps";
    private static final String KEY_MENCODER_INTELLIGENT_SYNC = "mencoder_intelligent_sync";
    private static final String KEY_MENCODER_MAX_THREADS = "mencoder_max_threads";
    private static final String KEY_MENCODER_MT = "mencoder_mt";
    private static final String KEY_MENCODER_NOASS_BLUR = "mencoder_noass_blur";
    private static final String KEY_MENCODER_NOASS_OUTLINE = "mencoder_noass_outline";
    private static final String KEY_MENCODER_NOASS_SCALE = "mencoder_noass_scale";
    private static final String KEY_MENCODER_NOASS_SUBPOS = "mencoder_noass_subpos";
    private static final String KEY_MENCODER_NO_OUT_OF_SYNC = "mencoder_no_out_of_sync";
    private static final String KEY_MENCODER_OVERSCAN_COMPENSATION_HEIGHT = "mencoder_overscan_compensation_height";
    private static final String KEY_MENCODER_OVERSCAN_COMPENSATION_WIDTH = "mencoder_overscan_compensation_width";
    private static final String KEY_AUDIO_REMUX_AC3 = "audio_remux_ac3";
    private static final String KEY_MENCODER_REMUX_MPEG2 = "mencoder_remux_mpeg2";
    private static final String KEY_MENCODER_SCALER = "mencoder_scaler";
    private static final String KEY_MENCODER_SCALEX = "mencoder_scalex";
    private static final String KEY_MENCODER_SCALEY = "mencoder_scaley";
    private static final String KEY_MENCODER_SUB_FRIBIDI = "mencoder_sub_fribidi";
    private static final String KEY_MENCODER_USE_PCM_FOR_HQ_AUDIO_ONLY = "mencoder_usepcm_for_hq_audio_only";
    private static final String KEY_MENCODER_VOBSUB_SUBTITLE_QUALITY = "mencoder_vobsub_subtitle_quality";
    private static final String KEY_MENCODER_YADIF = "mencoder_yadif";
    private static final String KEY_MINIMIZED = "minimized";
    private static final String KEY_MIN_MEMORY_BUFFER_SIZE = "minimum_video_buffer_size";
    private static final String KEY_MIN_STREAM_BUFFER = "minimum_web_buffer_size";
    private static final String KEY_MPEG2_MAIN_SETTINGS = "mpeg2_main_settings";
    private static final String KEY_MUX_ALLAUDIOTRACKS = "tsmuxer_mux_all_audiotracks";
    private static final String KEY_NETWORK_INTERFACE = "network_interface";
    private static final String KEY_DISABLE_TRANSCODE_FOR_EXTENSIONS = "disable_transcode_for_extensions";
    private static final String KEY_NUMBER_OF_CPU_CORES = "number_of_cpu_cores";
    private static final String KEY_OPEN_ARCHIVES = "enable_archive_browsing";
    private static final String KEY_OVERSCAN = "mencoder_overscan";
    private static final String KEY_PLUGIN_DIRECTORY = "plugins";
    private static final String KEY_PREVENTS_SLEEP = "prevents_sleep_mode";
    private static final String KEY_PROFILE_NAME = "name";
    private static final String KEY_RENDERER_DEFAULT = "renderer_default";
    private static final String KEY_RENDERER_FORCE_DEFAULT = "renderer_force_default";
    private static final String KEY_RENDERER_FORCE_IP = "renderer_force_ip";
    private static final String KEY_SERVER_HOSTNAME = "hostname";
    private static final String KEY_SERVER_PORT = "port";
    private static final String KEY_SHARES = "shares";
    private static final String KEY_SKIP_LOOP_FILTER_ENABLED = "mencoder_skip_loop_filter";
    private static final String KEY_SKIP_NETWORK_INTERFACES = "skip_network_interfaces";
    private static final String KEY_SORT_METHOD = "sort_method";
    private static final String KEY_SUBS_COLOR = "subtitle_color";
    private static final String KEY_SUBTITLE_CODEPAGE = "subtitle_codepage";
    private static final String KEY_SUBTITLE_LANGUAGES = "subtitle_languages";
    private static final String KEY_TEMP_FOLDER_PATH = "temp_directory";
    private static final String KEY_THUMBNAIL_GENERATION_ENABLED = "generate_thumbnails";
    private static final String KEY_THUMBNAIL_SEEK_POS = "thumbnail_seek_position";
    private static final String KEY_TRANSCODE_BLOCKS_MULTIPLE_CONNECTIONS = "transcode_block_multiple_connections";
    private static final String KEY_TRANSCODE_FOLDER_NAME = "transcode_folder_name";
    private static final String KEY_TRANSCODE_KEEP_FIRST_CONNECTION = "transcode_keep_first_connection";
    private static final String KEY_TSMUXER_FORCEFPS = "tsmuxer_forcefps";
    private static final String KEY_UPNP_PORT = "upnp_port";
    private static final String KEY_USE_CACHE = "use_cache";
    private static final String KEY_USE_MPLAYER_FOR_THUMBS = "use_mplayer_for_video_thumbs";
    private static final String KEY_AUDIO_USE_PCM = "audio_use_pcm";
    private static final String KEY_UUID = "uuid";
    private static final String KEY_VIDEOTRANSCODE_START_DELAY = "videotranscode_start_delay";
    private static final String KEY_VIRTUAL_FOLDERS = "vfolders";
    private static final String KEY_VLC_USE_EXPERIMENTAL_CODECS = "vlc_use_experimental_codecs";
    private static final String KEY_VLC_AUDIO_SYNC_ENABLED = "vlc_audio_sync_enabled";
    private static final String KEY_VLC_SUBTITLE_ENABLED = "vlc_subtitle_enabled";
    private static final String KEY_VLC_SCALE = "vlc_scale";
    private static final String KEY_VLC_SAMPLE_RATE_OVERRIDE = "vlc_sample_rate_override";
    private static final String KEY_VLC_SAMPLE_RATE = "vlc_sample_rate";
    private static final String KEY_VIDEO_HW_ACCELERATION = "video_hardware_acceleration";
    private static final String KEY_WEB_CONF_PATH = "web_conf";
    private static final String PROFILE_DIRECTORY_NAME;
    private static String HOSTNAME;
    private static String DEFAULT_AVI_SYNTH_SCRIPT;
    private static final int MAX_MAX_MEMORY_DEFAULT_SIZE = 400;
    private static final int BUFFER_MEMORY_FACTOR = 368;
    private static int MAX_MAX_MEMORY_BUFFER_SIZE;
    private static final char LIST_SEPARATOR = ',';
    private static final String KEY_FOLDERS = "folders";
    private final PropertiesConfiguration configuration;
    private final ConfigurationReader configurationReader;
    private final TempFolder tempFolder;
    private final ProgramPaths programPaths;
    private final IpFilter filter = new IpFilter();
    private static final String FILENAME_FORMAT_SHORT;
    private static final String FILENAME_FORMAT_LONG;
    public static final Set<String> NEED_RELOAD_FLAGS;
    private static final String DEFAULT_PROFILE_FILENAME = "PMS.conf";
    private static final String ENV_PROFILE_PATH = "PMS_PROFILE";
    private static final String DEFAULT_WEB_CONF_FILENAME = "WEB.conf";
    private static final String PROFILE_DIRECTORY;
    private static final String PROFILE_PATH;
    private static String WEB_CONF_PATH;
    private static final String SKEL_PROFILE_PATH;
    private static final String PROPERTY_PROFILE_PATH = "pms.profile.path";
    private static final String SYSTEM_PROFILE_DIRECTORY;

    public PmsConfiguration() throws ConfigurationException {
        this(true);
    }

    public PmsConfiguration(boolean loadFile) throws ConfigurationException {
        this.configuration = new PropertiesConfiguration();
        this.configurationReader = new ConfigurationReader(this.configuration, true);
        this.configuration.setListDelimiter('\u0000');
        if (loadFile) {
            File pmsSkelConfFile;
            File pmsConfFile = new File(PROFILE_PATH);
            if (pmsConfFile.isFile()) {
                if (FileUtil.isFileReadable(pmsConfFile)) {
                    this.configuration.load(PROFILE_PATH);
                } else {
                    logger.warn("Can't load {}", (Object)PROFILE_PATH);
                }
            } else if (SKEL_PROFILE_PATH != null && (pmsSkelConfFile = new File(SKEL_PROFILE_PATH)).isFile()) {
                if (FileUtil.isFileReadable(pmsSkelConfFile)) {
                    this.configuration.load(pmsSkelConfFile);
                    logger.info("Default configuration loaded from " + SKEL_PROFILE_PATH);
                } else {
                    logger.warn("Can't load {}", (Object)SKEL_PROFILE_PATH);
                }
            }
        }
        this.configuration.setPath(PROFILE_PATH);
        this.tempFolder = new TempFolder(this.getString(KEY_TEMP_FOLDER_PATH, null));
        this.programPaths = PmsConfiguration.createProgramPathsChain(this.configuration);
        Locale.setDefault(new Locale(this.getLanguage()));
        DEFAULT_AVI_SYNTH_SCRIPT = "<movie>\n<sub>\n";
        long usableMemory = Runtime.getRuntime().maxMemory() / 0x100000L - 368L;
        if (usableMemory > 400L) {
            MAX_MAX_MEMORY_BUFFER_SIZE = (int)usableMemory;
        }
    }

    private static ProgramPaths createProgramPathsChain(Configuration configuration) {
        return new ConfigurationProgramPaths(configuration, new WindowsRegistryProgramPaths(new PlatformSpecificDefaultPathsFactory().get()));
    }

    private int getInt(String key, int def) {
        return this.configurationReader.getInt(key, def);
    }

    private boolean getBoolean(String key, boolean def) {
        return this.configurationReader.getBoolean(key, def);
    }

    private String getString(String key, String def) {
        return this.configurationReader.getNonBlankConfigurationString(key, def);
    }

    private List<String> getStringList(String key, String def) {
        return this.configurationReader.getStringList(key, def);
    }

    public File getTempFolder() throws IOException {
        return this.tempFolder.getTempFolder();
    }

    public String getVlcPath() {
        return this.programPaths.getVlcPath();
    }

    public String getMencoderPath() {
        return this.programPaths.getMencoderPath();
    }

    public int getMencoderMaxThreads() {
        return Math.min(this.getInt(KEY_MENCODER_MAX_THREADS, this.getNumberOfCpuCores()), 8);
    }

    public String getDCRawPath() {
        return this.programPaths.getDCRaw();
    }

    public String getFfmpegPath() {
        return this.programPaths.getFfmpegPath();
    }

    public String getMplayerPath() {
        return this.programPaths.getMplayerPath();
    }

    public String getTsmuxerPath() {
        return this.programPaths.getTsmuxerPath();
    }

    public String getFlacPath() {
        return this.programPaths.getFlacPath();
    }

    public boolean isTsmuxerForceFps() {
        return this.getBoolean(KEY_TSMUXER_FORCEFPS, true);
    }

    public int getAudioBitrate() {
        return this.getInt(KEY_AUDIO_BITRATE, 640);
    }

    public void setTsmuxerForceFps(boolean value) {
        this.configuration.setProperty(KEY_TSMUXER_FORCEFPS, value);
    }

    public int getServerPort() {
        return this.getInt(KEY_SERVER_PORT, 5001);
    }

    public void setServerPort(int value) {
        this.configuration.setProperty(KEY_SERVER_PORT, value);
    }

    public String getServerHostname() {
        return this.getString(KEY_SERVER_HOSTNAME, null);
    }

    public void setHostname(String value) {
        this.configuration.setProperty(KEY_SERVER_HOSTNAME, value);
    }

    public String getLanguage() {
        String def = Locale.getDefault().getLanguage();
        if (def == null) {
            def = "en";
        }
        return this.getString(KEY_LANGUAGE, def);
    }

    public int getMinMemoryBufferSize() {
        return this.getInt(KEY_MIN_MEMORY_BUFFER_SIZE, 12);
    }

    public int getMaxMemoryBufferSize() {
        return Math.max(0, Math.min(MAX_MAX_MEMORY_BUFFER_SIZE, this.getInt(KEY_MAX_MEMORY_BUFFER_SIZE, 200)));
    }

    public void setMaxMemoryBufferSize(int value) {
        this.configuration.setProperty(KEY_MAX_MEMORY_BUFFER_SIZE, Math.max(0, Math.min(MAX_MAX_MEMORY_BUFFER_SIZE, value)));
    }

    public String getAssScale() {
        return this.getString(KEY_ASS_SCALE, "1.4");
    }

    public boolean isMencoderAc3Fixed() {
        return this.getBoolean(KEY_MENCODER_AC3_FIXED, false);
    }

    public String getAssMargin() {
        return this.getString(KEY_ASS_MARGIN, "10");
    }

    public String getAssOutline() {
        return this.getString(KEY_ASS_OUTLINE, "1");
    }

    public String getAssShadow() {
        return this.getString(KEY_ASS_SHADOW, "1");
    }

    public String getMencoderNoAssScale() {
        return this.getString(KEY_MENCODER_NOASS_SCALE, "3");
    }

    public String getMencoderNoAssSubPos() {
        return this.getString(KEY_MENCODER_NOASS_SUBPOS, "2");
    }

    public String getMencoderNoAssBlur() {
        return this.getString(KEY_MENCODER_NOASS_BLUR, "1");
    }

    public String getMencoderNoAssOutline() {
        return this.getString(KEY_MENCODER_NOASS_OUTLINE, "1");
    }

    public void setMencoderNoAssOutline(String value) {
        this.configuration.setProperty(KEY_MENCODER_NOASS_OUTLINE, value);
    }

    public void setMencoderAc3Fixed(boolean value) {
        this.configuration.setProperty(KEY_MENCODER_AC3_FIXED, value);
    }

    public void setAssMargin(String value) {
        this.configuration.setProperty(KEY_ASS_MARGIN, value);
    }

    public void setAssOutline(String value) {
        this.configuration.setProperty(KEY_ASS_OUTLINE, value);
    }

    public void setAssShadow(String value) {
        this.configuration.setProperty(KEY_ASS_SHADOW, value);
    }

    public void setAssScale(String value) {
        this.configuration.setProperty(KEY_ASS_SCALE, value);
    }

    public void setMencoderNoAssScale(String value) {
        this.configuration.setProperty(KEY_MENCODER_NOASS_SCALE, value);
    }

    public void setMencoderNoAssBlur(String value) {
        this.configuration.setProperty(KEY_MENCODER_NOASS_BLUR, value);
    }

    public void setMencoderNoAssSubPos(String value) {
        this.configuration.setProperty(KEY_MENCODER_NOASS_SUBPOS, value);
    }

    public void setMencoderMaxThreads(int value) {
        this.configuration.setProperty(KEY_MENCODER_MAX_THREADS, value);
    }

    public void setLanguage(String value) {
        this.configuration.setProperty(KEY_LANGUAGE, value);
        Locale.setDefault(new Locale(this.getLanguage()));
    }

    public int getThumbnailSeekPos() {
        return this.getInt(KEY_THUMBNAIL_SEEK_POS, 2);
    }

    public void setThumbnailSeekPos(int value) {
        this.configuration.setProperty(KEY_THUMBNAIL_SEEK_POS, value);
    }

    public boolean isMencoderAss() {
        return this.getBoolean(KEY_MENCODER_ASS, true);
    }

    public boolean isDisableSubtitles() {
        return this.getBoolean(KEY_DISABLE_SUBTITLES, false);
    }

    public void setDisableSubtitles(boolean value) {
        this.configuration.setProperty(KEY_DISABLE_SUBTITLES, value);
    }

    public boolean isAudioUsePCM() {
        return this.getBoolean(KEY_AUDIO_USE_PCM, false);
    }

    public boolean isMencoderUsePcmForHQAudioOnly() {
        return this.getBoolean(KEY_MENCODER_USE_PCM_FOR_HQ_AUDIO_ONLY, false);
    }

    public String getFont() {
        return this.getString(KEY_FONT, "");
    }

    public String getAudioLanguages() {
        return this.configurationReader.getPossiblyBlankConfigurationString(KEY_AUDIO_LANGUAGES, Messages.getString("MEncoderVideo.126"));
    }

    public String getSubtitlesLanguages() {
        return this.configurationReader.getPossiblyBlankConfigurationString(KEY_SUBTITLE_LANGUAGES, Messages.getString("MEncoderVideo.127"));
    }

    public String getForcedSubtitleLanguage() {
        return this.configurationReader.getPossiblyBlankConfigurationString(KEY_FORCED_SUBTITLE_LANGUAGE, this.getLanguage());
    }

    public String getForcedSubtitleTags() {
        return this.getString(KEY_FORCED_SUBTITLE_TAGS, "forced");
    }

    public String getAudioSubLanguages() {
        return this.configurationReader.getPossiblyBlankConfigurationString(KEY_AUDIO_SUB_LANGS, Messages.getString("MEncoderVideo.128"));
    }

    public boolean isMencoderSubFribidi() {
        return this.getBoolean(KEY_MENCODER_SUB_FRIBIDI, false);
    }

    public String getSubtitlesCodepage() {
        return this.getString(KEY_SUBTITLE_CODEPAGE, "");
    }

    public boolean isMencoderFontConfig() {
        return this.getBoolean(KEY_MENCODER_FONT_CONFIG, true);
    }

    public void setMencoderForceFps(boolean value) {
        this.configuration.setProperty(KEY_MENCODER_FORCE_FPS, value);
    }

    public boolean isMencoderForceFps() {
        return this.getBoolean(KEY_MENCODER_FORCE_FPS, false);
    }

    public void setAudioLanguages(String value) {
        this.configuration.setProperty(KEY_AUDIO_LANGUAGES, value);
    }

    public void setSubtitlesLanguages(String value) {
        this.configuration.setProperty(KEY_SUBTITLE_LANGUAGES, value);
    }

    public void setForcedSubtitleLanguage(String value) {
        this.configuration.setProperty(KEY_FORCED_SUBTITLE_LANGUAGE, value);
    }

    public void setForcedSubtitleTags(String value) {
        this.configuration.setProperty(KEY_FORCED_SUBTITLE_TAGS, value);
    }

    public void setAudioSubLanguages(String value) {
        this.configuration.setProperty(KEY_AUDIO_SUB_LANGS, value);
    }

    public String getMencoderCustomOptions() {
        return this.getString(KEY_MENCODER_CUSTOM_OPTIONS, "");
    }

    public void setMencoderCustomOptions(String value) {
        this.configuration.setProperty(KEY_MENCODER_CUSTOM_OPTIONS, value);
    }

    public void setSubtitlesCodepage(String value) {
        this.configuration.setProperty(KEY_SUBTITLE_CODEPAGE, value);
    }

    public void setMencoderSubFribidi(boolean value) {
        this.configuration.setProperty(KEY_MENCODER_SUB_FRIBIDI, value);
    }

    public void setFont(String value) {
        this.configuration.setProperty(KEY_FONT, value);
    }

    public void setMencoderAss(boolean value) {
        this.configuration.setProperty(KEY_MENCODER_ASS, value);
    }

    public void setMencoderFontConfig(boolean value) {
        this.configuration.setProperty(KEY_MENCODER_FONT_CONFIG, value);
    }

    public void setAudioUsePCM(boolean value) {
        this.configuration.setProperty(KEY_AUDIO_USE_PCM, value);
    }

    public void setMencoderUsePcmForHQAudioOnly(boolean value) {
        this.configuration.setProperty(KEY_MENCODER_USE_PCM_FOR_HQ_AUDIO_ONLY, value);
    }

    public boolean isArchiveBrowsing() {
        return this.getBoolean(KEY_OPEN_ARCHIVES, false);
    }

    public void setArchiveBrowsing(boolean value) {
        this.configuration.setProperty(KEY_OPEN_ARCHIVES, value);
    }

    public boolean isMencoderYadif() {
        return this.getBoolean(KEY_MENCODER_YADIF, false);
    }

    public void setMencoderYadif(boolean value) {
        this.configuration.setProperty(KEY_MENCODER_YADIF, value);
    }

    public boolean isMencoderScaler() {
        return this.getBoolean(KEY_MENCODER_SCALER, false);
    }

    public void setMencoderScaler(boolean value) {
        this.configuration.setProperty(KEY_MENCODER_SCALER, value);
    }

    public int getMencoderScaleX() {
        return this.getInt(KEY_MENCODER_SCALEX, 0);
    }

    public void setMencoderScaleX(int value) {
        this.configuration.setProperty(KEY_MENCODER_SCALEX, value);
    }

    public int getMencoderScaleY() {
        return this.getInt(KEY_MENCODER_SCALEY, 0);
    }

    public void setMencoderScaleY(int value) {
        this.configuration.setProperty(KEY_MENCODER_SCALEY, value);
    }

    public int getAudioChannelCount() {
        return this.getInt(KEY_AUDIO_CHANNEL_COUNT, 6);
    }

    public void setAudioChannelCount(int value) {
        this.configuration.setProperty(KEY_AUDIO_CHANNEL_COUNT, value);
    }

    public void setAudioBitrate(int value) {
        this.configuration.setProperty(KEY_AUDIO_BITRATE, value);
    }

    public String getMaximumBitrate() {
        String maximumBitrate = this.getString(KEY_MAX_BITRATE, "110");
        if ("0".equals(maximumBitrate)) {
            maximumBitrate = "1000";
        }
        return maximumBitrate;
    }

    public void setMaximumBitrate(String value) {
        this.configuration.setProperty(KEY_MAX_BITRATE, value);
    }

    public boolean isThumbnailGenerationEnabled() {
        return this.getBoolean(KEY_THUMBNAIL_GENERATION_ENABLED, true);
    }

    public void setThumbnailGenerationEnabled(boolean value) {
        this.configuration.setProperty(KEY_THUMBNAIL_GENERATION_ENABLED, value);
    }

    public boolean getImageThumbnailsEnabled() {
        return this.getBoolean(KEY_IMAGE_THUMBNAILS_ENABLED, true);
    }

    public void setImageThumbnailsEnabled(boolean value) {
        this.configuration.setProperty(KEY_IMAGE_THUMBNAILS_ENABLED, value);
    }

    public int getNumberOfCpuCores() {
        int nbcores = Runtime.getRuntime().availableProcessors();
        if (nbcores < 1) {
            nbcores = 1;
        }
        return this.getInt(KEY_NUMBER_OF_CPU_CORES, nbcores);
    }

    public void setNumberOfCpuCores(int value) {
        this.configuration.setProperty(KEY_NUMBER_OF_CPU_CORES, value);
    }

    public boolean isMinimized() {
        return this.getBoolean(KEY_MINIMIZED, false);
    }

    public void setMinimized(boolean value) {
        this.configuration.setProperty(KEY_MINIMIZED, value);
    }

    public boolean isAutoloadExternalSubtitles() {
        return this.getBoolean(KEY_AUTOLOAD_SUBTITLES, true);
    }

    public void setAutoloadExternalSubtitles(boolean value) {
        this.configuration.setProperty(KEY_AUTOLOAD_SUBTITLES, value);
    }

    public boolean getHideVideoSettings() {
        return this.getBoolean(KEY_HIDE_VIDEO_SETTINGS, true);
    }

    public void setHideVideoSettings(boolean value) {
        this.configuration.setProperty(KEY_HIDE_VIDEO_SETTINGS, value);
    }

    public boolean getUseCache() {
        return this.getBoolean(KEY_USE_CACHE, false);
    }

    public void setUseCache(boolean value) {
        this.configuration.setProperty(KEY_USE_CACHE, value);
    }

    public void setAvisynthConvertFps(boolean value) {
        this.configuration.setProperty(KEY_AVISYNTH_CONVERT_FPS, value);
    }

    public boolean getAvisynthConvertFps() {
        return this.getBoolean(KEY_AVISYNTH_CONVERT_FPS, false);
    }

    public String getAvisynthScript() {
        return this.getString(KEY_AVISYNTH_SCRIPT, DEFAULT_AVI_SYNTH_SCRIPT);
    }

    public void setAvisynthScript(String value) {
        this.configuration.setProperty(KEY_AVISYNTH_SCRIPT, value);
    }

    public String getMencoderCodecSpecificConfig() {
        return this.getString(KEY_MENCODER_CODEC_SPECIFIC_SCRIPT, "");
    }

    public void setMencoderCodecSpecificConfig(String value) {
        this.configuration.setProperty(KEY_MENCODER_CODEC_SPECIFIC_SCRIPT, value);
    }

    public int getMaxAudioBuffer() {
        return this.getInt(KEY_MAX_AUDIO_BUFFER, 100);
    }

    public int getMinStreamBuffer() {
        return this.getInt(KEY_MIN_STREAM_BUFFER, 1);
    }

    public String getMPEG2MainSettingsFFmpeg() {
        String mpegSettings = this.getMPEG2MainSettings();
        if (mpegSettings.contains("Automatic")) {
            return mpegSettings;
        }
        String[] mpegSettingsArray = mpegSettings.split(":");
        String returnString = "";
        for (String pair : mpegSettingsArray) {
            String[] pairArray = pair.split("=");
            if ("keyint".equals(pairArray[0])) {
                returnString = returnString + "-g " + pairArray[1] + " ";
                continue;
            }
            if ("vqscale".equals(pairArray[0])) {
                returnString = returnString + "-q:v " + pairArray[1] + " ";
                continue;
            }
            if ("vqmin".equals(pairArray[0])) {
                returnString = returnString + "-qmin " + pairArray[1] + " ";
                continue;
            }
            if (!"vqmax".equals(pairArray[0])) continue;
            returnString = returnString + "-qmax " + pairArray[1] + " ";
        }
        return returnString;
    }

    public void setFfmpegMultithreading(boolean value) {
        this.configuration.setProperty(KEY_FFMPEG_MULTITHREADING, value);
    }

    public boolean isFfmpegMultithreading() {
        boolean isMultiCore = this.getNumberOfCpuCores() > 1;
        return this.getBoolean(KEY_FFMPEG_MULTITHREADING, isMultiCore);
    }

    public boolean isMencoderNoOutOfSync() {
        return this.getBoolean(KEY_MENCODER_NO_OUT_OF_SYNC, true);
    }

    public void setMencoderNoOutOfSync(boolean value) {
        this.configuration.setProperty(KEY_MENCODER_NO_OUT_OF_SYNC, value);
    }

    public boolean getTrancodeBlocksMultipleConnections() {
        return this.getBoolean(KEY_TRANSCODE_BLOCKS_MULTIPLE_CONNECTIONS, false);
    }

    public void setTranscodeBlocksMultipleConnections(boolean value) {
        this.configuration.setProperty(KEY_TRANSCODE_BLOCKS_MULTIPLE_CONNECTIONS, value);
    }

    public boolean getTrancodeKeepFirstConnections() {
        return this.getBoolean(KEY_TRANSCODE_KEEP_FIRST_CONNECTION, true);
    }

    public void setTrancodeKeepFirstConnections(boolean value) {
        this.configuration.setProperty(KEY_TRANSCODE_KEEP_FIRST_CONNECTION, value);
    }

    public boolean isMencoderIntelligentSync() {
        return this.getBoolean(KEY_MENCODER_INTELLIGENT_SYNC, true);
    }

    public void setMencoderIntelligentSync(boolean value) {
        this.configuration.setProperty(KEY_MENCODER_INTELLIGENT_SYNC, value);
    }

    @Deprecated
    public String getFfmpegAlternativePath() {
        return this.getString(KEY_FFMPEG_ALTERNATIVE_PATH, null);
    }

    @Deprecated
    public void setFfmpegAlternativePath(String value) {
        this.configuration.setProperty(KEY_FFMPEG_ALTERNATIVE_PATH, value);
    }

    public boolean getSkipLoopFilterEnabled() {
        return this.getBoolean(KEY_SKIP_LOOP_FILTER_ENABLED, false);
    }

    public List<String> getSkipNetworkInterfaces() {
        return this.getStringList(KEY_SKIP_NETWORK_INTERFACES, "tap,vmnet,vnic,virtualbox");
    }

    public void setSkipLoopFilterEnabled(boolean value) {
        this.configuration.setProperty(KEY_SKIP_LOOP_FILTER_ENABLED, value);
    }

    public String getMPEG2MainSettings() {
        return this.getString(KEY_MPEG2_MAIN_SETTINGS, "Automatic (Wired)");
    }

    public void setMPEG2MainSettings(String value) {
        this.configuration.setProperty(KEY_MPEG2_MAIN_SETTINGS, value);
    }

    public String getMencoderVobsubSubtitleQuality() {
        return this.getString(KEY_MENCODER_VOBSUB_SUBTITLE_QUALITY, "3");
    }

    public void setMencoderVobsubSubtitleQuality(String value) {
        this.configuration.setProperty(KEY_MENCODER_VOBSUB_SUBTITLE_QUALITY, value);
    }

    public String getMencoderOverscanCompensationWidth() {
        return this.getString(KEY_MENCODER_OVERSCAN_COMPENSATION_WIDTH, "0");
    }

    public void setMencoderOverscanCompensationWidth(String value) {
        if (value.trim().length() == 0) {
            value = "0";
        }
        this.configuration.setProperty(KEY_MENCODER_OVERSCAN_COMPENSATION_WIDTH, value);
    }

    public String getMencoderOverscanCompensationHeight() {
        return this.getString(KEY_MENCODER_OVERSCAN_COMPENSATION_HEIGHT, "0");
    }

    public void setMencoderOverscanCompensationHeight(String value) {
        if (value.trim().length() == 0) {
            value = "0";
        }
        this.configuration.setProperty(KEY_MENCODER_OVERSCAN_COMPENSATION_HEIGHT, value);
    }

    public void setEnginesAsList(ArrayList<String> enginesAsList) {
        this.configuration.setProperty(KEY_ENGINES, PmsConfiguration.listToString(enginesAsList));
    }

    @Deprecated
    public List<String> getEnginesAsList(SystemUtils registry) {
        return this.getEnginesAsList();
    }

    public List<String> getEnginesAsList() {
        String defaultEngines = StringUtils.join(Arrays.asList("mencoder", "avsmencoder", "tsmuxer", "ffmpegvideo", "vlctranscoder", "ffmpegaudio", "tsmuxeraudio", "ffmpegwebvideo", "vlcwebvideo", "vlcvideo", "mencoderwebvideo", "ffmpegwebaudio", "vlcaudio", "ffmpegdvrmsremux", "rawthumbs"), ',');
        return PmsConfiguration.stringToList(this.configurationReader.getPossiblyBlankConfigurationString(KEY_ENGINES, defaultEngines));
    }

    private static String listToString(List<String> enginesAsList) {
        return StringUtils.join(enginesAsList, ',');
    }

    private static List<String> stringToList(String input) {
        return new ArrayList<String>(Arrays.asList(StringUtils.split(input, ',')));
    }

    public void save() throws ConfigurationException {
        this.configuration.save();
        logger.info("Configuration saved to: " + PROFILE_PATH);
    }

    public String getFolders() {
        return this.getString(KEY_FOLDERS, "");
    }

    public void setFolders(String value) {
        this.configuration.setProperty(KEY_FOLDERS, value);
    }

    public String getNetworkInterface() {
        return this.getString(KEY_NETWORK_INTERFACE, "");
    }

    public void setNetworkInterface(String value) {
        this.configuration.setProperty(KEY_NETWORK_INTERFACE, value);
    }

    public boolean isHideEngineNames() {
        return this.getBoolean(KEY_HIDE_ENGINENAMES, false);
    }

    public void setHideEngineNames(boolean value) {
        this.configuration.setProperty(KEY_HIDE_ENGINENAMES, value);
    }

    public boolean isHideExtensions() {
        return this.getBoolean(KEY_HIDE_EXTENSIONS, false);
    }

    public void setHideExtensions(boolean value) {
        this.configuration.setProperty(KEY_HIDE_EXTENSIONS, value);
    }

    public String getShares() {
        return this.getString(KEY_SHARES, "");
    }

    public void setShares(String value) {
        this.configuration.setProperty(KEY_SHARES, value);
    }

    public String getDisableTranscodeForExtensions() {
        return this.getString(KEY_DISABLE_TRANSCODE_FOR_EXTENSIONS, "");
    }

    public void setDisableTranscodeForExtensions(String value) {
        this.configuration.setProperty(KEY_DISABLE_TRANSCODE_FOR_EXTENSIONS, value);
    }

    public String getForceTranscodeForExtensions() {
        return this.getString(KEY_FORCE_TRANSCODE_FOR_EXTENSIONS, "");
    }

    public void setForceTranscodeForEtensions(String value) {
        this.configuration.setProperty(KEY_FORCE_TRANSCODE_FOR_EXTENSIONS, value);
    }

    public void setMencoderMT(boolean value) {
        this.configuration.setProperty(KEY_MENCODER_MT, value);
    }

    public boolean getMencoderMT() {
        boolean isMultiCore = this.getNumberOfCpuCores() > 1;
        return this.getBoolean(KEY_MENCODER_MT, isMultiCore);
    }

    public void setAudioRemuxAC3(boolean value) {
        this.configuration.setProperty(KEY_AUDIO_REMUX_AC3, value);
    }

    public boolean isAudioRemuxAC3() {
        return this.getBoolean(KEY_AUDIO_REMUX_AC3, true);
    }

    public void setMencoderRemuxMPEG2(boolean value) {
        this.configuration.setProperty(KEY_MENCODER_REMUX_MPEG2, value);
    }

    public boolean isMencoderRemuxMPEG2() {
        return this.getBoolean(KEY_MENCODER_REMUX_MPEG2, true);
    }

    public void setDisableFakeSize(boolean value) {
        this.configuration.setProperty(KEY_DISABLE_FAKESIZE, value);
    }

    public boolean isDisableFakeSize() {
        return this.getBoolean(KEY_DISABLE_FAKESIZE, false);
    }

    public void setMencoderAssDefaultStyle(boolean value) {
        this.configuration.setProperty(KEY_MENCODER_ASS_DEFAULTSTYLE, value);
    }

    public boolean isMencoderAssDefaultStyle() {
        return this.getBoolean(KEY_MENCODER_ASS_DEFAULTSTYLE, true);
    }

    public int getMEncoderOverscan() {
        return this.getInt(KEY_OVERSCAN, 0);
    }

    public void setMEncoderOverscan(int value) {
        this.configuration.setProperty(KEY_OVERSCAN, value);
    }

    public int getSortMethod() {
        return this.getInt(KEY_SORT_METHOD, 4);
    }

    public void setSortMethod(int value) {
        this.configuration.setProperty(KEY_SORT_METHOD, value);
    }

    public int getAudioThumbnailMethod() {
        return this.getInt(KEY_AUDIO_THUMBNAIL_METHOD, 0);
    }

    public void setAudioThumbnailMethod(int value) {
        this.configuration.setProperty(KEY_AUDIO_THUMBNAIL_METHOD, value);
    }

    public String getAlternateThumbFolder() {
        return this.getString(KEY_ALTERNATE_THUMB_FOLDER, "");
    }

    public void setAlternateThumbFolder(String value) {
        this.configuration.setProperty(KEY_ALTERNATE_THUMB_FOLDER, value);
    }

    public String getAlternateSubtitlesFolder() {
        return this.getString(KEY_ALTERNATE_SUBTITLE_FOLDER, "");
    }

    public void setAlternateSubtitlesFolder(String value) {
        this.configuration.setProperty(KEY_ALTERNATE_SUBTITLE_FOLDER, value);
    }

    public void setAudioEmbedDtsInPcm(boolean value) {
        this.configuration.setProperty(KEY_AUDIO_EMBED_DTS_IN_PCM, value);
    }

    public boolean isAudioEmbedDtsInPcm() {
        return this.getBoolean(KEY_AUDIO_EMBED_DTS_IN_PCM, false);
    }

    public void setFFmpegMuxWhenCompatible(boolean value) {
        this.configuration.setProperty(KEY_FFMPEG_MUX_COMPATIBLE, value);
    }

    public boolean isFFmpegMuxWhenCompatible() {
        return this.getBoolean(KEY_FFMPEG_MUX_COMPATIBLE, true);
    }

    public void setMuxAllAudioTracks(boolean value) {
        this.configuration.setProperty(KEY_MUX_ALLAUDIOTRACKS, value);
    }

    public boolean isMuxAllAudioTracks() {
        return this.getBoolean(KEY_MUX_ALLAUDIOTRACKS, false);
    }

    public void setUseMplayerForVideoThumbs(boolean value) {
        this.configuration.setProperty(KEY_USE_MPLAYER_FOR_THUMBS, value);
    }

    public boolean isUseMplayerForVideoThumbs() {
        return this.getBoolean(KEY_USE_MPLAYER_FOR_THUMBS, false);
    }

    public String getIpFilter() {
        return this.getString(KEY_IP_FILTER, "");
    }

    public synchronized IpFilter getIpFiltering() {
        this.filter.setRawFilter(this.getIpFilter());
        return this.filter;
    }

    public void setIpFilter(String value) {
        this.configuration.setProperty(KEY_IP_FILTER, value);
    }

    public void setPreventsSleep(boolean value) {
        this.configuration.setProperty(KEY_PREVENTS_SLEEP, value);
    }

    public boolean isPreventsSleep() {
        return this.getBoolean(KEY_PREVENTS_SLEEP, false);
    }

    public void setHTTPEngineV2(boolean value) {
        this.configuration.setProperty(KEY_HTTP_ENGINE_V2, value);
    }

    public boolean isHTTPEngineV2() {
        return this.getBoolean(KEY_HTTP_ENGINE_V2, true);
    }

    public boolean isShowIphotoLibrary() {
        return this.getBoolean(KEY_SHOW_IPHOTO_LIBRARY, false);
    }

    public void setShowIphotoLibrary(boolean value) {
        this.configuration.setProperty(KEY_SHOW_IPHOTO_LIBRARY, value);
    }

    public boolean isShowApertureLibrary() {
        return this.getBoolean(KEY_SHOW_APERTURE_LIBRARY, false);
    }

    public void setShowApertureLibrary(boolean value) {
        this.configuration.setProperty(KEY_SHOW_APERTURE_LIBRARY, value);
    }

    public boolean isShowItunesLibrary() {
        return this.getBoolean(KEY_SHOW_ITUNES_LIBRARY, false);
    }

    public void setShowItunesLibrary(boolean value) {
        this.configuration.setProperty(KEY_SHOW_ITUNES_LIBRARY, value);
    }

    public boolean isHideEmptyFolders() {
        return this.getBoolean(KEY_HIDE_EMPTY_FOLDERS, false);
    }

    public void setHideEmptyFolders(boolean value) {
        this.configuration.setProperty(KEY_HIDE_EMPTY_FOLDERS, value);
    }

    public boolean isHideMediaLibraryFolder() {
        return this.getBoolean(KEY_HIDE_MEDIA_LIBRARY_FOLDER, false);
    }

    public void setHideMediaLibraryFolder(boolean value) {
        this.configuration.setProperty(KEY_HIDE_MEDIA_LIBRARY_FOLDER, value);
    }

    public boolean getHideTranscodeEnabled() {
        return this.getBoolean(KEY_HIDE_TRANSCODE_FOLDER, false);
    }

    public void setHideTranscodeEnabled(boolean value) {
        this.configuration.setProperty(KEY_HIDE_TRANSCODE_FOLDER, value);
    }

    public boolean isDvdIsoThumbnails() {
        return this.getBoolean(KEY_DVD_ISO_THUMBNAILS, false);
    }

    public void setDvdIsoThumbnails(boolean value) {
        this.configuration.setProperty(KEY_DVD_ISO_THUMBNAILS, value);
    }

    public Object getCustomProperty(String property) {
        return this.configurationReader.getCustomProperty(property);
    }

    public void setCustomProperty(String property, Object value) {
        this.configuration.setProperty(property, value);
    }

    public boolean isChapterSupport() {
        return this.getBoolean(KEY_CHAPTER_SUPPORT, false);
    }

    public void setChapterSupport(boolean value) {
        this.configuration.setProperty(KEY_CHAPTER_SUPPORT, value);
    }

    public int getChapterInterval() {
        return this.getInt(KEY_CHAPTER_INTERVAL, 5);
    }

    public void setChapterInterval(int value) {
        this.configuration.setProperty(KEY_CHAPTER_INTERVAL, value);
    }

    public int getSubsColor() {
        return this.getInt(KEY_SUBS_COLOR, -1);
    }

    public void setSubsColor(int value) {
        this.configuration.setProperty(KEY_SUBS_COLOR, value);
    }

    public boolean isFix25FPSAvMismatch() {
        return this.getBoolean(KEY_FIX_25FPS_AV_MISMATCH, false);
    }

    public void setFix25FPSAvMismatch(boolean value) {
        this.configuration.setProperty(KEY_FIX_25FPS_AV_MISMATCH, value);
    }

    public int getVideoTranscodeStartDelay() {
        return this.getInt(KEY_VIDEOTRANSCODE_START_DELAY, 6);
    }

    public void setVideoTranscodeStartDelay(int value) {
        this.configuration.setProperty(KEY_VIDEOTRANSCODE_START_DELAY, value);
    }

    public boolean isAudioResample() {
        return this.getBoolean(KEY_AUDIO_RESAMPLE, true);
    }

    public void setAudioResample(boolean value) {
        this.configuration.setProperty(KEY_AUDIO_RESAMPLE, value);
    }

    public String getRendererDefault() {
        return this.getString(KEY_RENDERER_DEFAULT, "");
    }

    public void setRendererDefault(String value) {
        this.configuration.setProperty(KEY_RENDERER_DEFAULT, value);
    }

    public boolean isRendererForceDefault() {
        return this.getBoolean(KEY_RENDERER_FORCE_DEFAULT, false);
    }

    public void setRendererForceDefault(boolean value) {
        this.configuration.setProperty(KEY_RENDERER_FORCE_DEFAULT, value);
    }

    public String getRendererForceIp() {
        return this.getString(KEY_RENDERER_FORCE_IP, "");
    }

    public void setRendererForceIp(String value) {
        this.configuration.setProperty(KEY_RENDERER_FORCE_IP, value);
    }

    public String getVirtualFolders() {
        return this.getString(KEY_VIRTUAL_FOLDERS, "");
    }

    public String getProfilePath() {
        return PROFILE_PATH;
    }

    public String getProfileDirectory() {
        return PROFILE_DIRECTORY;
    }

    public String getWebConfPath() {
        if (WEB_CONF_PATH == null) {
            WEB_CONF_PATH = FileUtil.getFileLocation(this.getString(KEY_WEB_CONF_PATH, null), PROFILE_DIRECTORY, DEFAULT_WEB_CONF_FILENAME).getFilePath();
        }
        return WEB_CONF_PATH;
    }

    public String getPluginDirectory() {
        return this.getString(KEY_PLUGIN_DIRECTORY, KEY_PLUGIN_DIRECTORY);
    }

    public void setPluginDirectory(String value) {
        this.configuration.setProperty(KEY_PLUGIN_DIRECTORY, value);
    }

    public String getProfileName() {
        if (HOSTNAME == null) {
            try {
                HOSTNAME = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                logger.info("Can't determine hostname");
                HOSTNAME = "unknown host";
            }
        }
        return this.getString(KEY_PROFILE_NAME, HOSTNAME);
    }

    public boolean isAutoUpdate() {
        return Build.isUpdatable() && this.getBoolean(KEY_AUTO_UPDATE, false);
    }

    public void setAutoUpdate(boolean value) {
        this.configuration.setProperty(KEY_AUTO_UPDATE, value);
    }

    public int getUpnpPort() {
        return this.getInt(KEY_UPNP_PORT, 1900);
    }

    public String getUuid() {
        return this.getString(KEY_UUID, null);
    }

    public void setUuid(String value) {
        this.configuration.setProperty(KEY_UUID, value);
    }

    public void addConfigurationListener(ConfigurationListener l) {
        this.configuration.addConfigurationListener(l);
    }

    public void removeConfigurationListener(ConfigurationListener l) {
        this.configuration.removeConfigurationListener(l);
    }

    @Deprecated
    public boolean initBufferMax() {
        return this.getBoolean(KEY_BUFFER_MAX, false);
    }

    public String getTranscodeFolderName() {
        return this.getString(KEY_TRANSCODE_FOLDER_NAME, Messages.getString("TranscodeVirtualFolder.0"));
    }

    public void setTranscodeFolderName(String name) {
        this.configuration.setProperty(KEY_TRANSCODE_FOLDER_NAME, name);
    }

    public boolean isVlcExperimentalCodecs() {
        return this.getBoolean(KEY_VLC_USE_EXPERIMENTAL_CODECS, false);
    }

    public void setVlcExperimentalCodecs(boolean value) {
        this.configuration.setProperty(KEY_VLC_USE_EXPERIMENTAL_CODECS, value);
    }

    public boolean isVlcAudioSyncEnabled() {
        return this.getBoolean(KEY_VLC_AUDIO_SYNC_ENABLED, false);
    }

    public void setVlcAudioSyncEnabled(boolean value) {
        this.configuration.setProperty(KEY_VLC_AUDIO_SYNC_ENABLED, value);
    }

    public boolean isVlcSubtitleEnabled() {
        return this.getBoolean(KEY_VLC_SUBTITLE_ENABLED, true);
    }

    public void setVlcSubtitleEnabled(boolean value) {
        this.configuration.setProperty(KEY_VLC_SUBTITLE_ENABLED, value);
    }

    public String getVlcScale() {
        return this.getString(KEY_VLC_SCALE, "1.0");
    }

    public void setVlcScale(String value) {
        this.configuration.setProperty(KEY_VLC_SCALE, value);
    }

    public boolean getVlcSampleRateOverride() {
        return this.getBoolean(KEY_VLC_SAMPLE_RATE_OVERRIDE, false);
    }

    public void setVlcSampleRateOverride(boolean value) {
        this.configuration.setProperty(KEY_VLC_SAMPLE_RATE_OVERRIDE, value);
    }

    public String getVlcSampleRate() {
        return this.getString(KEY_VLC_SAMPLE_RATE, "48000");
    }

    public void setVlcSampleRate(String value) {
        this.configuration.setProperty(KEY_VLC_SAMPLE_RATE, value);
    }

    public boolean isVideoHardwareAcceleration() {
        return this.getBoolean(KEY_VIDEO_HW_ACCELERATION, false);
    }

    public void setVideoHardwareAcceleration(boolean value) {
        this.configuration.setProperty(KEY_VIDEO_HW_ACCELERATION, value);
    }

    public String getLongFilenameFormat() {
        return this.getString(KEY_FILENAME_FORMAT_LONG, FILENAME_FORMAT_LONG);
    }

    public String getShortFilenameFormat() {
        return this.getString(KEY_FILENAME_FORMAT_SHORT, FILENAME_FORMAT_SHORT);
    }

    static {
        String xdgConfigHome;
        String programData;
        logger = LoggerFactory.getLogger(PmsConfiguration.class);
        PROFILE_DIRECTORY_NAME = Build.getProfileDirectoryName();
        MAX_MAX_MEMORY_BUFFER_SIZE = 400;
        FILENAME_FORMAT_SHORT = StringUtils.join(Arrays.asList("<[,eFull,]>", "<if aCodec> {<aLabel>: <aCodec>/<aFull>< (,aFlavor,)>} <end>", "<if sType> {<sLabel>: <sType>/<sFull>< (,sFlavor,)>} <end>"), " ");
        FILENAME_FORMAT_LONG = StringUtils.join(Arrays.asList("<fFull>", "<if isVTS>< {,vtsDVD,}><end>", "<if extra> - <end>", "<dvdLen>", "<[,eFull,]>", "<{,sExt,}>", "<if sType> {<sLabel>: <sType>/<sFull>< (,sFlavor,)>} <end>"), " ");
        NEED_RELOAD_FLAGS = new HashSet<String>(Arrays.asList(KEY_ALTERNATE_THUMB_FOLDER, KEY_NETWORK_INTERFACE, KEY_IP_FILTER, KEY_SORT_METHOD, KEY_HIDE_EMPTY_FOLDERS, KEY_HIDE_TRANSCODE_FOLDER, KEY_HIDE_MEDIA_LIBRARY_FOLDER, KEY_OPEN_ARCHIVES, KEY_USE_CACHE, KEY_HIDE_ENGINENAMES, KEY_SHOW_ITUNES_LIBRARY, KEY_SHOW_IPHOTO_LIBRARY, KEY_SHOW_APERTURE_LIBRARY, KEY_ENGINES, KEY_FOLDERS, KEY_HIDE_VIDEO_SETTINGS, KEY_AUDIO_THUMBNAIL_METHOD, KEY_DISABLE_TRANSCODE_FOR_EXTENSIONS, KEY_FORCE_TRANSCODE_FOR_EXTENSIONS, KEY_SERVER_PORT, KEY_SERVER_HOSTNAME, KEY_CHAPTER_SUPPORT, KEY_HIDE_EXTENSIONS));
        SYSTEM_PROFILE_DIRECTORY = Platform.isWindows() ? ((programData = System.getenv("ALLUSERSPROFILE")) != null ? String.format("%s\\%s", programData, PROFILE_DIRECTORY_NAME) : "") : (Platform.isMac() ? String.format("%s/%s/%s", System.getProperty("user.home"), "/Library/Application Support", PROFILE_DIRECTORY_NAME) : ((xdgConfigHome = System.getenv("XDG_CONFIG_HOME")) == null ? String.format("%s/.config/%s", System.getProperty("user.home"), PROFILE_DIRECTORY_NAME) : String.format("%s/%s", xdgConfigHome, PROFILE_DIRECTORY_NAME)));
        String customProfilePath = System.getProperty(PROPERTY_PROFILE_PATH);
        if (StringUtils.isBlank(customProfilePath)) {
            customProfilePath = System.getenv(ENV_PROFILE_PATH);
        }
        FileUtil.FileLocation profileLocation = FileUtil.getFileLocation(customProfilePath, SYSTEM_PROFILE_DIRECTORY, DEFAULT_PROFILE_FILENAME);
        PROFILE_PATH = profileLocation.getFilePath();
        PROFILE_DIRECTORY = profileLocation.getDirectoryPath();
        String skelDir = PropertiesUtil.getProjectProperties().get("project.skelprofile.dir");
        SKEL_PROFILE_PATH = Platform.isLinux() && StringUtils.isNotBlank(skelDir) ? FilenameUtils.normalize(new File(new File(skelDir, PROFILE_DIRECTORY_NAME).getAbsolutePath(), DEFAULT_PROFILE_FILENAME).getAbsolutePath()) : null;
    }
}

