/*
 * Decompiled with CFR 0.152.
 */
package mediautil.image.jpeg;

import mediautil.image.jpeg.BasicJpegIo;
import mediautil.image.jpeg.CLSID;

class DirectoryEntry
extends BasicJpegIo {
    static final int ENTRY_SIZE = 128;
    static final int STGTY_INVALID = 0;
    static final int STGTY_STORAGE = 1;
    static final int STGTY_STREAM = 2;
    static final int STGTY_LOCKBYTES = 3;
    static final int STGTY_PROPERTY = 4;
    static final int STGTY_ROOT = 5;
    static final int DE_RED = 0;
    static final int DE_BLACK = 1;
    static final int AB_SIZE = 32;
    char[] _ab;
    int _cb;
    static final int CB_OFF = 64;
    byte _mse;
    static final int MSE_OFF = 66;
    byte _flags;
    static final int FLAGS_OFF = 67;
    int _leftSib;
    static final int LEFTSIB_OFF = 68;
    int _rightSib;
    static final int RIGHTSIB_OFF = 72;
    int _child;
    static final int CHILD_OFF = 76;
    CLSID _id;
    static final int CLSID_OFF = 80;
    int _userFlags;
    static final int USERFLAGS_OFF = 96;
    long _timeCreate;
    static final int TIMECREATE_OFF = 100;
    long _timeModify;
    static final int TIMEMODIFY_OFF = 107;
    int _sectStart;
    static final int SECTSTART_OFF = 116;
    int _size;
    static final int SIZE_OFF = 120;
    static final String[] types = new String[]{"INVALID", "STORAGE", "STREAM", "LOCKBYTES", "PROPERTY", "ROOT"};

    DirectoryEntry() {
    }

    void fill(byte[] byArray, int n) {
        this.data = byArray;
        this.intel = true;
        this._mse = (byte)(this.s2n(66 + n, 1) & 0xFF);
        if (this._mse >= types.length || this._mse < 0) {
            this._mse = 0;
        }
        this._cb = this.s2n(64 + n, 2) / 2;
        this._ab = new char[this._cb];
        for (int i = 0; i < this._cb && i < 32; ++i) {
            this._ab[i] = (char)this.bs2i(n + 2 * i + (this._mse == 5 ? 0 : 1), 2);
        }
        this._flags = (byte)(this.s2n(67 + n, 1) & 0xFF);
        this._leftSib = this.s2n(68 + n, 4);
        this._rightSib = this.s2n(72 + n, 4);
        this._child = this.s2n(76 + n, 4);
        this._id = new CLSID();
        this._id.fill(byArray, 80 + n);
        this._userFlags = this.s2n(96 + n, 4);
        this._timeCreate = this.s2n(100 + n, 8);
        this._timeModify = this.s2n(107 + n, 8);
        this._sectStart = this.s2n(116 + n, 4);
        this._size = this.s2n(120 + n, 4);
    }

    public String toString() {
        return "Directory " + types[this._mse] + " entry " + new String(this._ab, 0, this._cb) + ", mse " + this._mse + ", child " + this._child + ", left sib " + this._leftSib + ", right sib " + this._rightSib;
    }
}

