/*
 * Decompiled with CFR 0.152.
 */
package jwbroek.util;

import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringReplacer {
    private static final Logger logger = Logger.getLogger(StringReplacer.class.getCanonicalName());
    private Pattern replacementPattern;
    private Map<String, String> replacements;

    public StringReplacer(Map<String, String> map) {
        logger.entering(StringReplacer.class.getCanonicalName(), "StringReplacer(Map<String,String>)", map);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        boolean bl = true;
        for (String string : map.keySet()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append('|');
            }
            stringBuilder.append("(?:").append(Pattern.quote(string)).append(')');
        }
        stringBuilder.append(')');
        this.replacementPattern = Pattern.compile(stringBuilder.toString());
        this.replacements = map;
        logger.exiting(StringReplacer.class.getCanonicalName(), "StringReplacer(Map<String,String>)");
    }

    public String replace(String string) {
        logger.entering(StringReplacer.class.getCanonicalName(), "replace(String)", string);
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = this.replacementPattern.matcher(string);
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(this.replacements.get(matcher.group())));
        }
        matcher.appendTail(stringBuffer);
        String string2 = stringBuffer.toString();
        logger.entering(StringReplacer.class.getCanonicalName(), "replace(String)", string2);
        return string2;
    }
}

