/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.ui.flashgui;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskUIUtil;
import net.yura.domination.engine.core.StatType;
import net.yura.domination.engine.guishared.StatsPanel;
import net.yura.domination.engine.translation.TranslationBundle;
import net.yura.domination.ui.flashgui.FlashBorder;
import net.yura.domination.ui.flashgui.GameFrame;
import net.yura.domination.ui.flashgui.NewGameFrame;
import net.yura.swing.GraphicsUtil;

public class StatsDialog
extends JDialog
implements ActionListener {
    private static final StatType[] STAT_TYPES = new StatType[]{StatType.COUNTRIES, StatType.ARMIES, StatType.KILLS, StatType.CASUALTIES, StatType.REINFORCEMENTS, StatType.CONTINENTS, StatType.CONNECTED_EMPIRE, StatType.ATTACKS, StatType.COUNTRIES_WON, StatType.COUNTRIES_LOST, StatType.CARDS, StatType.DICE};
    private BufferedImage Back;
    private Risk myrisk;
    private StatsPanel graph;
    private ResourceBundle resb;
    private ButtonGroup group;

    public StatsDialog(Frame parent, boolean modal, Risk r) {
        super(parent, modal);
        this.myrisk = r;
        this.Back = RiskUIUtil.getUIImage(this.getClass(), "graph.jpg");
        this.initGUI();
        this.setResizable(false);
        this.pack();
    }

    private void initGUI() {
        this.resb = TranslationBundle.getBundle();
        this.setTitle(this.resb.getString("swing.tab.statistics"));
        JPanel thisgraph = new JPanel();
        thisgraph.setBorder(new FlashBorder(this.Back.getSubimage(100, 0, 740, 50), this.Back.getSubimage(0, 0, 50, 400), this.Back.getSubimage(100, 182, 740, 150), this.Back.getSubimage(50, 0, 50, 400)));
        Dimension d = GraphicsUtil.newDimension(740, 600);
        thisgraph.setPreferredSize(d);
        thisgraph.setMinimumSize(d);
        thisgraph.setMaximumSize(d);
        thisgraph.setLayout(null);
        this.group = new ButtonGroup();
        int x = 49;
        int y = 483;
        int w = 107;
        int h = 33;
        for (int c = 0; c < STAT_TYPES.length; ++c) {
            StatType statType = STAT_TYPES[c];
            thisgraph.add(this.makeButton(statType.getName(), x, y, w, h, statType.ordinal()));
            x += w;
            if (c != STAT_TYPES.length / 2 - 1) continue;
            x = 49;
            y += h;
        }
        ((AbstractButton)thisgraph.getComponent(0)).setSelected(true);
        this.graph = new StatsPanel(this.myrisk);
        GraphicsUtil.setBounds(this.graph, 50, 50, 640, 400);
        thisgraph.add(this.graph);
        this.getContentPane().add(thisgraph);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                StatsDialog.this.exitForm();
            }
        });
    }

    public void actionPerformed(ActionEvent a) {
        this.showGraph(StatType.fromOrdinal(Integer.parseInt(a.getActionCommand())));
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.showGraph(StatType.fromOrdinal(Integer.parseInt(this.group.getSelection().getActionCommand())));
        }
    }

    public void showGraph(StatType statType) {
        this.graph.repaintStats(statType);
        this.graph.repaint();
    }

    private void exitForm() {
        ((GameFrame)this.getParent()).displayGraph();
    }

    private AbstractButton makeButton(String a, int x, int y, int w, int h, int s) {
        JToggleButton statbutton = new JToggleButton(this.resb.getString("swing.toolbar." + a));
        statbutton.setActionCommand(s + "");
        statbutton.addActionListener(this);
        GraphicsUtil.setBounds(statbutton, x, y, w, h);
        this.group.add(statbutton);
        NewGameFrame.sortOutButton(statbutton, this.Back.getSubimage(x + 100, y - 433 + 165, w, h), this.Back.getSubimage(x + 100, y - 433, w, h), this.Back.getSubimage(x + 100, y - 433 + 66, w, h));
        return statbutton;
    }
}

