/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah.benchmark;

import com.googlecode.javaewah.benchmark.Benchmark;
import com.googlecode.javaewah.benchmark.ClusteredDataGenerator;
import com.googlecode.javaewah32.EWAHCompressedBitmap32;
import com.googlecode.javaewah32.FastAggregation32;
import com.googlecode.javaewah32.IteratingBufferedRunningLengthWord32;
import com.googlecode.javaewah32.IteratingRLW32;
import com.googlecode.javaewah32.IteratorAggregation32;
import com.googlecode.javaewah32.IteratorUtil32;
import java.text.DecimalFormat;

public class BenchmarkIntersection32 {
    public static void main(String[] args) {
        BenchmarkIntersection32.test(10, 18, 1);
    }

    public static void test(int N, int nbr, int repeat) {
        long bogus = 0L;
        DecimalFormat df = new DecimalFormat("0.###");
        ClusteredDataGenerator cdg = new ClusteredDataGenerator();
        for (int sparsity = 1; sparsity < 30 - nbr; ++sparsity) {
            for (int times = 0; times < 2; ++times) {
                Object[] ewahcp;
                int r;
                String line = "";
                line = line + sparsity;
                int[][] data = new int[N][];
                int Max2 = 1 << nbr + sparsity;
                int[] inter = cdg.generateClustered(1 << nbr / 2, Max2);
                for (int k = 0; k < N; ++k) {
                    data[k] = Benchmark.unite2by2(cdg.generateClustered(1 << nbr, Max2), inter);
                }
                EWAHCompressedBitmap32[] ewah = new EWAHCompressedBitmap32[N];
                for (int k = 0; k < N; ++k) {
                    ewah[k] = new EWAHCompressedBitmap32();
                    for (int x = 0; x < data[k].length; ++x) {
                        ewah[k].set(data[k][x]);
                    }
                    data[k] = null;
                }
                EWAHCompressedBitmap32 answer = ewah[0].and(ewah[1]);
                for (int k = 2; k < ewah.length; ++k) {
                    answer = answer.and(ewah[k]);
                }
                EWAHCompressedBitmap32 ewahand = EWAHCompressedBitmap32.and(ewah);
                if (!answer.equals(ewahand)) {
                    throw new RuntimeException("bug EWAHCompressedBitmap.and");
                }
                EWAHCompressedBitmap32 ewahand2 = FastAggregation32.bufferedand(65536, ewah);
                if (!ewahand.equals(ewahand2)) {
                    throw new RuntimeException("bug FastAggregation.bufferedand ");
                }
                long bef = System.currentTimeMillis();
                for (r = 0; r < repeat; ++r) {
                    for (int k = 0; k < N; ++k) {
                        EWAHCompressedBitmap32 ewahor = ewah[0];
                        for (int j = 1; j < k + 1; ++j) {
                            ewahor = ewahor.and(ewah[j]);
                        }
                    }
                }
                long aft = System.currentTimeMillis();
                line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
                bef = System.currentTimeMillis();
                for (r = 0; r < repeat; ++r) {
                    for (int k = 0; k < N; ++k) {
                        ewahcp = new EWAHCompressedBitmap32[k + 1];
                        for (int j = 0; j < k + 1; ++j) {
                            ewahcp[j] = ewah[j];
                        }
                        EWAHCompressedBitmap32 ewahor = EWAHCompressedBitmap32.and((EWAHCompressedBitmap32[])ewahcp);
                        bogus += (long)ewahor.sizeInBits();
                    }
                }
                aft = System.currentTimeMillis();
                line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
                bef = System.currentTimeMillis();
                for (r = 0; r < repeat; ++r) {
                    for (int k = 0; k < N; ++k) {
                        ewahcp = new EWAHCompressedBitmap32[k + 1];
                        for (int j = 0; j < k + 1; ++j) {
                            ewahcp[j] = ewah[j];
                        }
                        EWAHCompressedBitmap32 ewahor = FastAggregation32.bufferedand(65536, (EWAHCompressedBitmap32[])ewahcp);
                        bogus += (long)ewahor.sizeInBits();
                    }
                }
                aft = System.currentTimeMillis();
                line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
                bef = System.currentTimeMillis();
                for (r = 0; r < repeat; ++r) {
                    for (int k = 0; k < N; ++k) {
                        ewahcp = new IteratingRLW32[k + 1];
                        for (int j = 0; j < k + 1; ++j) {
                            ewahcp[j] = new IteratingBufferedRunningLengthWord32(ewah[j]);
                        }
                        IteratingRLW32 ewahor = IteratorAggregation32.bufferedand((IteratingRLW32[])ewahcp);
                        int wordcounter = IteratorUtil32.cardinality(ewahor);
                        bogus += (long)wordcounter;
                    }
                }
                aft = System.currentTimeMillis();
                line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
                System.out.println("# times for: 2by2 EWAHCompressedBitmap.and bufferedand iterator-bufferedand");
                System.out.println(line);
            }
            System.out.println("# bogus =" + bogus);
        }
    }
}

