------------------------------------------------------------------------------
--                              Ada Web Server                              --
--                                                                          --
--                      Copyright (C) 2024, AdaCore                         --
--                                                                          --
--  This is free software;  you can redistribute it  and/or modify it       --
--  under terms of the  GNU General Public License as published  by the     --
--  Free Software  Foundation;  either version 3,  or (at your option) any  --
--  later version.  This software is distributed in the hope  that it will  --
--  be useful, but WITHOUT ANY WARRANTY;  without even the implied warranty --
--  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU     --
--  General Public License for  more details.                               --
--                                                                          --
--  You should have  received  a copy of the GNU General  Public  License   --
--  distributed  with  this  software;   see  file COPYING3.  If not, go    --
--  to http://www.gnu.org/licenses for a complete copy of the license.      --
------------------------------------------------------------------------------

with SOAP.Types;

package WSDL_D is

   type Price is delta 0.01 digits 12 range 0.0 .. 1234.1;

   procedure Print_Price (P : Price);

   procedure Print (D : SOAP.Types.Decimal);

   function Image (D : SOAP.Types.Decimal) return String;

   type R is record
      D : SOAP.Types.Decimal;
      I : Integer;
   end record;

   procedure Call (O : R);

end WSDL_D;
