﻿#pragma once

#include "../../Common.h"

namespace Jazz2::Compatibility
{
    enum class JJ2Event : uint8_t {
        EMPTY = 0x00,

        // Base events
        MODIFIER_ONE_WAY = 0x01,
        MODIFIER_HURT = 0x02,
        MODIFIER_VINE = 0x03,
        MODIFIER_HOOK = 0x04,
        MODIFIER_SLIDE = 0x05,
        MODIFIER_H_POLE = 0x06,
        MODIFIER_V_POLE = 0x07,
        AREA_FLY_OFF = 0x08,
        MODIFIER_RICOCHET = 0x09,
        MODIFIER_BELT_RIGHT = 0x0A,
        MODIFIER_BELT_LEFT = 0x0B,
        MODIFIER_ACC_BELT_RIGHT = 0x0C,
        MODIFIER_ACC_BELT_LEFT = 0x0D,
        AREA_STOP_ENEMY = 0x0E,
        MODIFIER_WIND_LEFT = 0x0F,
        MODIFIER_WIND_RIGHT = 0x10,
        AREA_EOL = 0x11,
        AREA_EOL_WARP = 0x12,
        AREA_REVERT_MORPH = 0x13,
        AREA_FLOAT_UP = 0x14,
        TRIGGER_ROCK = 0x15,
        LIGHT_DIM = 0x16,
        LIGHT_SET = 0x17,
        AREA_LIMIT_X_SCROLL = 0x18,
        LIGHT_RESET = 0x19,
        AREA_SECRET_WARP = 0x1A,
        MODIFIER_ECHO = 0x1B,
        AREA_ACTIVATE_BOSS = 0x1C,
        JAZZ_LEVEL_START = 0x1D,
        SPAZ_LEVEL_START = 0x1E,
        MP_LEVEL_START = 0x1F,
        AMMO_FREEZER = 0x21,
        AMMO_BOUNCER = 0x22,
        AMMO_SEEKER = 0x23,
        AMMO_RF = 0x24,
        AMMO_TOASTER = 0x25,
        AMMO_TNT = 0x26,
        AMMO_PEPPER = 0x27,
        AMMO_ELECTRO = 0x28,
        TURTLE_SHELL = 0x29,
        SWINGING_VINE = 0x2A,
        SCENERY_BOMB = 0x2B,
        COIN_SILVER = 0x2C,
        COIN_GOLD = 0x2D,
        CRATE_AMMO = 0x2E,
        CRATE_CARROT = 0x2F,
        CRATE_ONEUP = 0x30,
        BARREL_GEM = 0x31,
        BARREL_CARROT = 0x32,
        BARREL_ONEUP = 0x33,
        CRATE_BOMB = 0x34,
        CRATE_AMMO_FREEZER = 0x35,
        CRATE_AMMO_BOUNCER = 0x36,
        CRATE_AMMO_SEEKER = 0x37,
        CRATE_AMMO_RF = 0x38,
        CRATE_AMMO_TOASTER = 0x39,
        SCENERY_TNT = 0x3A,
        AIRBOARD = 0x3B,
        SPRING_GREEN_FROZEN = 0x3C,
        FAST_FIRE = 0x3D,
        CRATE_SPRING = 0x3E,
        GEM_RED = 0x3F,
        GEM_GREEN = 0x40,
        GEM_BLUE = 0x41,
        GEM_PURPLE = 0x42,
        GEM_SUPER = 0x43,
        BIRDY = 0x44,
        BARREL_AMMO = 0x45,
        CRATE_GEM = 0x46,
        POWERUP_SWAP = 0x47,
        CARROT = 0x48,
        CARROT_FULL = 0x49,
        SHIELD_FIRE = 0x4A,
        SHIELD_WATER = 0x4B,
        SHIELD_LIGHTNING = 0x4C,
        MAX_WEAPON = 0x4D,
        AREA_AUTO_FIRE = 0x4E,
        FAST_FEET = 0x4F,
        ONEUP = 0x50,
        EOL_SIGN = 0x51,
        SAVE_POINT = 0x53,
        BONUS_SIGN = 0x54,
        SPRING_RED = 0x55,
        SPRING_GREEN = 0x56,
        SPRING_BLUE = 0x57,
        CARROT_INVINCIBLE = 0x58,
        SHIELD_TIME = 0x59,
        FREEZE = 0x5A,
        SPRING_RED_HOR = 0x5B,
        SPRING_GREEN_HOR = 0x5C,
        SPRING_BLUE_HOR = 0x5D,
        POWERUP_BIRD = 0x5E,
        TRIGGER_CRATE = 0x5F,
        CARROT_FLY = 0x60,
        GEM_RED_RECT = 0x61,
        GEM_GREEN_RECT = 0x62,
        GEM_BLUE_RECT = 0x63,
        ENEMY_TUF_TURT = 0x64,
        BOSS_TUF_TURT = 0x65,
        ENEMY_LAB_RAT = 0x66,
        ENEMY_DRAGON = 0x67,
        ENEMY_LIZARD = 0x68,
        ENEMY_BEE = 0x69,
        ENEMY_RAPIER = 0x6A,
        ENEMY_SPARKS = 0x6B,
        ENEMY_BAT = 0x6C,
        ENEMY_SUCKER = 0x6D,
        ENEMY_CATERPILLAR = 0x6E,
        CHESHIRE_HOOK = 0x6F,
        CHESHIRE_2 = 0x70,
        ENEMY_MADDER_HATTER = 0x71,
        BOSS_BILSY = 0x72,
        ENEMY_SKELETON = 0x73,
        ENEMY_DOGGY_DOGG = 0x74,
        ENEMY_TURTLE_NORMAL = 0x75,
        ENEMY_HELMUT = 0x76,
        LEAF = 0x77,
        ENEMY_DEMON = 0x78,
        FIRE = 0x79,
        LAVA = 0x7A,
        ENEMY_DRAGONFLY = 0x7B,
        ENEMY_MONKEY = 0x7C,
        ENEMY_FAT_CHICK = 0x7D,
        ENEMY_FENCER = 0x7E,
        ENEMY_FISH = 0x7F,
        MOTH = 0x80,
        STEAM = 0x81,
        ROTATING_ROCK = 0x82,
        POWERUP_BLASTER = 0x83,
        POWERUP_BOUNCER = 0x84,
        POWERUP_FREEZER = 0x85,
        POWERUP_SEEKER = 0x86,
        POWERUP_RF = 0x87,
        POWERUP_TOASTER = 0x88,
        PINBALL_PADDLE_L = 0x89,
        PINBALL_PADDLE_R = 0x8A,
        PINBALL_BUMP_500 = 0x8B,
        PINBALL_BUMP_CARROT = 0x8C,
        FOOD_APPLE = 0x8D,
        FOOD_BANANA = 0x8E,
        FOOD_CHERRY = 0x8F,
        FOOD_ORANGE = 0x90,
        FOOD_PEAR = 0x91,
        FOOD_PRETZEL = 0x92,
        FOOD_STRAWBERRY = 0x93,
        LIGHT_STEADY = 0x94,
        LIGHT_PULSE = 0x95,
        LIGHT_FLICKER = 0x96,
        BOSS_QUEEN = 0x97,
        ENEMY_SUCKER_FLOAT = 0x98,
        BRIDGE = 0x99,
        FOOD_LEMON = 0x9A,
        FOOD_LIME = 0x9B,
        FOOD_THING = 0x9C,
        FOOD_WATERMELON = 0x9D,
        FOOD_PEACH = 0x9E,
        FOOD_GRAPES = 0x9F,
        FOOD_LETTUCE = 0xA0,
        FOOD_EGGPLANT = 0xA1,
        FOOD_CUCUMBER = 0xA2,
        FOOD_PEPSI = 0xA3,
        FOOD_COKE = 0xA4,
        FOOD_MILK = 0xA5,
        FOOD_PIE = 0xA6,
        FOOD_CAKE = 0xA7,
        FOOD_DONUT = 0xA8,
        FOOD_CUPCAKE = 0xA9,
        FOOD_CHIPS = 0xAA,
        FOOD_CANDY = 0xAB,
        FOOD_CHOCOLATE = 0xAC,
        FOOD_ICE_CREAM = 0xAD,
        FOOD_BURGER = 0xAE,
        FOOD_PIZZA = 0xAF,
        FOOD_FRIES = 0xB0,
        FOOD_CHICKEN_LEG = 0xB1,
        FOOD_SANDWICH = 0xB2,
        FOOD_TACO = 0xB3,
        FOOD_HOT_DOG = 0xB4,
        FOOD_HAM = 0xB5,
        FOOD_CHEESE = 0xB6,
        ENEMY_LIZARD_FLOAT = 0xB7,
        ENEMY_MONKEY_STAND = 0xB8,
        SCENERY_DESTRUCT = 0xB9,
        SCENERY_DESTR_BOMB = 0xBA,
        SCENERY_COLLAPSE = 0xBB,
        SCENERY_BUTTSTOMP = 0xBC,
        SCENERY_GEMSTOMP = 0xBD,
        ENEMY_RAVEN = 0xBE,
        ENEMY_TURTLE_TUBE = 0xBF,
        GEM_RING = 0xC0,
        SMALL_TREE = 0xC1,
        AMBIENT_SOUND = 0xC2,
        BOSS_UTERUS = 0xC3,
        ENEMY_CRAB = 0xC4,
        ENEMY_WITCH = 0xC5,
        BOSS_TURTLE_ROCKET = 0xC6,
        BOSS_BUBBA = 0xC7,
        BOSS_DEVAN_DEVIL = 0xC8,
        BOSS_DEVAN_ROBOT = 0xC9,
        BOSS_ROBOT = 0xCA,
        POLE_CARROTUS = 0xCB,
        POLE_PSYCH = 0xCC,
        POLE_DIAMONDUS = 0xCD,
        MODIFIER_TUBE = 0xCE,
        AREA_TEXT = 0xCF,
        MODIFIER_SET_WATER = 0xD0,
        PLATFORM_FRUIT = 0xD1,
        PLATFORM_BOLL = 0xD2,
        PLATFORM_GRASS = 0xD3,
        PLATFORM_PINK = 0xD4,
        PLATFORM_SONIC = 0xD5,
        PLATFORM_SPIKE = 0xD6,
        BOLL_SPIKE = 0xD7,
        MODIFIER_GENERATOR = 0xD8,
        EVA = 0xD9,
        SCENERY_BUBBLER = 0xDA,
        POWERUP_TNT = 0xDB,
        POWERUP_PEPPER = 0xDC,
        POWERUP_ELECTRO = 0xDD,
        AREA_MORPH_FROG = 0xDE,
        BOLL_SPIKE_3D = 0xDF,
        SPRINGCORD = 0xE0,
        ENEMY_BEE_SWARM = 0xE1,
        COPTER = 0xE2,
        SHIELD_LASER = 0xE3,
        STOPWATCH = 0xE4,
        POLE_JUNGLE = 0xE5,
        WARP_ORIGIN = 0xE6,
        PUSHABLE_ROCK = 0xE7,
        PUSHABLE_BOX = 0xE8,
        WATER_BLOCK = 0xE9,
        TRIGGER_AREA = 0xEA,
        BOSS_BOLLY = 0xEB,
        ENEMY_BUTTERFLY = 0xEC,
        ENEMY_BEEBOY = 0xED,
        SNOW = 0xEE,
        WARP_TARGET = 0xF0,
        BOSS_TWEEDLE = 0xF1,
        AREA_ID = 0xF2,
        CTF_BASE = 0xF4,
        AREA_NO_FIRE = 0xF5,
        TRIGGER_ZONE = 0xF6,

        // TSF+ events
        LORI_LEVEL_START = 0x20,
        BILSY_DUMMY = 0xF7,
        ENEMY_NORMAL_TURTLE_XMAS = 0xF8,
        ENEMY_LIZARD_XMAS = 0xF9,
        ENEMY_LIZARD_FLOAT_XMAS = 0xFA,
        EMPTY_BOSS_BILSY_XMAS = 0xFB,
        EMPTY_TSF_DOG = 0xFC,
        EMPTY_TSF_GHOST = 0xFD,

        // Unassigned events
        EMPTY_82 = 0x52,
        EMPTY_239 = 0xEF,
        EMPTY_243 = 0xF3,
        EMPTY_254 = 0xFE,
        MCE = 0xFF
    };
}