#ifndef ATL_ztGetNB_geqrf

/*
 * NB selection for GEQRF: Side='RIGHT', Uplo='UPPER'
 * M : 25,202,380,424,469,513,558,602,647,691,736,780,825,869,914,1003,1092,1270,1448,2160,2872,4296,4385,4474,4563,4652,4741,4830,4919,4963,5008,5364,5720
 * N : 25,202,380,424,469,513,558,602,647,691,736,780,825,869,914,1003,1092,1270,1448,2160,2872,4296,4385,4474,4563,4652,4741,4830,4919,4963,5008,5364,5720
 * NB : 1,1,11,31,35,41,43,45,47,50,51,57,59,60,63,62,75,70,99,95,163,157,157,159,159,165,167,169,165,173,197,201,384
 */
#define ATL_ztGetNB_geqrf(n_, nb_) \
{ \
   if ((n_) < 291) (nb_) = 1; \
   else if ((n_) < 402) (nb_) = 11; \
   else if ((n_) < 446) (nb_) = 31; \
   else if ((n_) < 491) (nb_) = 35; \
   else if ((n_) < 535) (nb_) = 41; \
   else if ((n_) < 580) (nb_) = 43; \
   else if ((n_) < 624) (nb_) = 45; \
   else if ((n_) < 669) (nb_) = 47; \
   else if ((n_) < 713) (nb_) = 50; \
   else if ((n_) < 758) (nb_) = 51; \
   else if ((n_) < 802) (nb_) = 57; \
   else if ((n_) < 847) (nb_) = 59; \
   else if ((n_) < 891) (nb_) = 60; \
   else if ((n_) < 958) (nb_) = 63; \
   else if ((n_) < 1047) (nb_) = 62; \
   else if ((n_) < 1181) (nb_) = 75; \
   else if ((n_) < 1359) (nb_) = 70; \
   else if ((n_) < 1804) (nb_) = 99; \
   else if ((n_) < 2516) (nb_) = 95; \
   else if ((n_) < 3584) (nb_) = 163; \
   else if ((n_) < 4429) (nb_) = 157; \
   else if ((n_) < 4607) (nb_) = 159; \
   else if ((n_) < 4696) (nb_) = 165; \
   else if ((n_) < 4785) (nb_) = 167; \
   else if ((n_) < 4874) (nb_) = 169; \
   else if ((n_) < 4941) (nb_) = 165; \
   else if ((n_) < 4985) (nb_) = 173; \
   else if ((n_) < 5186) (nb_) = 197; \
   else if ((n_) < 5542) (nb_) = 201; \
   else (nb_) = 384; \
}


#endif    /* end ifndef ATL_ztGetNB_geqrf */
