// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "pdata/internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pprofile

import (
	"go.opentelemetry.io/collector/pdata/internal"
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1experimental"
)

// Label provided additional context for a sample
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewLabel function to create new instances.
// Important: zero-initialized instance is not valid for use.
type Label struct {
	orig  *otlpprofiles.Label
	state *internal.State
}

func newLabel(orig *otlpprofiles.Label, state *internal.State) Label {
	return Label{orig: orig, state: state}
}

// NewLabel creates a new empty Label.
//
// This must be used only in testing code. Users should use "AppendEmpty" when part of a Slice,
// OR directly access the member if this is embedded in another struct.
func NewLabel() Label {
	state := internal.StateMutable
	return newLabel(&otlpprofiles.Label{}, &state)
}

// MoveTo moves all properties from the current struct overriding the destination and
// resetting the current instance to its zero value
func (ms Label) MoveTo(dest Label) {
	ms.state.AssertMutable()
	dest.state.AssertMutable()
	*dest.orig = *ms.orig
	*ms.orig = otlpprofiles.Label{}
}

// Key returns the key associated with this Label.
func (ms Label) Key() int64 {
	return ms.orig.Key
}

// SetKey replaces the key associated with this Label.
func (ms Label) SetKey(v int64) {
	ms.state.AssertMutable()
	ms.orig.Key = v
}

// Str returns the str associated with this Label.
func (ms Label) Str() int64 {
	return ms.orig.Str
}

// SetStr replaces the str associated with this Label.
func (ms Label) SetStr(v int64) {
	ms.state.AssertMutable()
	ms.orig.Str = v
}

// Num returns the num associated with this Label.
func (ms Label) Num() int64 {
	return ms.orig.Num
}

// SetNum replaces the num associated with this Label.
func (ms Label) SetNum(v int64) {
	ms.state.AssertMutable()
	ms.orig.Num = v
}

// NumUnit returns the numunit associated with this Label.
func (ms Label) NumUnit() int64 {
	return ms.orig.NumUnit
}

// SetNumUnit replaces the numunit associated with this Label.
func (ms Label) SetNumUnit(v int64) {
	ms.state.AssertMutable()
	ms.orig.NumUnit = v
}

// CopyTo copies all properties from the current struct overriding the destination.
func (ms Label) CopyTo(dest Label) {
	dest.state.AssertMutable()
	dest.SetKey(ms.Key())
	dest.SetStr(ms.Str())
	dest.SetNum(ms.Num())
	dest.SetNumUnit(ms.NumUnit())
}
