/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.datetime;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;
import org.pentaho.reporting.libraries.formula.util.DateUtil;

public class WeekDayFunction
implements Function {
    private static final long serialVersionUID = -825027235225096201L;

    public String getCanonicalName() {
        return "WEEKDAY";
    }

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        if (parameters.getParameterCount() > 2) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = context.getTypeRegistry();
        Date d = typeRegistry.convertToDate(parameters.getType(0), parameters.getValue(0));
        int type = 1;
        if (parameters.getParameterCount() == 2) {
            Number n = typeRegistry.convertToNumber(parameters.getType(1), parameters.getValue(1));
            if (n == null) {
                throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
            }
            type = n.intValue();
            if (type < 1 || type > 3) {
                throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
            }
        }
        if (d == null) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        Calendar gc = DateUtil.createCalendar(d, context.getLocalizationContext());
        int dayOfWeek = gc.get(7);
        int result = this.convertType(dayOfWeek, type);
        return new TypeValuePair(NumberType.GENERIC_NUMBER, new BigDecimal((double)result));
    }

    public int convertType(int currentDayOfWeek, int type) {
        if (type == 1) {
            return currentDayOfWeek;
        }
        if (type == 2) {
            int i = (currentDayOfWeek + 6) % 8;
            if (i == 7) {
                return i;
            }
            return i + 1;
        }
        return (currentDayOfWeek + 5) % 7;
    }
}

