// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package tcp_response_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteTCPResponseRuleBackendAcceptedCode is the HTTP code returned for type DeleteTCPResponseRuleBackendAccepted
const DeleteTCPResponseRuleBackendAcceptedCode int = 202

/*
DeleteTCPResponseRuleBackendAccepted Configuration change accepted and reload requested

swagger:response deleteTcpResponseRuleBackendAccepted
*/
type DeleteTCPResponseRuleBackendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`
}

// NewDeleteTCPResponseRuleBackendAccepted creates DeleteTCPResponseRuleBackendAccepted with default headers values
func NewDeleteTCPResponseRuleBackendAccepted() *DeleteTCPResponseRuleBackendAccepted {

	return &DeleteTCPResponseRuleBackendAccepted{}
}

// WithReloadID adds the reloadId to the delete Tcp response rule backend accepted response
func (o *DeleteTCPResponseRuleBackendAccepted) WithReloadID(reloadID string) *DeleteTCPResponseRuleBackendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the delete Tcp response rule backend accepted response
func (o *DeleteTCPResponseRuleBackendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WriteResponse to the client
func (o *DeleteTCPResponseRuleBackendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(202)
}

// DeleteTCPResponseRuleBackendNoContentCode is the HTTP code returned for type DeleteTCPResponseRuleBackendNoContent
const DeleteTCPResponseRuleBackendNoContentCode int = 204

/*
DeleteTCPResponseRuleBackendNoContent TCP Response Rule deleted

swagger:response deleteTcpResponseRuleBackendNoContent
*/
type DeleteTCPResponseRuleBackendNoContent struct {
}

// NewDeleteTCPResponseRuleBackendNoContent creates DeleteTCPResponseRuleBackendNoContent with default headers values
func NewDeleteTCPResponseRuleBackendNoContent() *DeleteTCPResponseRuleBackendNoContent {

	return &DeleteTCPResponseRuleBackendNoContent{}
}

// WriteResponse to the client
func (o *DeleteTCPResponseRuleBackendNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteTCPResponseRuleBackendNotFoundCode is the HTTP code returned for type DeleteTCPResponseRuleBackendNotFound
const DeleteTCPResponseRuleBackendNotFoundCode int = 404

/*
DeleteTCPResponseRuleBackendNotFound The specified resource was not found

swagger:response deleteTcpResponseRuleBackendNotFound
*/
type DeleteTCPResponseRuleBackendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteTCPResponseRuleBackendNotFound creates DeleteTCPResponseRuleBackendNotFound with default headers values
func NewDeleteTCPResponseRuleBackendNotFound() *DeleteTCPResponseRuleBackendNotFound {

	return &DeleteTCPResponseRuleBackendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete Tcp response rule backend not found response
func (o *DeleteTCPResponseRuleBackendNotFound) WithConfigurationVersion(configurationVersion string) *DeleteTCPResponseRuleBackendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete Tcp response rule backend not found response
func (o *DeleteTCPResponseRuleBackendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete Tcp response rule backend not found response
func (o *DeleteTCPResponseRuleBackendNotFound) WithPayload(payload *models.Error) *DeleteTCPResponseRuleBackendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete Tcp response rule backend not found response
func (o *DeleteTCPResponseRuleBackendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteTCPResponseRuleBackendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteTCPResponseRuleBackendDefault General Error

swagger:response deleteTcpResponseRuleBackendDefault
*/
type DeleteTCPResponseRuleBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteTCPResponseRuleBackendDefault creates DeleteTCPResponseRuleBackendDefault with default headers values
func NewDeleteTCPResponseRuleBackendDefault(code int) *DeleteTCPResponseRuleBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteTCPResponseRuleBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete TCP response rule backend default response
func (o *DeleteTCPResponseRuleBackendDefault) WithStatusCode(code int) *DeleteTCPResponseRuleBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete TCP response rule backend default response
func (o *DeleteTCPResponseRuleBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete TCP response rule backend default response
func (o *DeleteTCPResponseRuleBackendDefault) WithConfigurationVersion(configurationVersion string) *DeleteTCPResponseRuleBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete TCP response rule backend default response
func (o *DeleteTCPResponseRuleBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete TCP response rule backend default response
func (o *DeleteTCPResponseRuleBackendDefault) WithPayload(payload *models.Error) *DeleteTCPResponseRuleBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete TCP response rule backend default response
func (o *DeleteTCPResponseRuleBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteTCPResponseRuleBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
