// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package maps

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetAllRuntimeMapFilesOKCode is the HTTP code returned for type GetAllRuntimeMapFilesOK
const GetAllRuntimeMapFilesOKCode int = 200

/*
GetAllRuntimeMapFilesOK Successful operation

swagger:response getAllRuntimeMapFilesOK
*/
type GetAllRuntimeMapFilesOK struct {

	/*
	  In: Body
	*/
	Payload models.Maps `json:"body,omitempty"`
}

// NewGetAllRuntimeMapFilesOK creates GetAllRuntimeMapFilesOK with default headers values
func NewGetAllRuntimeMapFilesOK() *GetAllRuntimeMapFilesOK {

	return &GetAllRuntimeMapFilesOK{}
}

// WithPayload adds the payload to the get all runtime map files o k response
func (o *GetAllRuntimeMapFilesOK) WithPayload(payload models.Maps) *GetAllRuntimeMapFilesOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all runtime map files o k response
func (o *GetAllRuntimeMapFilesOK) SetPayload(payload models.Maps) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllRuntimeMapFilesOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.Maps{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// GetAllRuntimeMapFilesNotFoundCode is the HTTP code returned for type GetAllRuntimeMapFilesNotFound
const GetAllRuntimeMapFilesNotFoundCode int = 404

/*
GetAllRuntimeMapFilesNotFound The specified resource was not found

swagger:response getAllRuntimeMapFilesNotFound
*/
type GetAllRuntimeMapFilesNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetAllRuntimeMapFilesNotFound creates GetAllRuntimeMapFilesNotFound with default headers values
func NewGetAllRuntimeMapFilesNotFound() *GetAllRuntimeMapFilesNotFound {

	return &GetAllRuntimeMapFilesNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the get all runtime map files not found response
func (o *GetAllRuntimeMapFilesNotFound) WithConfigurationVersion(configurationVersion string) *GetAllRuntimeMapFilesNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all runtime map files not found response
func (o *GetAllRuntimeMapFilesNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all runtime map files not found response
func (o *GetAllRuntimeMapFilesNotFound) WithPayload(payload *models.Error) *GetAllRuntimeMapFilesNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all runtime map files not found response
func (o *GetAllRuntimeMapFilesNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllRuntimeMapFilesNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetAllRuntimeMapFilesDefault General Error

swagger:response getAllRuntimeMapFilesDefault
*/
type GetAllRuntimeMapFilesDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetAllRuntimeMapFilesDefault creates GetAllRuntimeMapFilesDefault with default headers values
func NewGetAllRuntimeMapFilesDefault(code int) *GetAllRuntimeMapFilesDefault {
	if code <= 0 {
		code = 500
	}

	return &GetAllRuntimeMapFilesDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get all runtime map files default response
func (o *GetAllRuntimeMapFilesDefault) WithStatusCode(code int) *GetAllRuntimeMapFilesDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get all runtime map files default response
func (o *GetAllRuntimeMapFilesDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get all runtime map files default response
func (o *GetAllRuntimeMapFilesDefault) WithConfigurationVersion(configurationVersion string) *GetAllRuntimeMapFilesDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all runtime map files default response
func (o *GetAllRuntimeMapFilesDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all runtime map files default response
func (o *GetAllRuntimeMapFilesDefault) WithPayload(payload *models.Error) *GetAllRuntimeMapFilesDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all runtime map files default response
func (o *GetAllRuntimeMapFilesDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllRuntimeMapFilesDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
