// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package log_target

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceLogTargetFrontendOKCode is the HTTP code returned for type ReplaceLogTargetFrontendOK
const ReplaceLogTargetFrontendOKCode int = 200

/*
ReplaceLogTargetFrontendOK Log Target replaced

swagger:response replaceLogTargetFrontendOK
*/
type ReplaceLogTargetFrontendOK struct {

	/*
	  In: Body
	*/
	Payload *models.LogTarget `json:"body,omitempty"`
}

// NewReplaceLogTargetFrontendOK creates ReplaceLogTargetFrontendOK with default headers values
func NewReplaceLogTargetFrontendOK() *ReplaceLogTargetFrontendOK {

	return &ReplaceLogTargetFrontendOK{}
}

// WithPayload adds the payload to the replace log target frontend o k response
func (o *ReplaceLogTargetFrontendOK) WithPayload(payload *models.LogTarget) *ReplaceLogTargetFrontendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace log target frontend o k response
func (o *ReplaceLogTargetFrontendOK) SetPayload(payload *models.LogTarget) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceLogTargetFrontendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceLogTargetFrontendAcceptedCode is the HTTP code returned for type ReplaceLogTargetFrontendAccepted
const ReplaceLogTargetFrontendAcceptedCode int = 202

/*
ReplaceLogTargetFrontendAccepted Configuration change accepted and reload requested

swagger:response replaceLogTargetFrontendAccepted
*/
type ReplaceLogTargetFrontendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.LogTarget `json:"body,omitempty"`
}

// NewReplaceLogTargetFrontendAccepted creates ReplaceLogTargetFrontendAccepted with default headers values
func NewReplaceLogTargetFrontendAccepted() *ReplaceLogTargetFrontendAccepted {

	return &ReplaceLogTargetFrontendAccepted{}
}

// WithReloadID adds the reloadId to the replace log target frontend accepted response
func (o *ReplaceLogTargetFrontendAccepted) WithReloadID(reloadID string) *ReplaceLogTargetFrontendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace log target frontend accepted response
func (o *ReplaceLogTargetFrontendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace log target frontend accepted response
func (o *ReplaceLogTargetFrontendAccepted) WithPayload(payload *models.LogTarget) *ReplaceLogTargetFrontendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace log target frontend accepted response
func (o *ReplaceLogTargetFrontendAccepted) SetPayload(payload *models.LogTarget) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceLogTargetFrontendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceLogTargetFrontendBadRequestCode is the HTTP code returned for type ReplaceLogTargetFrontendBadRequest
const ReplaceLogTargetFrontendBadRequestCode int = 400

/*
ReplaceLogTargetFrontendBadRequest Bad request

swagger:response replaceLogTargetFrontendBadRequest
*/
type ReplaceLogTargetFrontendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceLogTargetFrontendBadRequest creates ReplaceLogTargetFrontendBadRequest with default headers values
func NewReplaceLogTargetFrontendBadRequest() *ReplaceLogTargetFrontendBadRequest {

	return &ReplaceLogTargetFrontendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace log target frontend bad request response
func (o *ReplaceLogTargetFrontendBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceLogTargetFrontendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace log target frontend bad request response
func (o *ReplaceLogTargetFrontendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace log target frontend bad request response
func (o *ReplaceLogTargetFrontendBadRequest) WithPayload(payload *models.Error) *ReplaceLogTargetFrontendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace log target frontend bad request response
func (o *ReplaceLogTargetFrontendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceLogTargetFrontendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceLogTargetFrontendNotFoundCode is the HTTP code returned for type ReplaceLogTargetFrontendNotFound
const ReplaceLogTargetFrontendNotFoundCode int = 404

/*
ReplaceLogTargetFrontendNotFound The specified resource was not found

swagger:response replaceLogTargetFrontendNotFound
*/
type ReplaceLogTargetFrontendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceLogTargetFrontendNotFound creates ReplaceLogTargetFrontendNotFound with default headers values
func NewReplaceLogTargetFrontendNotFound() *ReplaceLogTargetFrontendNotFound {

	return &ReplaceLogTargetFrontendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the replace log target frontend not found response
func (o *ReplaceLogTargetFrontendNotFound) WithConfigurationVersion(configurationVersion string) *ReplaceLogTargetFrontendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace log target frontend not found response
func (o *ReplaceLogTargetFrontendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace log target frontend not found response
func (o *ReplaceLogTargetFrontendNotFound) WithPayload(payload *models.Error) *ReplaceLogTargetFrontendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace log target frontend not found response
func (o *ReplaceLogTargetFrontendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceLogTargetFrontendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceLogTargetFrontendDefault General Error

swagger:response replaceLogTargetFrontendDefault
*/
type ReplaceLogTargetFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceLogTargetFrontendDefault creates ReplaceLogTargetFrontendDefault with default headers values
func NewReplaceLogTargetFrontendDefault(code int) *ReplaceLogTargetFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceLogTargetFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace log target frontend default response
func (o *ReplaceLogTargetFrontendDefault) WithStatusCode(code int) *ReplaceLogTargetFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace log target frontend default response
func (o *ReplaceLogTargetFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace log target frontend default response
func (o *ReplaceLogTargetFrontendDefault) WithConfigurationVersion(configurationVersion string) *ReplaceLogTargetFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace log target frontend default response
func (o *ReplaceLogTargetFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace log target frontend default response
func (o *ReplaceLogTargetFrontendDefault) WithPayload(payload *models.Error) *ReplaceLogTargetFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace log target frontend default response
func (o *ReplaceLogTargetFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceLogTargetFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
