// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package log_target

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetLogTargetPeerOKCode is the HTTP code returned for type GetLogTargetPeerOK
const GetLogTargetPeerOKCode int = 200

/*
GetLogTargetPeerOK Successful operation

swagger:response getLogTargetPeerOK
*/
type GetLogTargetPeerOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.LogTarget `json:"body,omitempty"`
}

// NewGetLogTargetPeerOK creates GetLogTargetPeerOK with default headers values
func NewGetLogTargetPeerOK() *GetLogTargetPeerOK {

	return &GetLogTargetPeerOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get log target peer o k response
func (o *GetLogTargetPeerOK) WithConfigurationVersion(configurationVersion string) *GetLogTargetPeerOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get log target peer o k response
func (o *GetLogTargetPeerOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get log target peer o k response
func (o *GetLogTargetPeerOK) WithPayload(payload *models.LogTarget) *GetLogTargetPeerOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get log target peer o k response
func (o *GetLogTargetPeerOK) SetPayload(payload *models.LogTarget) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetLogTargetPeerOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetLogTargetPeerNotFoundCode is the HTTP code returned for type GetLogTargetPeerNotFound
const GetLogTargetPeerNotFoundCode int = 404

/*
GetLogTargetPeerNotFound The specified resource was not found

swagger:response getLogTargetPeerNotFound
*/
type GetLogTargetPeerNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetLogTargetPeerNotFound creates GetLogTargetPeerNotFound with default headers values
func NewGetLogTargetPeerNotFound() *GetLogTargetPeerNotFound {

	return &GetLogTargetPeerNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the get log target peer not found response
func (o *GetLogTargetPeerNotFound) WithConfigurationVersion(configurationVersion string) *GetLogTargetPeerNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get log target peer not found response
func (o *GetLogTargetPeerNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get log target peer not found response
func (o *GetLogTargetPeerNotFound) WithPayload(payload *models.Error) *GetLogTargetPeerNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get log target peer not found response
func (o *GetLogTargetPeerNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetLogTargetPeerNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetLogTargetPeerDefault General Error

swagger:response getLogTargetPeerDefault
*/
type GetLogTargetPeerDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetLogTargetPeerDefault creates GetLogTargetPeerDefault with default headers values
func NewGetLogTargetPeerDefault(code int) *GetLogTargetPeerDefault {
	if code <= 0 {
		code = 500
	}

	return &GetLogTargetPeerDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get log target peer default response
func (o *GetLogTargetPeerDefault) WithStatusCode(code int) *GetLogTargetPeerDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get log target peer default response
func (o *GetLogTargetPeerDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get log target peer default response
func (o *GetLogTargetPeerDefault) WithConfigurationVersion(configurationVersion string) *GetLogTargetPeerDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get log target peer default response
func (o *GetLogTargetPeerDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get log target peer default response
func (o *GetLogTargetPeerDefault) WithPayload(payload *models.Error) *GetLogTargetPeerDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get log target peer default response
func (o *GetLogTargetPeerDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetLogTargetPeerDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
