// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package log_target

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// CreateLogTargetFrontendCreatedCode is the HTTP code returned for type CreateLogTargetFrontendCreated
const CreateLogTargetFrontendCreatedCode int = 201

/*
CreateLogTargetFrontendCreated Log Target created

swagger:response createLogTargetFrontendCreated
*/
type CreateLogTargetFrontendCreated struct {

	/*
	  In: Body
	*/
	Payload *models.LogTarget `json:"body,omitempty"`
}

// NewCreateLogTargetFrontendCreated creates CreateLogTargetFrontendCreated with default headers values
func NewCreateLogTargetFrontendCreated() *CreateLogTargetFrontendCreated {

	return &CreateLogTargetFrontendCreated{}
}

// WithPayload adds the payload to the create log target frontend created response
func (o *CreateLogTargetFrontendCreated) WithPayload(payload *models.LogTarget) *CreateLogTargetFrontendCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create log target frontend created response
func (o *CreateLogTargetFrontendCreated) SetPayload(payload *models.LogTarget) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateLogTargetFrontendCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateLogTargetFrontendAcceptedCode is the HTTP code returned for type CreateLogTargetFrontendAccepted
const CreateLogTargetFrontendAcceptedCode int = 202

/*
CreateLogTargetFrontendAccepted Configuration change accepted and reload requested

swagger:response createLogTargetFrontendAccepted
*/
type CreateLogTargetFrontendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.LogTarget `json:"body,omitempty"`
}

// NewCreateLogTargetFrontendAccepted creates CreateLogTargetFrontendAccepted with default headers values
func NewCreateLogTargetFrontendAccepted() *CreateLogTargetFrontendAccepted {

	return &CreateLogTargetFrontendAccepted{}
}

// WithReloadID adds the reloadId to the create log target frontend accepted response
func (o *CreateLogTargetFrontendAccepted) WithReloadID(reloadID string) *CreateLogTargetFrontendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the create log target frontend accepted response
func (o *CreateLogTargetFrontendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the create log target frontend accepted response
func (o *CreateLogTargetFrontendAccepted) WithPayload(payload *models.LogTarget) *CreateLogTargetFrontendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create log target frontend accepted response
func (o *CreateLogTargetFrontendAccepted) SetPayload(payload *models.LogTarget) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateLogTargetFrontendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateLogTargetFrontendBadRequestCode is the HTTP code returned for type CreateLogTargetFrontendBadRequest
const CreateLogTargetFrontendBadRequestCode int = 400

/*
CreateLogTargetFrontendBadRequest Bad request

swagger:response createLogTargetFrontendBadRequest
*/
type CreateLogTargetFrontendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateLogTargetFrontendBadRequest creates CreateLogTargetFrontendBadRequest with default headers values
func NewCreateLogTargetFrontendBadRequest() *CreateLogTargetFrontendBadRequest {

	return &CreateLogTargetFrontendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the create log target frontend bad request response
func (o *CreateLogTargetFrontendBadRequest) WithConfigurationVersion(configurationVersion string) *CreateLogTargetFrontendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create log target frontend bad request response
func (o *CreateLogTargetFrontendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create log target frontend bad request response
func (o *CreateLogTargetFrontendBadRequest) WithPayload(payload *models.Error) *CreateLogTargetFrontendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create log target frontend bad request response
func (o *CreateLogTargetFrontendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateLogTargetFrontendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateLogTargetFrontendConflictCode is the HTTP code returned for type CreateLogTargetFrontendConflict
const CreateLogTargetFrontendConflictCode int = 409

/*
CreateLogTargetFrontendConflict The specified resource already exists

swagger:response createLogTargetFrontendConflict
*/
type CreateLogTargetFrontendConflict struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateLogTargetFrontendConflict creates CreateLogTargetFrontendConflict with default headers values
func NewCreateLogTargetFrontendConflict() *CreateLogTargetFrontendConflict {

	return &CreateLogTargetFrontendConflict{}
}

// WithConfigurationVersion adds the configurationVersion to the create log target frontend conflict response
func (o *CreateLogTargetFrontendConflict) WithConfigurationVersion(configurationVersion string) *CreateLogTargetFrontendConflict {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create log target frontend conflict response
func (o *CreateLogTargetFrontendConflict) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create log target frontend conflict response
func (o *CreateLogTargetFrontendConflict) WithPayload(payload *models.Error) *CreateLogTargetFrontendConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create log target frontend conflict response
func (o *CreateLogTargetFrontendConflict) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateLogTargetFrontendConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
CreateLogTargetFrontendDefault General Error

swagger:response createLogTargetFrontendDefault
*/
type CreateLogTargetFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateLogTargetFrontendDefault creates CreateLogTargetFrontendDefault with default headers values
func NewCreateLogTargetFrontendDefault(code int) *CreateLogTargetFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &CreateLogTargetFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the create log target frontend default response
func (o *CreateLogTargetFrontendDefault) WithStatusCode(code int) *CreateLogTargetFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the create log target frontend default response
func (o *CreateLogTargetFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the create log target frontend default response
func (o *CreateLogTargetFrontendDefault) WithConfigurationVersion(configurationVersion string) *CreateLogTargetFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create log target frontend default response
func (o *CreateLogTargetFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create log target frontend default response
func (o *CreateLogTargetFrontendDefault) WithPayload(payload *models.Error) *CreateLogTargetFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create log target frontend default response
func (o *CreateLogTargetFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateLogTargetFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
