// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package log_forward

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceLogForwardOKCode is the HTTP code returned for type ReplaceLogForwardOK
const ReplaceLogForwardOKCode int = 200

/*
ReplaceLogForwardOK Log Forward replaced

swagger:response replaceLogForwardOK
*/
type ReplaceLogForwardOK struct {

	/*
	  In: Body
	*/
	Payload *models.LogForward `json:"body,omitempty"`
}

// NewReplaceLogForwardOK creates ReplaceLogForwardOK with default headers values
func NewReplaceLogForwardOK() *ReplaceLogForwardOK {

	return &ReplaceLogForwardOK{}
}

// WithPayload adds the payload to the replace log forward o k response
func (o *ReplaceLogForwardOK) WithPayload(payload *models.LogForward) *ReplaceLogForwardOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace log forward o k response
func (o *ReplaceLogForwardOK) SetPayload(payload *models.LogForward) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceLogForwardOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceLogForwardAcceptedCode is the HTTP code returned for type ReplaceLogForwardAccepted
const ReplaceLogForwardAcceptedCode int = 202

/*
ReplaceLogForwardAccepted Configuration change accepted and reload requested

swagger:response replaceLogForwardAccepted
*/
type ReplaceLogForwardAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.LogForward `json:"body,omitempty"`
}

// NewReplaceLogForwardAccepted creates ReplaceLogForwardAccepted with default headers values
func NewReplaceLogForwardAccepted() *ReplaceLogForwardAccepted {

	return &ReplaceLogForwardAccepted{}
}

// WithReloadID adds the reloadId to the replace log forward accepted response
func (o *ReplaceLogForwardAccepted) WithReloadID(reloadID string) *ReplaceLogForwardAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace log forward accepted response
func (o *ReplaceLogForwardAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace log forward accepted response
func (o *ReplaceLogForwardAccepted) WithPayload(payload *models.LogForward) *ReplaceLogForwardAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace log forward accepted response
func (o *ReplaceLogForwardAccepted) SetPayload(payload *models.LogForward) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceLogForwardAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceLogForwardBadRequestCode is the HTTP code returned for type ReplaceLogForwardBadRequest
const ReplaceLogForwardBadRequestCode int = 400

/*
ReplaceLogForwardBadRequest Bad request

swagger:response replaceLogForwardBadRequest
*/
type ReplaceLogForwardBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceLogForwardBadRequest creates ReplaceLogForwardBadRequest with default headers values
func NewReplaceLogForwardBadRequest() *ReplaceLogForwardBadRequest {

	return &ReplaceLogForwardBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace log forward bad request response
func (o *ReplaceLogForwardBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceLogForwardBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace log forward bad request response
func (o *ReplaceLogForwardBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace log forward bad request response
func (o *ReplaceLogForwardBadRequest) WithPayload(payload *models.Error) *ReplaceLogForwardBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace log forward bad request response
func (o *ReplaceLogForwardBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceLogForwardBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceLogForwardNotFoundCode is the HTTP code returned for type ReplaceLogForwardNotFound
const ReplaceLogForwardNotFoundCode int = 404

/*
ReplaceLogForwardNotFound The specified resource was not found

swagger:response replaceLogForwardNotFound
*/
type ReplaceLogForwardNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceLogForwardNotFound creates ReplaceLogForwardNotFound with default headers values
func NewReplaceLogForwardNotFound() *ReplaceLogForwardNotFound {

	return &ReplaceLogForwardNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the replace log forward not found response
func (o *ReplaceLogForwardNotFound) WithConfigurationVersion(configurationVersion string) *ReplaceLogForwardNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace log forward not found response
func (o *ReplaceLogForwardNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace log forward not found response
func (o *ReplaceLogForwardNotFound) WithPayload(payload *models.Error) *ReplaceLogForwardNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace log forward not found response
func (o *ReplaceLogForwardNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceLogForwardNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceLogForwardDefault General Error

swagger:response replaceLogForwardDefault
*/
type ReplaceLogForwardDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceLogForwardDefault creates ReplaceLogForwardDefault with default headers values
func NewReplaceLogForwardDefault(code int) *ReplaceLogForwardDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceLogForwardDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace log forward default response
func (o *ReplaceLogForwardDefault) WithStatusCode(code int) *ReplaceLogForwardDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace log forward default response
func (o *ReplaceLogForwardDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace log forward default response
func (o *ReplaceLogForwardDefault) WithConfigurationVersion(configurationVersion string) *ReplaceLogForwardDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace log forward default response
func (o *ReplaceLogForwardDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace log forward default response
func (o *ReplaceLogForwardDefault) WithPayload(payload *models.Error) *ReplaceLogForwardDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace log forward default response
func (o *ReplaceLogForwardDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceLogForwardDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
