// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_after_response_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteHTTPAfterResponseRuleFrontendAcceptedCode is the HTTP code returned for type DeleteHTTPAfterResponseRuleFrontendAccepted
const DeleteHTTPAfterResponseRuleFrontendAcceptedCode int = 202

/*
DeleteHTTPAfterResponseRuleFrontendAccepted Configuration change accepted and reload requested

swagger:response deleteHttpAfterResponseRuleFrontendAccepted
*/
type DeleteHTTPAfterResponseRuleFrontendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`
}

// NewDeleteHTTPAfterResponseRuleFrontendAccepted creates DeleteHTTPAfterResponseRuleFrontendAccepted with default headers values
func NewDeleteHTTPAfterResponseRuleFrontendAccepted() *DeleteHTTPAfterResponseRuleFrontendAccepted {

	return &DeleteHTTPAfterResponseRuleFrontendAccepted{}
}

// WithReloadID adds the reloadId to the delete Http after response rule frontend accepted response
func (o *DeleteHTTPAfterResponseRuleFrontendAccepted) WithReloadID(reloadID string) *DeleteHTTPAfterResponseRuleFrontendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the delete Http after response rule frontend accepted response
func (o *DeleteHTTPAfterResponseRuleFrontendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WriteResponse to the client
func (o *DeleteHTTPAfterResponseRuleFrontendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(202)
}

// DeleteHTTPAfterResponseRuleFrontendNoContentCode is the HTTP code returned for type DeleteHTTPAfterResponseRuleFrontendNoContent
const DeleteHTTPAfterResponseRuleFrontendNoContentCode int = 204

/*
DeleteHTTPAfterResponseRuleFrontendNoContent HTTP After Response Rule deleted

swagger:response deleteHttpAfterResponseRuleFrontendNoContent
*/
type DeleteHTTPAfterResponseRuleFrontendNoContent struct {
}

// NewDeleteHTTPAfterResponseRuleFrontendNoContent creates DeleteHTTPAfterResponseRuleFrontendNoContent with default headers values
func NewDeleteHTTPAfterResponseRuleFrontendNoContent() *DeleteHTTPAfterResponseRuleFrontendNoContent {

	return &DeleteHTTPAfterResponseRuleFrontendNoContent{}
}

// WriteResponse to the client
func (o *DeleteHTTPAfterResponseRuleFrontendNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteHTTPAfterResponseRuleFrontendNotFoundCode is the HTTP code returned for type DeleteHTTPAfterResponseRuleFrontendNotFound
const DeleteHTTPAfterResponseRuleFrontendNotFoundCode int = 404

/*
DeleteHTTPAfterResponseRuleFrontendNotFound The specified resource was not found

swagger:response deleteHttpAfterResponseRuleFrontendNotFound
*/
type DeleteHTTPAfterResponseRuleFrontendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteHTTPAfterResponseRuleFrontendNotFound creates DeleteHTTPAfterResponseRuleFrontendNotFound with default headers values
func NewDeleteHTTPAfterResponseRuleFrontendNotFound() *DeleteHTTPAfterResponseRuleFrontendNotFound {

	return &DeleteHTTPAfterResponseRuleFrontendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete Http after response rule frontend not found response
func (o *DeleteHTTPAfterResponseRuleFrontendNotFound) WithConfigurationVersion(configurationVersion string) *DeleteHTTPAfterResponseRuleFrontendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete Http after response rule frontend not found response
func (o *DeleteHTTPAfterResponseRuleFrontendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete Http after response rule frontend not found response
func (o *DeleteHTTPAfterResponseRuleFrontendNotFound) WithPayload(payload *models.Error) *DeleteHTTPAfterResponseRuleFrontendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete Http after response rule frontend not found response
func (o *DeleteHTTPAfterResponseRuleFrontendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteHTTPAfterResponseRuleFrontendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteHTTPAfterResponseRuleFrontendDefault General Error

swagger:response deleteHttpAfterResponseRuleFrontendDefault
*/
type DeleteHTTPAfterResponseRuleFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteHTTPAfterResponseRuleFrontendDefault creates DeleteHTTPAfterResponseRuleFrontendDefault with default headers values
func NewDeleteHTTPAfterResponseRuleFrontendDefault(code int) *DeleteHTTPAfterResponseRuleFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteHTTPAfterResponseRuleFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete HTTP after response rule frontend default response
func (o *DeleteHTTPAfterResponseRuleFrontendDefault) WithStatusCode(code int) *DeleteHTTPAfterResponseRuleFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete HTTP after response rule frontend default response
func (o *DeleteHTTPAfterResponseRuleFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete HTTP after response rule frontend default response
func (o *DeleteHTTPAfterResponseRuleFrontendDefault) WithConfigurationVersion(configurationVersion string) *DeleteHTTPAfterResponseRuleFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete HTTP after response rule frontend default response
func (o *DeleteHTTPAfterResponseRuleFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete HTTP after response rule frontend default response
func (o *DeleteHTTPAfterResponseRuleFrontendDefault) WithPayload(payload *models.Error) *DeleteHTTPAfterResponseRuleFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete HTTP after response rule frontend default response
func (o *DeleteHTTPAfterResponseRuleFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteHTTPAfterResponseRuleFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
