// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package group

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// CreateGroupCreatedCode is the HTTP code returned for type CreateGroupCreated
const CreateGroupCreatedCode int = 201

/*
CreateGroupCreated Group created

swagger:response createGroupCreated
*/
type CreateGroupCreated struct {

	/*
	  In: Body
	*/
	Payload *models.Group `json:"body,omitempty"`
}

// NewCreateGroupCreated creates CreateGroupCreated with default headers values
func NewCreateGroupCreated() *CreateGroupCreated {

	return &CreateGroupCreated{}
}

// WithPayload adds the payload to the create group created response
func (o *CreateGroupCreated) WithPayload(payload *models.Group) *CreateGroupCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create group created response
func (o *CreateGroupCreated) SetPayload(payload *models.Group) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateGroupCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateGroupAcceptedCode is the HTTP code returned for type CreateGroupAccepted
const CreateGroupAcceptedCode int = 202

/*
CreateGroupAccepted Configuration change accepted and reload requested

swagger:response createGroupAccepted
*/
type CreateGroupAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.Group `json:"body,omitempty"`
}

// NewCreateGroupAccepted creates CreateGroupAccepted with default headers values
func NewCreateGroupAccepted() *CreateGroupAccepted {

	return &CreateGroupAccepted{}
}

// WithReloadID adds the reloadId to the create group accepted response
func (o *CreateGroupAccepted) WithReloadID(reloadID string) *CreateGroupAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the create group accepted response
func (o *CreateGroupAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the create group accepted response
func (o *CreateGroupAccepted) WithPayload(payload *models.Group) *CreateGroupAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create group accepted response
func (o *CreateGroupAccepted) SetPayload(payload *models.Group) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateGroupAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateGroupBadRequestCode is the HTTP code returned for type CreateGroupBadRequest
const CreateGroupBadRequestCode int = 400

/*
CreateGroupBadRequest Bad request

swagger:response createGroupBadRequest
*/
type CreateGroupBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateGroupBadRequest creates CreateGroupBadRequest with default headers values
func NewCreateGroupBadRequest() *CreateGroupBadRequest {

	return &CreateGroupBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the create group bad request response
func (o *CreateGroupBadRequest) WithConfigurationVersion(configurationVersion string) *CreateGroupBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create group bad request response
func (o *CreateGroupBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create group bad request response
func (o *CreateGroupBadRequest) WithPayload(payload *models.Error) *CreateGroupBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create group bad request response
func (o *CreateGroupBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateGroupBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateGroupConflictCode is the HTTP code returned for type CreateGroupConflict
const CreateGroupConflictCode int = 409

/*
CreateGroupConflict The specified resource already exists

swagger:response createGroupConflict
*/
type CreateGroupConflict struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateGroupConflict creates CreateGroupConflict with default headers values
func NewCreateGroupConflict() *CreateGroupConflict {

	return &CreateGroupConflict{}
}

// WithConfigurationVersion adds the configurationVersion to the create group conflict response
func (o *CreateGroupConflict) WithConfigurationVersion(configurationVersion string) *CreateGroupConflict {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create group conflict response
func (o *CreateGroupConflict) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create group conflict response
func (o *CreateGroupConflict) WithPayload(payload *models.Error) *CreateGroupConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create group conflict response
func (o *CreateGroupConflict) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateGroupConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
CreateGroupDefault General Error

swagger:response createGroupDefault
*/
type CreateGroupDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateGroupDefault creates CreateGroupDefault with default headers values
func NewCreateGroupDefault(code int) *CreateGroupDefault {
	if code <= 0 {
		code = 500
	}

	return &CreateGroupDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the create group default response
func (o *CreateGroupDefault) WithStatusCode(code int) *CreateGroupDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the create group default response
func (o *CreateGroupDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the create group default response
func (o *CreateGroupDefault) WithConfigurationVersion(configurationVersion string) *CreateGroupDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create group default response
func (o *CreateGroupDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create group default response
func (o *CreateGroupDefault) WithPayload(payload *models.Error) *CreateGroupDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create group default response
func (o *CreateGroupDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateGroupDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
