// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package filter

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetFilterBackendOKCode is the HTTP code returned for type GetFilterBackendOK
const GetFilterBackendOKCode int = 200

/*
GetFilterBackendOK Successful operation

swagger:response getFilterBackendOK
*/
type GetFilterBackendOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Filter `json:"body,omitempty"`
}

// NewGetFilterBackendOK creates GetFilterBackendOK with default headers values
func NewGetFilterBackendOK() *GetFilterBackendOK {

	return &GetFilterBackendOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get filter backend o k response
func (o *GetFilterBackendOK) WithConfigurationVersion(configurationVersion string) *GetFilterBackendOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get filter backend o k response
func (o *GetFilterBackendOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get filter backend o k response
func (o *GetFilterBackendOK) WithPayload(payload *models.Filter) *GetFilterBackendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get filter backend o k response
func (o *GetFilterBackendOK) SetPayload(payload *models.Filter) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetFilterBackendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetFilterBackendNotFoundCode is the HTTP code returned for type GetFilterBackendNotFound
const GetFilterBackendNotFoundCode int = 404

/*
GetFilterBackendNotFound The specified resource was not found

swagger:response getFilterBackendNotFound
*/
type GetFilterBackendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetFilterBackendNotFound creates GetFilterBackendNotFound with default headers values
func NewGetFilterBackendNotFound() *GetFilterBackendNotFound {

	return &GetFilterBackendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the get filter backend not found response
func (o *GetFilterBackendNotFound) WithConfigurationVersion(configurationVersion string) *GetFilterBackendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get filter backend not found response
func (o *GetFilterBackendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get filter backend not found response
func (o *GetFilterBackendNotFound) WithPayload(payload *models.Error) *GetFilterBackendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get filter backend not found response
func (o *GetFilterBackendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetFilterBackendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetFilterBackendDefault General Error

swagger:response getFilterBackendDefault
*/
type GetFilterBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetFilterBackendDefault creates GetFilterBackendDefault with default headers values
func NewGetFilterBackendDefault(code int) *GetFilterBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &GetFilterBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get filter backend default response
func (o *GetFilterBackendDefault) WithStatusCode(code int) *GetFilterBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get filter backend default response
func (o *GetFilterBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get filter backend default response
func (o *GetFilterBackendDefault) WithConfigurationVersion(configurationVersion string) *GetFilterBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get filter backend default response
func (o *GetFilterBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get filter backend default response
func (o *GetFilterBackendDefault) WithPayload(payload *models.Error) *GetFilterBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get filter backend default response
func (o *GetFilterBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetFilterBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
