// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package crt_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetCrtStoresOKCode is the HTTP code returned for type GetCrtStoresOK
const GetCrtStoresOKCode int = 200

/*
GetCrtStoresOK Successful operation

swagger:response getCrtStoresOK
*/
type GetCrtStoresOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload models.CrtStores `json:"body,omitempty"`
}

// NewGetCrtStoresOK creates GetCrtStoresOK with default headers values
func NewGetCrtStoresOK() *GetCrtStoresOK {

	return &GetCrtStoresOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get crt stores o k response
func (o *GetCrtStoresOK) WithConfigurationVersion(configurationVersion string) *GetCrtStoresOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get crt stores o k response
func (o *GetCrtStoresOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get crt stores o k response
func (o *GetCrtStoresOK) WithPayload(payload models.CrtStores) *GetCrtStoresOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get crt stores o k response
func (o *GetCrtStoresOK) SetPayload(payload models.CrtStores) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetCrtStoresOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.CrtStores{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
GetCrtStoresDefault General Error

swagger:response getCrtStoresDefault
*/
type GetCrtStoresDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetCrtStoresDefault creates GetCrtStoresDefault with default headers values
func NewGetCrtStoresDefault(code int) *GetCrtStoresDefault {
	if code <= 0 {
		code = 500
	}

	return &GetCrtStoresDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get crt stores default response
func (o *GetCrtStoresDefault) WithStatusCode(code int) *GetCrtStoresDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get crt stores default response
func (o *GetCrtStoresDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get crt stores default response
func (o *GetCrtStoresDefault) WithConfigurationVersion(configurationVersion string) *GetCrtStoresDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get crt stores default response
func (o *GetCrtStoresDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get crt stores default response
func (o *GetCrtStoresDefault) WithPayload(payload *models.Error) *GetCrtStoresDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get crt stores default response
func (o *GetCrtStoresDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetCrtStoresDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
