// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package crt_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetCrtStoreOKCode is the HTTP code returned for type GetCrtStoreOK
const GetCrtStoreOKCode int = 200

/*
GetCrtStoreOK Successful operation

swagger:response getCrtStoreOK
*/
type GetCrtStoreOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.CrtStore `json:"body,omitempty"`
}

// NewGetCrtStoreOK creates GetCrtStoreOK with default headers values
func NewGetCrtStoreOK() *GetCrtStoreOK {

	return &GetCrtStoreOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get crt store o k response
func (o *GetCrtStoreOK) WithConfigurationVersion(configurationVersion string) *GetCrtStoreOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get crt store o k response
func (o *GetCrtStoreOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get crt store o k response
func (o *GetCrtStoreOK) WithPayload(payload *models.CrtStore) *GetCrtStoreOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get crt store o k response
func (o *GetCrtStoreOK) SetPayload(payload *models.CrtStore) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetCrtStoreOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetCrtStoreNotFoundCode is the HTTP code returned for type GetCrtStoreNotFound
const GetCrtStoreNotFoundCode int = 404

/*
GetCrtStoreNotFound The specified resource was not found

swagger:response getCrtStoreNotFound
*/
type GetCrtStoreNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetCrtStoreNotFound creates GetCrtStoreNotFound with default headers values
func NewGetCrtStoreNotFound() *GetCrtStoreNotFound {

	return &GetCrtStoreNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the get crt store not found response
func (o *GetCrtStoreNotFound) WithConfigurationVersion(configurationVersion string) *GetCrtStoreNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get crt store not found response
func (o *GetCrtStoreNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get crt store not found response
func (o *GetCrtStoreNotFound) WithPayload(payload *models.Error) *GetCrtStoreNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get crt store not found response
func (o *GetCrtStoreNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetCrtStoreNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetCrtStoreDefault General Error

swagger:response getCrtStoreDefault
*/
type GetCrtStoreDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetCrtStoreDefault creates GetCrtStoreDefault with default headers values
func NewGetCrtStoreDefault(code int) *GetCrtStoreDefault {
	if code <= 0 {
		code = 500
	}

	return &GetCrtStoreDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get crt store default response
func (o *GetCrtStoreDefault) WithStatusCode(code int) *GetCrtStoreDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get crt store default response
func (o *GetCrtStoreDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get crt store default response
func (o *GetCrtStoreDefault) WithConfigurationVersion(configurationVersion string) *GetCrtStoreDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get crt store default response
func (o *GetCrtStoreDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get crt store default response
func (o *GetCrtStoreDefault) WithPayload(payload *models.Error) *GetCrtStoreDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get crt store default response
func (o *GetCrtStoreDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetCrtStoreDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
