// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package backend_switching_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceBackendSwitchingRulesOKCode is the HTTP code returned for type ReplaceBackendSwitchingRulesOK
const ReplaceBackendSwitchingRulesOKCode int = 200

/*
ReplaceBackendSwitchingRulesOK All Backend Switching Rule lines replaced

swagger:response replaceBackendSwitchingRulesOK
*/
type ReplaceBackendSwitchingRulesOK struct {

	/*
	  In: Body
	*/
	Payload models.BackendSwitchingRules `json:"body,omitempty"`
}

// NewReplaceBackendSwitchingRulesOK creates ReplaceBackendSwitchingRulesOK with default headers values
func NewReplaceBackendSwitchingRulesOK() *ReplaceBackendSwitchingRulesOK {

	return &ReplaceBackendSwitchingRulesOK{}
}

// WithPayload adds the payload to the replace backend switching rules o k response
func (o *ReplaceBackendSwitchingRulesOK) WithPayload(payload models.BackendSwitchingRules) *ReplaceBackendSwitchingRulesOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace backend switching rules o k response
func (o *ReplaceBackendSwitchingRulesOK) SetPayload(payload models.BackendSwitchingRules) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceBackendSwitchingRulesOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.BackendSwitchingRules{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceBackendSwitchingRulesAcceptedCode is the HTTP code returned for type ReplaceBackendSwitchingRulesAccepted
const ReplaceBackendSwitchingRulesAcceptedCode int = 202

/*
ReplaceBackendSwitchingRulesAccepted Configuration change accepted and reload requested

swagger:response replaceBackendSwitchingRulesAccepted
*/
type ReplaceBackendSwitchingRulesAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload models.BackendSwitchingRules `json:"body,omitempty"`
}

// NewReplaceBackendSwitchingRulesAccepted creates ReplaceBackendSwitchingRulesAccepted with default headers values
func NewReplaceBackendSwitchingRulesAccepted() *ReplaceBackendSwitchingRulesAccepted {

	return &ReplaceBackendSwitchingRulesAccepted{}
}

// WithReloadID adds the reloadId to the replace backend switching rules accepted response
func (o *ReplaceBackendSwitchingRulesAccepted) WithReloadID(reloadID string) *ReplaceBackendSwitchingRulesAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace backend switching rules accepted response
func (o *ReplaceBackendSwitchingRulesAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace backend switching rules accepted response
func (o *ReplaceBackendSwitchingRulesAccepted) WithPayload(payload models.BackendSwitchingRules) *ReplaceBackendSwitchingRulesAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace backend switching rules accepted response
func (o *ReplaceBackendSwitchingRulesAccepted) SetPayload(payload models.BackendSwitchingRules) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceBackendSwitchingRulesAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.BackendSwitchingRules{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceBackendSwitchingRulesBadRequestCode is the HTTP code returned for type ReplaceBackendSwitchingRulesBadRequest
const ReplaceBackendSwitchingRulesBadRequestCode int = 400

/*
ReplaceBackendSwitchingRulesBadRequest Bad request

swagger:response replaceBackendSwitchingRulesBadRequest
*/
type ReplaceBackendSwitchingRulesBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceBackendSwitchingRulesBadRequest creates ReplaceBackendSwitchingRulesBadRequest with default headers values
func NewReplaceBackendSwitchingRulesBadRequest() *ReplaceBackendSwitchingRulesBadRequest {

	return &ReplaceBackendSwitchingRulesBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace backend switching rules bad request response
func (o *ReplaceBackendSwitchingRulesBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceBackendSwitchingRulesBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace backend switching rules bad request response
func (o *ReplaceBackendSwitchingRulesBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace backend switching rules bad request response
func (o *ReplaceBackendSwitchingRulesBadRequest) WithPayload(payload *models.Error) *ReplaceBackendSwitchingRulesBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace backend switching rules bad request response
func (o *ReplaceBackendSwitchingRulesBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceBackendSwitchingRulesBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceBackendSwitchingRulesDefault General Error

swagger:response replaceBackendSwitchingRulesDefault
*/
type ReplaceBackendSwitchingRulesDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceBackendSwitchingRulesDefault creates ReplaceBackendSwitchingRulesDefault with default headers values
func NewReplaceBackendSwitchingRulesDefault(code int) *ReplaceBackendSwitchingRulesDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceBackendSwitchingRulesDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace backend switching rules default response
func (o *ReplaceBackendSwitchingRulesDefault) WithStatusCode(code int) *ReplaceBackendSwitchingRulesDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace backend switching rules default response
func (o *ReplaceBackendSwitchingRulesDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace backend switching rules default response
func (o *ReplaceBackendSwitchingRulesDefault) WithConfigurationVersion(configurationVersion string) *ReplaceBackendSwitchingRulesDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace backend switching rules default response
func (o *ReplaceBackendSwitchingRulesDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace backend switching rules default response
func (o *ReplaceBackendSwitchingRulesDefault) WithPayload(payload *models.Error) *ReplaceBackendSwitchingRulesDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace backend switching rules default response
func (o *ReplaceBackendSwitchingRulesDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceBackendSwitchingRulesDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
