/*  Pasang Emas. Enjoy a unique traditional game of Brunei.
    Copyright (C) 2018  Nor Jaidi Tuah

    This file is part of Pasang Emas.
      
    Pasang Emas is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

namespace Pasang {

public class PasangApplication : Gtk.Application {

    public PasangApplication () {
        Object (application_id: "bn.pasang.pasang-emas", flags: ApplicationFlags.FLAGS_NONE);
    }

    public override void startup () {
        base.startup ();
    }

    protected override void activate () {
        var main_window = new Gtk.ApplicationWindow (this);
        add_css (main_window.get_screen ());
        try {
            var file = Reloc.icons_dir + "/pasang-emas.png";
            main_window.set_icon_from_file (file);
        }
        catch (Error e) {
            stderr.printf ("File error: %s\n", e.message);
        }
        main_window.add (new Pasang.Window (main_window));
        main_window.show_all ();
    }

    private void add_css (Gdk.Screen screen) {
        var style = new Gtk.CssProvider ();
        try {
            style.load_from_data (css);
        }
        catch (Error e) {
            stderr.printf("CSS error: %s\n", e.message);
        }
        Gtk.StyleContext.add_provider_for_screen (screen, style, Gtk.STYLE_PROVIDER_PRIORITY_USER);
    }

    private string css = """
        .box-top-level {
            padding: 20px;
        }
        .listbox-menu {
            border: 0.25px solid;
        }
        .listbox-menu-item {
            padding: 10px 20px 10px 20px;
        }
        treeview :not(:selected) {
            background-color: transparent;
        }
    """;
}//PasangApplication
}//namespace

// vim: tabstop=4: expandtab: textwidth=100: autoindent:
