<?php
	// Project:    Web Reference Database (refbase) <http://www.refbase.net>
	// Copyright:  Matthias Steffens <mailto:refbase@extracts.de> and the file's
	//             original author(s).
	//
	//             This code is distributed in the hope that it will be useful,
	//             but WITHOUT ANY WARRANTY. Please see the GNU General Public
	//             License for more details.
	//
	// File:       ./includes/export.inc.php
	// Repository: $HeadURL: file:///svn/p/refbase/code/branches/bleeding-edge/includes/export.inc.php $
	// Author(s):  Matthias Steffens <mailto:refbase@extracts.de>
	//
	// Created:    09-May-06, 15:34
	// Modified:   $Date: 2007-02-17 01:10:14 +0000 (Sat, 17 Feb 2007) $
	//             $Author: msteffens $
	//             $Revision: 894 $

	// This file contains functions
	// that are used when exporting
	// records from the database.


	include 'includes/transtab_refbase_bibtex.inc.php'; // include refbase markup -> BibTeX search & replace patterns

	if (($convertExportDataToUTF8 == "no") AND ($contentTypeCharset != "UTF-8")) // variables '$convertExportDataToUTF8' & '$contentTypeCharset' are defined in 'ini.inc.php'
		include_once 'includes/transtab_latin1_bibtex.inc.php'; // include Latin1 -> LaTeX/BibTeX translation table
	else
		include_once 'includes/transtab_unicode_bibtex.inc.php'; // include Unicode -> LaTeX/BibTeX translation table

	// --------------------------------------------------------------------

	// This function takes a BibTeX file (as generated by bibutils) and
	// converts any contained refbase markup into proper LaTeX/BibTeX markup:
	function standardizeBibtexOutput($bibtexSourceText)
	{
		global $contentTypeCharset; // these variables are defined in 'ini.inc.php'
		global $convertExportDataToUTF8;

		// The array '$transtab_refbase_bibtex' contains search & replace patterns for conversion from refbase markup to LaTeX/BibTeX markup & entities.
		// Converts refbase fontshape markup (italic, bold) into LaTeX commands of the 'textcomp' package, super- and subscript as well as greek
		// letters get converted into the respective commands in math mode. You may need to adopt the LaTeX markup to suit your individual needs.
		global $transtab_refbase_bibtex; // defined in 'transtab_refbase_bibtex.inc.php'

		// The arrays '$transtab_latin1_bibtex' and '$transtab_unicode_bibtex' provide translation tables for best-effort conversion of higher ASCII
		// characters from ISO-8859-1 (or Unicode, respectively) to LaTeX/BibTeX entities.
		global $transtab_latin1_bibtex; // defined in 'transtab_latin1_bibtex.inc.php'
		global $transtab_unicode_bibtex; // defined in 'transtab_unicode_bibtex.inc.php'

		// Perform search & replace actions on the given BibTeX text:
		$bibtexSourceText = searchReplaceText($transtab_refbase_bibtex, $bibtexSourceText, true); // function 'searchReplaceText()' is defined in 'include.inc.php'

		// Attempt to convert higher ASCII chars that were NOT converted by bibutils to their corresponding LaTeX/BibTeX entities:
		if (($convertExportDataToUTF8 == "no") AND ($contentTypeCharset != "UTF-8"))
			$bibtexSourceText = searchReplaceText($transtab_latin1_bibtex, $bibtexSourceText, false);
		else
			$bibtexSourceText = searchReplaceText($transtab_unicode_bibtex, $bibtexSourceText, false);

		return $bibtexSourceText;
	}

	// --------------------------------------------------------------------
?>
