/****************************************************************************
* VCGLib                                                            o o     *
* Visual and Computer Graphics Library                            o     o   *
*                                                                _   O  _   *
* Copyright(C) 2004-2016                                           \/)\/    *
* Visual Computing Lab                                            /\/|      *
* ISTI - Italian National Research Council                           |      *
*                                                                    \      *
* All rights reserved.                                                      *
*                                                                           *
* This program is free software; you can redistribute it and/or modify      *
* it under the terms of the GNU General Public License as published by      *
* the Free Software Foundation; either version 2 of the License, or         *
* (at your option) any later version.                                       *
*                                                                           *
* This program is distributed in the hope that it will be useful,           *
* but WITHOUT ANY WARRANTY; without even the implied warranty of            *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
* GNU General Public License (http://www.gnu.org/licenses/gpl.txt)          *
* for more details.                                                         *
*                                                                           *
****************************************************************************/
#include<vcg/complex/complex.h>

#include <wrap/io_trimesh/export_obj.h>
#include <vcg/complex/algorithms/update/texture.h>
#include <vcg/complex/algorithms/create/platonic.h>

/*! \file trimesh_texture_clean.cpp
\ingroup code_sample

\brief a small example about removing fake texture seams eventually generated by rounding error in a texture param  

*/

using namespace vcg;

class MyEdge;
class MyFace;
class MyVertex;
struct MyUsedTypes : public UsedTypes<	Use<MyVertex>::AsVertexType, Use<MyFace>::AsFaceType>{};

class MyVertex  : public Vertex< MyUsedTypes, vertex::Coord3f, vertex::VFAdj, vertex::Normal3f, vertex::BitFlags  >{};
class MyFace    : public Face  < MyUsedTypes, face::VertexRef, face::VFAdj, face::WedgeTexCoord2f, face::Mark, face::BitFlags > {};
class MyMesh    : public tri::TriMesh< std::vector<MyVertex>, std::vector<MyFace > >{};


int main(int ,char ** )
{
  MyMesh m;
  int mask = tri::io::Mask::IOM_WEDGTEXCOORD;
  
  // generate a simple 2D grid 
  Grid(m,20,20,1,1);
  // assign it a simple planar parametrization 
  tri:UpdateTexture<MyMesh>::WedgeTexFromPlane(m,Point3f(1.0f,0,0),Point3f(0,1.0f,0),true);
  tri::io::ExporterOBJ<MyMesh>::Save(m,"grid_0.obj",mask);
  
  // randomly perturb a few coord textures introducing fake seams
  for(MyFace &f : m.face)
  {
    for(int i=0;i<3;++i)
      if(rand()%20==0)
      {
        f.WT(i).U()+=0.0000001;
        f.WT(i).V()-=0.0000001;
      }
  }
  tri::io::ExporterOBJ<MyMesh>::Save(m,"grid_1.obj",mask);
    
  // Merge texture coords that very close
  tri::UpdateTopology<MyMesh>::VertexFace(m);
  tri::UpdateTexture<MyMesh>::WedgeTexMergeClose(m);
  
  tri::io::ExporterOBJ<MyMesh>::Save(m,"grid_2.obj",mask);
    
  return 0;
}

