/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.UnrecoverableExceptions;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.IterationOrder;

class CompositeTestExecutionListener
implements TestExecutionListener {
    private static final Logger logger = LoggerFactory.getLogger(CompositeTestExecutionListener.class);
    private final List<TestExecutionListener> testExecutionListeners;
    private final List<EagerTestExecutionListener> eagerTestExecutionListeners;

    CompositeTestExecutionListener(List<TestExecutionListener> testExecutionListeners) {
        this.testExecutionListeners = new ArrayList<TestExecutionListener>(testExecutionListeners);
        this.eagerTestExecutionListeners = this.testExecutionListeners.stream().filter(EagerTestExecutionListener.class::isInstance).map(EagerTestExecutionListener.class::cast).collect(Collectors.toList());
    }

    @Override
    public void dynamicTestRegistered(TestIdentifier testIdentifier) {
        CompositeTestExecutionListener.notifyEach(this.testExecutionListeners, IterationOrder.ORIGINAL, listener -> listener.dynamicTestRegistered(testIdentifier), () -> "dynamicTestRegistered(" + testIdentifier + ")");
    }

    @Override
    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        CompositeTestExecutionListener.notifyEach(this.testExecutionListeners, IterationOrder.ORIGINAL, listener -> listener.executionSkipped(testIdentifier, reason), () -> "executionSkipped(" + testIdentifier + ", " + reason + ")");
    }

    @Override
    public void executionStarted(TestIdentifier testIdentifier) {
        CompositeTestExecutionListener.notifyEach(this.eagerTestExecutionListeners, IterationOrder.ORIGINAL, listener -> listener.executionJustStarted(testIdentifier), () -> "executionJustStarted(" + testIdentifier + ")");
        CompositeTestExecutionListener.notifyEach(this.testExecutionListeners, IterationOrder.ORIGINAL, listener -> listener.executionStarted(testIdentifier), () -> "executionStarted(" + testIdentifier + ")");
    }

    @Override
    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        CompositeTestExecutionListener.notifyEach(this.eagerTestExecutionListeners, IterationOrder.REVERSED, listener -> listener.executionJustFinished(testIdentifier, testExecutionResult), () -> "executionJustFinished(" + testIdentifier + ", " + testExecutionResult + ")");
        CompositeTestExecutionListener.notifyEach(this.testExecutionListeners, IterationOrder.REVERSED, listener -> listener.executionFinished(testIdentifier, testExecutionResult), () -> "executionFinished(" + testIdentifier + ", " + testExecutionResult + ")");
    }

    @Override
    public void testPlanExecutionStarted(TestPlan testPlan) {
        CompositeTestExecutionListener.notifyEach(this.testExecutionListeners, IterationOrder.ORIGINAL, listener -> listener.testPlanExecutionStarted(testPlan), () -> "testPlanExecutionStarted(" + testPlan + ")");
    }

    @Override
    public void testPlanExecutionFinished(TestPlan testPlan) {
        CompositeTestExecutionListener.notifyEach(this.testExecutionListeners, IterationOrder.REVERSED, listener -> listener.testPlanExecutionFinished(testPlan), () -> "testPlanExecutionFinished(" + testPlan + ")");
    }

    @Override
    public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry entry) {
        CompositeTestExecutionListener.notifyEach(this.testExecutionListeners, IterationOrder.ORIGINAL, listener -> listener.reportingEntryPublished(testIdentifier, entry), () -> "reportingEntryPublished(" + testIdentifier + ", " + entry + ")");
    }

    private static <T extends TestExecutionListener> void notifyEach(List<T> listeners, IterationOrder iterationOrder, Consumer<T> consumer, Supplier<String> description) {
        iterationOrder.forEach(listeners, listener -> {
            try {
                consumer.accept(listener);
            }
            catch (Throwable throwable) {
                UnrecoverableExceptions.rethrowIfUnrecoverable((Throwable)throwable);
                logger.warn(throwable, () -> CompositeTestExecutionListener.lambda$notifyEach$18(listener, (Supplier)description));
            }
        });
    }

    private static /* synthetic */ String lambda$notifyEach$18(TestExecutionListener listener, Supplier description) {
        return String.format("TestExecutionListener [%s] threw exception for method: %s", listener.getClass().getName(), description.get());
    }

    static interface EagerTestExecutionListener
    extends TestExecutionListener {
        default public void executionJustStarted(TestIdentifier testIdentifier) {
        }

        default public void executionJustFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        }
    }
}

