'''OpenGL extension NV.draw_vulkan_image

This module customises the behaviour of the 
OpenGL.raw.GLES2.NV.draw_vulkan_image to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension provides a new function, DrawVkImageNV(), allowing
	applications to draw a screen-aligned rectangle displaying some or all of
	the contents of a two-dimensional Vulkan VkImage.  Callers specify a
	Vulkan VkImage handle, an optional OpenGL sampler object, window
	coordinates of the rectangle to draw, and texture coordinates corresponding
	to the corners of the rectangle.  For each fragment produced by the
	rectangle, DrawVkImageNV  interpolates the texture coordinates, performs
	a texture lookup, and uses the texture result as the fragment color.
	
	No shaders are used by DrawVkImageNV; the results of the texture lookup
	are used in lieu of a fragment shader output.  The fragments generated are
	processed by all per-fragment operations.  In particular,
	DrawVkImageNV() fully supports blending and multisampling.
	
	In order to synchronize between Vulkan and OpenGL there are three other
	functions provided; WaitVkSemaphoreNV(), SignalVkSemaphoreNV() and
	SignalVkFenceNV().  These allow OpenGL to wait for Vulkan to complete work
	and also Vulkan to wait for OpenGL to complete work.  Together OpenGL
	and Vulkan can synchronize on the server without application
	interation.
	
	Finally the function GetVkProcAddrNV() is provided to allow the OpenGL
	context to query the Vulkan entry points directly and avoid having to
	load them through the typical Vulkan loader.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/draw_vulkan_image.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.NV.draw_vulkan_image import *
from OpenGL.raw.GLES2.NV.draw_vulkan_image import _EXTENSION_NAME

def glInitDrawVulkanImageNV():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glGetVkProcAddrNV.name size not checked against 'name'
glGetVkProcAddrNV=wrapper.wrapper(glGetVkProcAddrNV).setInputArraySize(
    'name', None
)
### END AUTOGENERATED SECTION