// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/support/v2/comment_service.proto

#include "google/cloud/support/v2/comment_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace support_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

CommentServiceClient::CommentServiceClient(
    std::shared_ptr<CommentServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
CommentServiceClient::~CommentServiceClient() = default;

StreamRange<google::cloud::support::v2::Comment>
CommentServiceClient::ListComments(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::support::v2::ListCommentsRequest request;
  request.set_parent(parent);
  return connection_->ListComments(request);
}

StreamRange<google::cloud::support::v2::Comment>
CommentServiceClient::ListComments(
    google::cloud::support::v2::ListCommentsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListComments(std::move(request));
}

StatusOr<google::cloud::support::v2::Comment>
CommentServiceClient::CreateComment(
    std::string const& parent,
    google::cloud::support::v2::Comment const& comment, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::support::v2::CreateCommentRequest request;
  request.set_parent(parent);
  *request.mutable_comment() = comment;
  return connection_->CreateComment(request);
}

StatusOr<google::cloud::support::v2::Comment>
CommentServiceClient::CreateComment(
    google::cloud::support::v2::CreateCommentRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateComment(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace support_v2
}  // namespace cloud
}  // namespace google
