// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/storage/control/v2/storage_control.proto

#include "google/cloud/storagecontrol/v2/internal/storage_control_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <google/storage/control/v2/storage_control.grpc.pb.h>
#include <memory>
#include <set>
#include <string>
#include <utility>

namespace google {
namespace cloud {
namespace storagecontrol_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

StorageControlLogging::StorageControlLogging(
    std::shared_ptr<StorageControlStub> child, TracingOptions tracing_options,
    std::set<std::string> const&)
    : child_(std::move(child)), tracing_options_(std::move(tracing_options)) {}

StatusOr<google::storage::control::v2::Folder>
StorageControlLogging::CreateFolder(
    grpc::ClientContext& context, Options const& options,
    google::storage::control::v2::CreateFolderRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::storage::control::v2::CreateFolderRequest const& request) {
        return child_->CreateFolder(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

Status StorageControlLogging::DeleteFolder(
    grpc::ClientContext& context, Options const& options,
    google::storage::control::v2::DeleteFolderRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::storage::control::v2::DeleteFolderRequest const& request) {
        return child_->DeleteFolder(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::storage::control::v2::Folder> StorageControlLogging::GetFolder(
    grpc::ClientContext& context, Options const& options,
    google::storage::control::v2::GetFolderRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::storage::control::v2::GetFolderRequest const& request) {
        return child_->GetFolder(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::storage::control::v2::ListFoldersResponse>
StorageControlLogging::ListFolders(
    grpc::ClientContext& context, Options const& options,
    google::storage::control::v2::ListFoldersRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::storage::control::v2::ListFoldersRequest const& request) {
        return child_->ListFolders(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
StorageControlLogging::AsyncRenameFolder(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::storage::control::v2::RenameFolderRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::storage::control::v2::RenameFolderRequest const& request) {
        return child_->AsyncRenameFolder(cq, std::move(context),
                                         std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> StorageControlLogging::RenameFolder(
    grpc::ClientContext& context, Options options,
    google::storage::control::v2::RenameFolderRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::storage::control::v2::RenameFolderRequest const& request) {
        return child_->RenameFolder(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::storage::control::v2::StorageLayout>
StorageControlLogging::GetStorageLayout(
    grpc::ClientContext& context, Options const& options,
    google::storage::control::v2::GetStorageLayoutRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::storage::control::v2::GetStorageLayoutRequest const&
                 request) {
        return child_->GetStorageLayout(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::storage::control::v2::ManagedFolder>
StorageControlLogging::CreateManagedFolder(
    grpc::ClientContext& context, Options const& options,
    google::storage::control::v2::CreateManagedFolderRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::storage::control::v2::CreateManagedFolderRequest const&
                 request) {
        return child_->CreateManagedFolder(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

Status StorageControlLogging::DeleteManagedFolder(
    grpc::ClientContext& context, Options const& options,
    google::storage::control::v2::DeleteManagedFolderRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::storage::control::v2::DeleteManagedFolderRequest const&
                 request) {
        return child_->DeleteManagedFolder(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::storage::control::v2::ManagedFolder>
StorageControlLogging::GetManagedFolder(
    grpc::ClientContext& context, Options const& options,
    google::storage::control::v2::GetManagedFolderRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::storage::control::v2::GetManagedFolderRequest const&
                 request) {
        return child_->GetManagedFolder(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::storage::control::v2::ListManagedFoldersResponse>
StorageControlLogging::ListManagedFolders(
    grpc::ClientContext& context, Options const& options,
    google::storage::control::v2::ListManagedFoldersRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::storage::control::v2::ListManagedFoldersRequest const&
                 request) {
        return child_->ListManagedFolders(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
StorageControlLogging::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::longrunning::GetOperationRequest const& request) {
        return child_->AsyncGetOperation(cq, std::move(context),
                                         std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

future<Status> StorageControlLogging::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::longrunning::CancelOperationRequest const& request) {
        return child_->AsyncCancelOperation(cq, std::move(context),
                                            std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace storagecontrol_v2_internal
}  // namespace cloud
}  // namespace google
