// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/recaptchaenterprise/v1/recaptchaenterprise.proto

#include "google/cloud/recaptchaenterprise/v1/internal/recaptcha_enterprise_metadata_decorator.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/url_encode.h"
#include "google/cloud/status_or.h"
#include <google/cloud/recaptchaenterprise/v1/recaptchaenterprise.grpc.pb.h>
#include <memory>
#include <string>
#include <utility>
#include <vector>

namespace google {
namespace cloud {
namespace recaptchaenterprise_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

RecaptchaEnterpriseServiceMetadata::RecaptchaEnterpriseServiceMetadata(
    std::shared_ptr<RecaptchaEnterpriseServiceStub> child,
    std::multimap<std::string, std::string> fixed_metadata,
    std::string api_client_header)
    : child_(std::move(child)),
      fixed_metadata_(std::move(fixed_metadata)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

StatusOr<google::cloud::recaptchaenterprise::v1::Assessment>
RecaptchaEnterpriseServiceMetadata::CreateAssessment(
    grpc::ClientContext& context, Options const& options,
    google::cloud::recaptchaenterprise::v1::CreateAssessmentRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateAssessment(context, options, request);
}

StatusOr<google::cloud::recaptchaenterprise::v1::AnnotateAssessmentResponse>
RecaptchaEnterpriseServiceMetadata::AnnotateAssessment(
    grpc::ClientContext& context, Options const& options,
    google::cloud::recaptchaenterprise::v1::AnnotateAssessmentRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AnnotateAssessment(context, options, request);
}

StatusOr<google::cloud::recaptchaenterprise::v1::Key>
RecaptchaEnterpriseServiceMetadata::CreateKey(
    grpc::ClientContext& context, Options const& options,
    google::cloud::recaptchaenterprise::v1::CreateKeyRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateKey(context, options, request);
}

StatusOr<google::cloud::recaptchaenterprise::v1::ListKeysResponse>
RecaptchaEnterpriseServiceMetadata::ListKeys(
    grpc::ClientContext& context, Options const& options,
    google::cloud::recaptchaenterprise::v1::ListKeysRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListKeys(context, options, request);
}

StatusOr<
    google::cloud::recaptchaenterprise::v1::RetrieveLegacySecretKeyResponse>
RecaptchaEnterpriseServiceMetadata::RetrieveLegacySecretKey(
    grpc::ClientContext& context, Options const& options,
    google::cloud::recaptchaenterprise::v1::
        RetrieveLegacySecretKeyRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("key=", internal::UrlEncode(request.key())));
  return child_->RetrieveLegacySecretKey(context, options, request);
}

StatusOr<google::cloud::recaptchaenterprise::v1::Key>
RecaptchaEnterpriseServiceMetadata::GetKey(
    grpc::ClientContext& context, Options const& options,
    google::cloud::recaptchaenterprise::v1::GetKeyRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetKey(context, options, request);
}

StatusOr<google::cloud::recaptchaenterprise::v1::Key>
RecaptchaEnterpriseServiceMetadata::UpdateKey(
    grpc::ClientContext& context, Options const& options,
    google::cloud::recaptchaenterprise::v1::UpdateKeyRequest const& request) {
  SetMetadata(
      context, options,
      absl::StrCat("key.name=", internal::UrlEncode(request.key().name())));
  return child_->UpdateKey(context, options, request);
}

Status RecaptchaEnterpriseServiceMetadata::DeleteKey(
    grpc::ClientContext& context, Options const& options,
    google::cloud::recaptchaenterprise::v1::DeleteKeyRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteKey(context, options, request);
}

StatusOr<google::cloud::recaptchaenterprise::v1::Key>
RecaptchaEnterpriseServiceMetadata::MigrateKey(
    grpc::ClientContext& context, Options const& options,
    google::cloud::recaptchaenterprise::v1::MigrateKeyRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->MigrateKey(context, options, request);
}

StatusOr<google::cloud::recaptchaenterprise::v1::AddIpOverrideResponse>
RecaptchaEnterpriseServiceMetadata::AddIpOverride(
    grpc::ClientContext& context, Options const& options,
    google::cloud::recaptchaenterprise::v1::AddIpOverrideRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AddIpOverride(context, options, request);
}

StatusOr<google::cloud::recaptchaenterprise::v1::Metrics>
RecaptchaEnterpriseServiceMetadata::GetMetrics(
    grpc::ClientContext& context, Options const& options,
    google::cloud::recaptchaenterprise::v1::GetMetricsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetMetrics(context, options, request);
}

StatusOr<google::cloud::recaptchaenterprise::v1::FirewallPolicy>
RecaptchaEnterpriseServiceMetadata::CreateFirewallPolicy(
    grpc::ClientContext& context, Options const& options,
    google::cloud::recaptchaenterprise::v1::CreateFirewallPolicyRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateFirewallPolicy(context, options, request);
}

StatusOr<google::cloud::recaptchaenterprise::v1::ListFirewallPoliciesResponse>
RecaptchaEnterpriseServiceMetadata::ListFirewallPolicies(
    grpc::ClientContext& context, Options const& options,
    google::cloud::recaptchaenterprise::v1::ListFirewallPoliciesRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListFirewallPolicies(context, options, request);
}

StatusOr<google::cloud::recaptchaenterprise::v1::FirewallPolicy>
RecaptchaEnterpriseServiceMetadata::GetFirewallPolicy(
    grpc::ClientContext& context, Options const& options,
    google::cloud::recaptchaenterprise::v1::GetFirewallPolicyRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetFirewallPolicy(context, options, request);
}

StatusOr<google::cloud::recaptchaenterprise::v1::FirewallPolicy>
RecaptchaEnterpriseServiceMetadata::UpdateFirewallPolicy(
    grpc::ClientContext& context, Options const& options,
    google::cloud::recaptchaenterprise::v1::UpdateFirewallPolicyRequest const&
        request) {
  SetMetadata(
      context, options,
      absl::StrCat("firewall_policy.name=",
                   internal::UrlEncode(request.firewall_policy().name())));
  return child_->UpdateFirewallPolicy(context, options, request);
}

Status RecaptchaEnterpriseServiceMetadata::DeleteFirewallPolicy(
    grpc::ClientContext& context, Options const& options,
    google::cloud::recaptchaenterprise::v1::DeleteFirewallPolicyRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteFirewallPolicy(context, options, request);
}

StatusOr<
    google::cloud::recaptchaenterprise::v1::ReorderFirewallPoliciesResponse>
RecaptchaEnterpriseServiceMetadata::ReorderFirewallPolicies(
    grpc::ClientContext& context, Options const& options,
    google::cloud::recaptchaenterprise::v1::
        ReorderFirewallPoliciesRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ReorderFirewallPolicies(context, options, request);
}

StatusOr<
    google::cloud::recaptchaenterprise::v1::ListRelatedAccountGroupsResponse>
RecaptchaEnterpriseServiceMetadata::ListRelatedAccountGroups(
    grpc::ClientContext& context, Options const& options,
    google::cloud::recaptchaenterprise::v1::
        ListRelatedAccountGroupsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListRelatedAccountGroups(context, options, request);
}

StatusOr<google::cloud::recaptchaenterprise::v1::
             ListRelatedAccountGroupMembershipsResponse>
RecaptchaEnterpriseServiceMetadata::ListRelatedAccountGroupMemberships(
    grpc::ClientContext& context, Options const& options,
    google::cloud::recaptchaenterprise::v1::
        ListRelatedAccountGroupMembershipsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListRelatedAccountGroupMemberships(context, options, request);
}

StatusOr<google::cloud::recaptchaenterprise::v1::
             SearchRelatedAccountGroupMembershipsResponse>
RecaptchaEnterpriseServiceMetadata::SearchRelatedAccountGroupMemberships(
    grpc::ClientContext& context, Options const& options,
    google::cloud::recaptchaenterprise::v1::
        SearchRelatedAccountGroupMembershipsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("project=", internal::UrlEncode(request.project())));
  return child_->SearchRelatedAccountGroupMemberships(context, options,
                                                      request);
}

void RecaptchaEnterpriseServiceMetadata::SetMetadata(
    grpc::ClientContext& context, Options const& options,
    std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context, options);
}

void RecaptchaEnterpriseServiceMetadata::SetMetadata(
    grpc::ClientContext& context, Options const& options) {
  google::cloud::internal::SetMetadata(context, options, fixed_metadata_,
                                       api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace recaptchaenterprise_v1_internal
}  // namespace cloud
}  // namespace google
