// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/pubsub/v1/schema.proto

#include "google/cloud/pubsub/internal/schema_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace pubsub_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

SchemaServiceTracingConnection::SchemaServiceTracingConnection(
    std::shared_ptr<pubsub::SchemaServiceConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::pubsub::v1::Schema>
SchemaServiceTracingConnection::CreateSchema(
    google::pubsub::v1::CreateSchemaRequest const& request) {
  auto span =
      internal::MakeSpan("pubsub::SchemaServiceConnection::CreateSchema");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateSchema(request));
}

StatusOr<google::pubsub::v1::Schema> SchemaServiceTracingConnection::GetSchema(
    google::pubsub::v1::GetSchemaRequest const& request) {
  auto span = internal::MakeSpan("pubsub::SchemaServiceConnection::GetSchema");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetSchema(request));
}

StreamRange<google::pubsub::v1::Schema>
SchemaServiceTracingConnection::ListSchemas(
    google::pubsub::v1::ListSchemasRequest request) {
  auto span =
      internal::MakeSpan("pubsub::SchemaServiceConnection::ListSchemas");
  internal::OTelScope scope(span);
  auto sr = child_->ListSchemas(std::move(request));
  return internal::MakeTracedStreamRange<google::pubsub::v1::Schema>(
      std::move(span), std::move(sr));
}

StreamRange<google::pubsub::v1::Schema>
SchemaServiceTracingConnection::ListSchemaRevisions(
    google::pubsub::v1::ListSchemaRevisionsRequest request) {
  auto span = internal::MakeSpan(
      "pubsub::SchemaServiceConnection::ListSchemaRevisions");
  internal::OTelScope scope(span);
  auto sr = child_->ListSchemaRevisions(std::move(request));
  return internal::MakeTracedStreamRange<google::pubsub::v1::Schema>(
      std::move(span), std::move(sr));
}

StatusOr<google::pubsub::v1::Schema>
SchemaServiceTracingConnection::CommitSchema(
    google::pubsub::v1::CommitSchemaRequest const& request) {
  auto span =
      internal::MakeSpan("pubsub::SchemaServiceConnection::CommitSchema");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CommitSchema(request));
}

StatusOr<google::pubsub::v1::Schema>
SchemaServiceTracingConnection::RollbackSchema(
    google::pubsub::v1::RollbackSchemaRequest const& request) {
  auto span =
      internal::MakeSpan("pubsub::SchemaServiceConnection::RollbackSchema");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->RollbackSchema(request));
}

StatusOr<google::pubsub::v1::Schema>
SchemaServiceTracingConnection::DeleteSchemaRevision(
    google::pubsub::v1::DeleteSchemaRevisionRequest const& request) {
  auto span = internal::MakeSpan(
      "pubsub::SchemaServiceConnection::DeleteSchemaRevision");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteSchemaRevision(request));
}

Status SchemaServiceTracingConnection::DeleteSchema(
    google::pubsub::v1::DeleteSchemaRequest const& request) {
  auto span =
      internal::MakeSpan("pubsub::SchemaServiceConnection::DeleteSchema");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteSchema(request));
}

StatusOr<google::pubsub::v1::ValidateSchemaResponse>
SchemaServiceTracingConnection::ValidateSchema(
    google::pubsub::v1::ValidateSchemaRequest const& request) {
  auto span =
      internal::MakeSpan("pubsub::SchemaServiceConnection::ValidateSchema");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->ValidateSchema(request));
}

StatusOr<google::pubsub::v1::ValidateMessageResponse>
SchemaServiceTracingConnection::ValidateMessage(
    google::pubsub::v1::ValidateMessageRequest const& request) {
  auto span =
      internal::MakeSpan("pubsub::SchemaServiceConnection::ValidateMessage");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->ValidateMessage(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<pubsub::SchemaServiceConnection>
MakeSchemaServiceTracingConnection(
    std::shared_ptr<pubsub::SchemaServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<SchemaServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace pubsub_internal
}  // namespace cloud
}  // namespace google
