// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/osconfig/v1/osconfig_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_OSCONFIG_V1_INTERNAL_OS_CONFIG_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_OSCONFIG_V1_INTERNAL_OS_CONFIG_TRACING_CONNECTION_H

#include "google/cloud/osconfig/v1/os_config_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace osconfig_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class OsConfigServiceTracingConnection
    : public osconfig_v1::OsConfigServiceConnection {
 public:
  ~OsConfigServiceTracingConnection() override = default;

  explicit OsConfigServiceTracingConnection(
      std::shared_ptr<osconfig_v1::OsConfigServiceConnection> child);

  Options options() override { return child_->options(); }

  StatusOr<google::cloud::osconfig::v1::PatchJob> ExecutePatchJob(
      google::cloud::osconfig::v1::ExecutePatchJobRequest const& request)
      override;

  StatusOr<google::cloud::osconfig::v1::PatchJob> GetPatchJob(
      google::cloud::osconfig::v1::GetPatchJobRequest const& request) override;

  StatusOr<google::cloud::osconfig::v1::PatchJob> CancelPatchJob(
      google::cloud::osconfig::v1::CancelPatchJobRequest const& request)
      override;

  StreamRange<google::cloud::osconfig::v1::PatchJob> ListPatchJobs(
      google::cloud::osconfig::v1::ListPatchJobsRequest request) override;

  StreamRange<google::cloud::osconfig::v1::PatchJobInstanceDetails>
  ListPatchJobInstanceDetails(
      google::cloud::osconfig::v1::ListPatchJobInstanceDetailsRequest request)
      override;

  StatusOr<google::cloud::osconfig::v1::PatchDeployment> CreatePatchDeployment(
      google::cloud::osconfig::v1::CreatePatchDeploymentRequest const& request)
      override;

  StatusOr<google::cloud::osconfig::v1::PatchDeployment> GetPatchDeployment(
      google::cloud::osconfig::v1::GetPatchDeploymentRequest const& request)
      override;

  StreamRange<google::cloud::osconfig::v1::PatchDeployment>
  ListPatchDeployments(google::cloud::osconfig::v1::ListPatchDeploymentsRequest
                           request) override;

  Status DeletePatchDeployment(
      google::cloud::osconfig::v1::DeletePatchDeploymentRequest const& request)
      override;

  StatusOr<google::cloud::osconfig::v1::PatchDeployment> UpdatePatchDeployment(
      google::cloud::osconfig::v1::UpdatePatchDeploymentRequest const& request)
      override;

  StatusOr<google::cloud::osconfig::v1::PatchDeployment> PausePatchDeployment(
      google::cloud::osconfig::v1::PausePatchDeploymentRequest const& request)
      override;

  StatusOr<google::cloud::osconfig::v1::PatchDeployment> ResumePatchDeployment(
      google::cloud::osconfig::v1::ResumePatchDeploymentRequest const& request)
      override;

 private:
  std::shared_ptr<osconfig_v1::OsConfigServiceConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<osconfig_v1::OsConfigServiceConnection>
MakeOsConfigServiceTracingConnection(
    std::shared_ptr<osconfig_v1::OsConfigServiceConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace osconfig_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_OSCONFIG_V1_INTERNAL_OS_CONFIG_TRACING_CONNECTION_H
