// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networkservices/v1/network_services.proto

#include "google/cloud/networkservices/v1/network_services_connection.h"
#include "google/cloud/networkservices/v1/internal/network_services_connection_impl.h"
#include "google/cloud/networkservices/v1/internal/network_services_option_defaults.h"
#include "google/cloud/networkservices/v1/internal/network_services_stub_factory.h"
#include "google/cloud/networkservices/v1/internal/network_services_tracing_connection.h"
#include "google/cloud/networkservices/v1/network_services_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace networkservices_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

NetworkServicesConnection::~NetworkServicesConnection() = default;

StreamRange<google::cloud::networkservices::v1::EndpointPolicy>
NetworkServicesConnection::ListEndpointPolicies(
    google::cloud::networkservices::v1::
        ListEndpointPoliciesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::networkservices::v1::EndpointPolicy>>();
}

StatusOr<google::cloud::networkservices::v1::EndpointPolicy>
NetworkServicesConnection::GetEndpointPolicy(
    google::cloud::networkservices::v1::GetEndpointPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::networkservices::v1::EndpointPolicy>>
NetworkServicesConnection::CreateEndpointPolicy(
    google::cloud::networkservices::v1::CreateEndpointPolicyRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::EndpointPolicy>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
NetworkServicesConnection::CreateEndpointPolicy(
    NoAwaitTag,
    google::cloud::networkservices::v1::CreateEndpointPolicyRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::EndpointPolicy>>
NetworkServicesConnection::CreateEndpointPolicy(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::EndpointPolicy>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::EndpointPolicy>>
NetworkServicesConnection::UpdateEndpointPolicy(
    google::cloud::networkservices::v1::UpdateEndpointPolicyRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::EndpointPolicy>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
NetworkServicesConnection::UpdateEndpointPolicy(
    NoAwaitTag,
    google::cloud::networkservices::v1::UpdateEndpointPolicyRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::EndpointPolicy>>
NetworkServicesConnection::UpdateEndpointPolicy(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::EndpointPolicy>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesConnection::DeleteEndpointPolicy(
    google::cloud::networkservices::v1::DeleteEndpointPolicyRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
NetworkServicesConnection::DeleteEndpointPolicy(
    NoAwaitTag,
    google::cloud::networkservices::v1::DeleteEndpointPolicyRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesConnection::DeleteEndpointPolicy(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::networkservices::v1::Gateway>
NetworkServicesConnection::ListGateways(
    google::cloud::networkservices::v1::
        ListGatewaysRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::networkservices::v1::Gateway>>();
}

StatusOr<google::cloud::networkservices::v1::Gateway>
NetworkServicesConnection::GetGateway(
    google::cloud::networkservices::v1::GetGatewayRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::networkservices::v1::Gateway>>
NetworkServicesConnection::CreateGateway(
    google::cloud::networkservices::v1::CreateGatewayRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::Gateway>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
NetworkServicesConnection::CreateGateway(
    NoAwaitTag,
    google::cloud::networkservices::v1::CreateGatewayRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::Gateway>>
NetworkServicesConnection::CreateGateway(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::Gateway>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::Gateway>>
NetworkServicesConnection::UpdateGateway(
    google::cloud::networkservices::v1::UpdateGatewayRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::Gateway>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
NetworkServicesConnection::UpdateGateway(
    NoAwaitTag,
    google::cloud::networkservices::v1::UpdateGatewayRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::Gateway>>
NetworkServicesConnection::UpdateGateway(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::Gateway>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesConnection::DeleteGateway(
    google::cloud::networkservices::v1::DeleteGatewayRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
NetworkServicesConnection::DeleteGateway(
    NoAwaitTag,
    google::cloud::networkservices::v1::DeleteGatewayRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesConnection::DeleteGateway(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::networkservices::v1::GrpcRoute>
NetworkServicesConnection::ListGrpcRoutes(
    google::cloud::networkservices::v1::
        ListGrpcRoutesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::networkservices::v1::GrpcRoute>>();
}

StatusOr<google::cloud::networkservices::v1::GrpcRoute>
NetworkServicesConnection::GetGrpcRoute(
    google::cloud::networkservices::v1::GetGrpcRouteRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::networkservices::v1::GrpcRoute>>
NetworkServicesConnection::CreateGrpcRoute(
    google::cloud::networkservices::v1::CreateGrpcRouteRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::GrpcRoute>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
NetworkServicesConnection::CreateGrpcRoute(
    NoAwaitTag,
    google::cloud::networkservices::v1::CreateGrpcRouteRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::GrpcRoute>>
NetworkServicesConnection::CreateGrpcRoute(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::GrpcRoute>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::GrpcRoute>>
NetworkServicesConnection::UpdateGrpcRoute(
    google::cloud::networkservices::v1::UpdateGrpcRouteRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::GrpcRoute>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
NetworkServicesConnection::UpdateGrpcRoute(
    NoAwaitTag,
    google::cloud::networkservices::v1::UpdateGrpcRouteRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::GrpcRoute>>
NetworkServicesConnection::UpdateGrpcRoute(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::GrpcRoute>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesConnection::DeleteGrpcRoute(
    google::cloud::networkservices::v1::DeleteGrpcRouteRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
NetworkServicesConnection::DeleteGrpcRoute(
    NoAwaitTag,
    google::cloud::networkservices::v1::DeleteGrpcRouteRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesConnection::DeleteGrpcRoute(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::networkservices::v1::HttpRoute>
NetworkServicesConnection::ListHttpRoutes(
    google::cloud::networkservices::v1::
        ListHttpRoutesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::networkservices::v1::HttpRoute>>();
}

StatusOr<google::cloud::networkservices::v1::HttpRoute>
NetworkServicesConnection::GetHttpRoute(
    google::cloud::networkservices::v1::GetHttpRouteRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::networkservices::v1::HttpRoute>>
NetworkServicesConnection::CreateHttpRoute(
    google::cloud::networkservices::v1::CreateHttpRouteRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::HttpRoute>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
NetworkServicesConnection::CreateHttpRoute(
    NoAwaitTag,
    google::cloud::networkservices::v1::CreateHttpRouteRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::HttpRoute>>
NetworkServicesConnection::CreateHttpRoute(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::HttpRoute>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::HttpRoute>>
NetworkServicesConnection::UpdateHttpRoute(
    google::cloud::networkservices::v1::UpdateHttpRouteRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::HttpRoute>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
NetworkServicesConnection::UpdateHttpRoute(
    NoAwaitTag,
    google::cloud::networkservices::v1::UpdateHttpRouteRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::HttpRoute>>
NetworkServicesConnection::UpdateHttpRoute(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::HttpRoute>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesConnection::DeleteHttpRoute(
    google::cloud::networkservices::v1::DeleteHttpRouteRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
NetworkServicesConnection::DeleteHttpRoute(
    NoAwaitTag,
    google::cloud::networkservices::v1::DeleteHttpRouteRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesConnection::DeleteHttpRoute(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::networkservices::v1::TcpRoute>
NetworkServicesConnection::ListTcpRoutes(
    google::cloud::networkservices::v1::
        ListTcpRoutesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::networkservices::v1::TcpRoute>>();
}

StatusOr<google::cloud::networkservices::v1::TcpRoute>
NetworkServicesConnection::GetTcpRoute(
    google::cloud::networkservices::v1::GetTcpRouteRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::networkservices::v1::TcpRoute>>
NetworkServicesConnection::CreateTcpRoute(
    google::cloud::networkservices::v1::CreateTcpRouteRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::TcpRoute>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
NetworkServicesConnection::CreateTcpRoute(
    NoAwaitTag,
    google::cloud::networkservices::v1::CreateTcpRouteRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::TcpRoute>>
NetworkServicesConnection::CreateTcpRoute(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::TcpRoute>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::TcpRoute>>
NetworkServicesConnection::UpdateTcpRoute(
    google::cloud::networkservices::v1::UpdateTcpRouteRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::TcpRoute>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
NetworkServicesConnection::UpdateTcpRoute(
    NoAwaitTag,
    google::cloud::networkservices::v1::UpdateTcpRouteRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::TcpRoute>>
NetworkServicesConnection::UpdateTcpRoute(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::TcpRoute>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesConnection::DeleteTcpRoute(
    google::cloud::networkservices::v1::DeleteTcpRouteRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
NetworkServicesConnection::DeleteTcpRoute(
    NoAwaitTag,
    google::cloud::networkservices::v1::DeleteTcpRouteRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesConnection::DeleteTcpRoute(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::networkservices::v1::TlsRoute>
NetworkServicesConnection::ListTlsRoutes(
    google::cloud::networkservices::v1::
        ListTlsRoutesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::networkservices::v1::TlsRoute>>();
}

StatusOr<google::cloud::networkservices::v1::TlsRoute>
NetworkServicesConnection::GetTlsRoute(
    google::cloud::networkservices::v1::GetTlsRouteRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::networkservices::v1::TlsRoute>>
NetworkServicesConnection::CreateTlsRoute(
    google::cloud::networkservices::v1::CreateTlsRouteRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::TlsRoute>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
NetworkServicesConnection::CreateTlsRoute(
    NoAwaitTag,
    google::cloud::networkservices::v1::CreateTlsRouteRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::TlsRoute>>
NetworkServicesConnection::CreateTlsRoute(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::TlsRoute>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::TlsRoute>>
NetworkServicesConnection::UpdateTlsRoute(
    google::cloud::networkservices::v1::UpdateTlsRouteRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::TlsRoute>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
NetworkServicesConnection::UpdateTlsRoute(
    NoAwaitTag,
    google::cloud::networkservices::v1::UpdateTlsRouteRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::TlsRoute>>
NetworkServicesConnection::UpdateTlsRoute(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::TlsRoute>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesConnection::DeleteTlsRoute(
    google::cloud::networkservices::v1::DeleteTlsRouteRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
NetworkServicesConnection::DeleteTlsRoute(
    NoAwaitTag,
    google::cloud::networkservices::v1::DeleteTlsRouteRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesConnection::DeleteTlsRoute(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::networkservices::v1::ServiceBinding>
NetworkServicesConnection::ListServiceBindings(
    google::cloud::networkservices::v1::
        ListServiceBindingsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::networkservices::v1::ServiceBinding>>();
}

StatusOr<google::cloud::networkservices::v1::ServiceBinding>
NetworkServicesConnection::GetServiceBinding(
    google::cloud::networkservices::v1::GetServiceBindingRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::networkservices::v1::ServiceBinding>>
NetworkServicesConnection::CreateServiceBinding(
    google::cloud::networkservices::v1::CreateServiceBindingRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::ServiceBinding>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
NetworkServicesConnection::CreateServiceBinding(
    NoAwaitTag,
    google::cloud::networkservices::v1::CreateServiceBindingRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::ServiceBinding>>
NetworkServicesConnection::CreateServiceBinding(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::ServiceBinding>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesConnection::DeleteServiceBinding(
    google::cloud::networkservices::v1::DeleteServiceBindingRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
NetworkServicesConnection::DeleteServiceBinding(
    NoAwaitTag,
    google::cloud::networkservices::v1::DeleteServiceBindingRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesConnection::DeleteServiceBinding(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::networkservices::v1::Mesh>
NetworkServicesConnection::ListMeshes(
    google::cloud::networkservices::v1::
        ListMeshesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::networkservices::v1::Mesh>>();
}

StatusOr<google::cloud::networkservices::v1::Mesh>
NetworkServicesConnection::GetMesh(
    google::cloud::networkservices::v1::GetMeshRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::networkservices::v1::Mesh>>
NetworkServicesConnection::CreateMesh(
    google::cloud::networkservices::v1::CreateMeshRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::Mesh>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> NetworkServicesConnection::CreateMesh(
    NoAwaitTag, google::cloud::networkservices::v1::CreateMeshRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::Mesh>>
NetworkServicesConnection::CreateMesh(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::Mesh>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::Mesh>>
NetworkServicesConnection::UpdateMesh(
    google::cloud::networkservices::v1::UpdateMeshRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::Mesh>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> NetworkServicesConnection::UpdateMesh(
    NoAwaitTag, google::cloud::networkservices::v1::UpdateMeshRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::Mesh>>
NetworkServicesConnection::UpdateMesh(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::Mesh>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesConnection::DeleteMesh(
    google::cloud::networkservices::v1::DeleteMeshRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> NetworkServicesConnection::DeleteMesh(
    NoAwaitTag, google::cloud::networkservices::v1::DeleteMeshRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesConnection::DeleteMesh(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

std::shared_ptr<NetworkServicesConnection> MakeNetworkServicesConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 NetworkServicesPolicyOptionList>(options,
                                                                  __func__);
  options = networkservices_v1_internal::NetworkServicesDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = networkservices_v1_internal::CreateDefaultNetworkServicesStub(
      std::move(auth), options);
  return networkservices_v1_internal::MakeNetworkServicesTracingConnection(
      std::make_shared<
          networkservices_v1_internal::NetworkServicesConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networkservices_v1
}  // namespace cloud
}  // namespace google
