// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/snooze_service.proto

#include "google/cloud/monitoring/v3/internal/snooze_connection_impl.h"
#include "google/cloud/monitoring/v3/internal/snooze_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace monitoring_v3_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<monitoring_v3::SnoozeServiceRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<monitoring_v3::SnoozeServiceRetryPolicyOption>()->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<monitoring_v3::SnoozeServiceBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<monitoring_v3::SnoozeServiceConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<monitoring_v3::SnoozeServiceConnectionIdempotencyPolicyOption>()
      ->clone();
}

}  // namespace

SnoozeServiceConnectionImpl::SnoozeServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<monitoring_v3_internal::SnoozeServiceStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      SnoozeServiceConnection::options())) {}

StatusOr<google::monitoring::v3::Snooze>
SnoozeServiceConnectionImpl::CreateSnooze(
    google::monitoring::v3::CreateSnoozeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateSnooze(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::monitoring::v3::CreateSnoozeRequest const& request) {
        return stub_->CreateSnooze(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::monitoring::v3::Snooze>
SnoozeServiceConnectionImpl::ListSnoozes(
    google::monitoring::v3::ListSnoozesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListSnoozes(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::monitoring::v3::Snooze>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<monitoring_v3::SnoozeServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::monitoring::v3::ListSnoozesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::monitoring::v3::ListSnoozesRequest const& request) {
              return stub->ListSnoozes(context, options, request);
            },
            options, r, function_name);
      },
      [](google::monitoring::v3::ListSnoozesResponse r) {
        std::vector<google::monitoring::v3::Snooze> result(r.snoozes().size());
        auto& messages = *r.mutable_snoozes();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::monitoring::v3::Snooze> SnoozeServiceConnectionImpl::GetSnooze(
    google::monitoring::v3::GetSnoozeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetSnooze(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::monitoring::v3::GetSnoozeRequest const& request) {
        return stub_->GetSnooze(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::monitoring::v3::Snooze>
SnoozeServiceConnectionImpl::UpdateSnooze(
    google::monitoring::v3::UpdateSnoozeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateSnooze(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::monitoring::v3::UpdateSnoozeRequest const& request) {
        return stub_->UpdateSnooze(context, options, request);
      },
      *current, request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_v3_internal
}  // namespace cloud
}  // namespace google
