// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/ids/v1/ids.proto

#include "google/cloud/ids/v1/ids_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace ids_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

IDSConnectionIdempotencyPolicy::~IDSConnectionIdempotencyPolicy() = default;

std::unique_ptr<IDSConnectionIdempotencyPolicy>
IDSConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<IDSConnectionIdempotencyPolicy>(*this);
}

Idempotency IDSConnectionIdempotencyPolicy::ListEndpoints(
    google::cloud::ids::v1::ListEndpointsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency IDSConnectionIdempotencyPolicy::GetEndpoint(
    google::cloud::ids::v1::GetEndpointRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency IDSConnectionIdempotencyPolicy::CreateEndpoint(
    google::cloud::ids::v1::CreateEndpointRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency IDSConnectionIdempotencyPolicy::DeleteEndpoint(
    google::cloud::ids::v1::DeleteEndpointRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<IDSConnectionIdempotencyPolicy>
MakeDefaultIDSConnectionIdempotencyPolicy() {
  return std::make_unique<IDSConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace ids_v1
}  // namespace cloud
}  // namespace google
