// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/privacy/dlp/v2/dlp.proto

#include "google/cloud/dlp/v2/internal/dlp_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <google/privacy/dlp/v2/dlp.grpc.pb.h>
#include <memory>
#include <set>
#include <string>
#include <utility>

namespace google {
namespace cloud {
namespace dlp_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DlpServiceLogging::DlpServiceLogging(std::shared_ptr<DlpServiceStub> child,
                                     TracingOptions tracing_options,
                                     std::set<std::string> const&)
    : child_(std::move(child)), tracing_options_(std::move(tracing_options)) {}

StatusOr<google::privacy::dlp::v2::InspectContentResponse>
DlpServiceLogging::InspectContent(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::InspectContentRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::privacy::dlp::v2::InspectContentRequest const& request) {
        return child_->InspectContent(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::RedactImageResponse>
DlpServiceLogging::RedactImage(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::RedactImageRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::privacy::dlp::v2::RedactImageRequest const& request) {
        return child_->RedactImage(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::DeidentifyContentResponse>
DlpServiceLogging::DeidentifyContent(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::DeidentifyContentRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::privacy::dlp::v2::DeidentifyContentRequest const& request) {
        return child_->DeidentifyContent(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::ReidentifyContentResponse>
DlpServiceLogging::ReidentifyContent(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::ReidentifyContentRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::privacy::dlp::v2::ReidentifyContentRequest const& request) {
        return child_->ReidentifyContent(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::ListInfoTypesResponse>
DlpServiceLogging::ListInfoTypes(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::ListInfoTypesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::privacy::dlp::v2::ListInfoTypesRequest const& request) {
        return child_->ListInfoTypes(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::InspectTemplate>
DlpServiceLogging::CreateInspectTemplate(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::CreateInspectTemplateRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::privacy::dlp::v2::CreateInspectTemplateRequest const&
                 request) {
        return child_->CreateInspectTemplate(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::InspectTemplate>
DlpServiceLogging::UpdateInspectTemplate(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::UpdateInspectTemplateRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::privacy::dlp::v2::UpdateInspectTemplateRequest const&
                 request) {
        return child_->UpdateInspectTemplate(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::InspectTemplate>
DlpServiceLogging::GetInspectTemplate(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::GetInspectTemplateRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::privacy::dlp::v2::GetInspectTemplateRequest const& request) {
        return child_->GetInspectTemplate(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::ListInspectTemplatesResponse>
DlpServiceLogging::ListInspectTemplates(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::ListInspectTemplatesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::privacy::dlp::v2::ListInspectTemplatesRequest const&
                 request) {
        return child_->ListInspectTemplates(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

Status DlpServiceLogging::DeleteInspectTemplate(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::DeleteInspectTemplateRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::privacy::dlp::v2::DeleteInspectTemplateRequest const&
                 request) {
        return child_->DeleteInspectTemplate(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::DeidentifyTemplate>
DlpServiceLogging::CreateDeidentifyTemplate(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::CreateDeidentifyTemplateRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::privacy::dlp::v2::CreateDeidentifyTemplateRequest const&
                 request) {
        return child_->CreateDeidentifyTemplate(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::DeidentifyTemplate>
DlpServiceLogging::UpdateDeidentifyTemplate(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::UpdateDeidentifyTemplateRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::privacy::dlp::v2::UpdateDeidentifyTemplateRequest const&
                 request) {
        return child_->UpdateDeidentifyTemplate(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::DeidentifyTemplate>
DlpServiceLogging::GetDeidentifyTemplate(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::GetDeidentifyTemplateRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::privacy::dlp::v2::GetDeidentifyTemplateRequest const&
                 request) {
        return child_->GetDeidentifyTemplate(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::ListDeidentifyTemplatesResponse>
DlpServiceLogging::ListDeidentifyTemplates(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::ListDeidentifyTemplatesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::privacy::dlp::v2::ListDeidentifyTemplatesRequest const&
                 request) {
        return child_->ListDeidentifyTemplates(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

Status DlpServiceLogging::DeleteDeidentifyTemplate(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::DeleteDeidentifyTemplateRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::privacy::dlp::v2::DeleteDeidentifyTemplateRequest const&
                 request) {
        return child_->DeleteDeidentifyTemplate(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::JobTrigger>
DlpServiceLogging::CreateJobTrigger(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::CreateJobTriggerRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::privacy::dlp::v2::CreateJobTriggerRequest const& request) {
        return child_->CreateJobTrigger(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::JobTrigger>
DlpServiceLogging::UpdateJobTrigger(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::UpdateJobTriggerRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::privacy::dlp::v2::UpdateJobTriggerRequest const& request) {
        return child_->UpdateJobTrigger(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::HybridInspectResponse>
DlpServiceLogging::HybridInspectJobTrigger(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::HybridInspectJobTriggerRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::privacy::dlp::v2::HybridInspectJobTriggerRequest const&
                 request) {
        return child_->HybridInspectJobTrigger(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::JobTrigger> DlpServiceLogging::GetJobTrigger(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::GetJobTriggerRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::privacy::dlp::v2::GetJobTriggerRequest const& request) {
        return child_->GetJobTrigger(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::ListJobTriggersResponse>
DlpServiceLogging::ListJobTriggers(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::ListJobTriggersRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::privacy::dlp::v2::ListJobTriggersRequest const& request) {
        return child_->ListJobTriggers(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

Status DlpServiceLogging::DeleteJobTrigger(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::DeleteJobTriggerRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::privacy::dlp::v2::DeleteJobTriggerRequest const& request) {
        return child_->DeleteJobTrigger(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::DlpJob>
DlpServiceLogging::ActivateJobTrigger(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::ActivateJobTriggerRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::privacy::dlp::v2::ActivateJobTriggerRequest const& request) {
        return child_->ActivateJobTrigger(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::DiscoveryConfig>
DlpServiceLogging::CreateDiscoveryConfig(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::CreateDiscoveryConfigRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::privacy::dlp::v2::CreateDiscoveryConfigRequest const&
                 request) {
        return child_->CreateDiscoveryConfig(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::DiscoveryConfig>
DlpServiceLogging::UpdateDiscoveryConfig(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::UpdateDiscoveryConfigRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::privacy::dlp::v2::UpdateDiscoveryConfigRequest const&
                 request) {
        return child_->UpdateDiscoveryConfig(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::DiscoveryConfig>
DlpServiceLogging::GetDiscoveryConfig(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::GetDiscoveryConfigRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::privacy::dlp::v2::GetDiscoveryConfigRequest const& request) {
        return child_->GetDiscoveryConfig(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::ListDiscoveryConfigsResponse>
DlpServiceLogging::ListDiscoveryConfigs(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::ListDiscoveryConfigsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::privacy::dlp::v2::ListDiscoveryConfigsRequest const&
                 request) {
        return child_->ListDiscoveryConfigs(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

Status DlpServiceLogging::DeleteDiscoveryConfig(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::DeleteDiscoveryConfigRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::privacy::dlp::v2::DeleteDiscoveryConfigRequest const&
                 request) {
        return child_->DeleteDiscoveryConfig(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::DlpJob> DlpServiceLogging::CreateDlpJob(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::CreateDlpJobRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::privacy::dlp::v2::CreateDlpJobRequest const& request) {
        return child_->CreateDlpJob(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::ListDlpJobsResponse>
DlpServiceLogging::ListDlpJobs(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::ListDlpJobsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::privacy::dlp::v2::ListDlpJobsRequest const& request) {
        return child_->ListDlpJobs(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::DlpJob> DlpServiceLogging::GetDlpJob(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::GetDlpJobRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::privacy::dlp::v2::GetDlpJobRequest const& request) {
        return child_->GetDlpJob(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

Status DlpServiceLogging::DeleteDlpJob(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::DeleteDlpJobRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::privacy::dlp::v2::DeleteDlpJobRequest const& request) {
        return child_->DeleteDlpJob(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

Status DlpServiceLogging::CancelDlpJob(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::CancelDlpJobRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::privacy::dlp::v2::CancelDlpJobRequest const& request) {
        return child_->CancelDlpJob(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::StoredInfoType>
DlpServiceLogging::CreateStoredInfoType(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::CreateStoredInfoTypeRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::privacy::dlp::v2::CreateStoredInfoTypeRequest const&
                 request) {
        return child_->CreateStoredInfoType(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::StoredInfoType>
DlpServiceLogging::UpdateStoredInfoType(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::UpdateStoredInfoTypeRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::privacy::dlp::v2::UpdateStoredInfoTypeRequest const&
                 request) {
        return child_->UpdateStoredInfoType(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::StoredInfoType>
DlpServiceLogging::GetStoredInfoType(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::GetStoredInfoTypeRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::privacy::dlp::v2::GetStoredInfoTypeRequest const& request) {
        return child_->GetStoredInfoType(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::ListStoredInfoTypesResponse>
DlpServiceLogging::ListStoredInfoTypes(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::ListStoredInfoTypesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::privacy::dlp::v2::ListStoredInfoTypesRequest const& request) {
        return child_->ListStoredInfoTypes(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

Status DlpServiceLogging::DeleteStoredInfoType(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::DeleteStoredInfoTypeRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::privacy::dlp::v2::DeleteStoredInfoTypeRequest const&
                 request) {
        return child_->DeleteStoredInfoType(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::ListProjectDataProfilesResponse>
DlpServiceLogging::ListProjectDataProfiles(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::ListProjectDataProfilesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::privacy::dlp::v2::ListProjectDataProfilesRequest const&
                 request) {
        return child_->ListProjectDataProfiles(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::ListTableDataProfilesResponse>
DlpServiceLogging::ListTableDataProfiles(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::ListTableDataProfilesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::privacy::dlp::v2::ListTableDataProfilesRequest const&
                 request) {
        return child_->ListTableDataProfiles(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::ListColumnDataProfilesResponse>
DlpServiceLogging::ListColumnDataProfiles(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::ListColumnDataProfilesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::privacy::dlp::v2::ListColumnDataProfilesRequest const&
                 request) {
        return child_->ListColumnDataProfiles(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::ProjectDataProfile>
DlpServiceLogging::GetProjectDataProfile(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::GetProjectDataProfileRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::privacy::dlp::v2::GetProjectDataProfileRequest const&
                 request) {
        return child_->GetProjectDataProfile(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::ListFileStoreDataProfilesResponse>
DlpServiceLogging::ListFileStoreDataProfiles(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::ListFileStoreDataProfilesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::privacy::dlp::v2::ListFileStoreDataProfilesRequest const&
                 request) {
        return child_->ListFileStoreDataProfiles(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::FileStoreDataProfile>
DlpServiceLogging::GetFileStoreDataProfile(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::GetFileStoreDataProfileRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::privacy::dlp::v2::GetFileStoreDataProfileRequest const&
                 request) {
        return child_->GetFileStoreDataProfile(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

Status DlpServiceLogging::DeleteFileStoreDataProfile(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::DeleteFileStoreDataProfileRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::privacy::dlp::v2::DeleteFileStoreDataProfileRequest const&
                 request) {
        return child_->DeleteFileStoreDataProfile(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::TableDataProfile>
DlpServiceLogging::GetTableDataProfile(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::GetTableDataProfileRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::privacy::dlp::v2::GetTableDataProfileRequest const& request) {
        return child_->GetTableDataProfile(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::ColumnDataProfile>
DlpServiceLogging::GetColumnDataProfile(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::GetColumnDataProfileRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::privacy::dlp::v2::GetColumnDataProfileRequest const&
                 request) {
        return child_->GetColumnDataProfile(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

Status DlpServiceLogging::DeleteTableDataProfile(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::DeleteTableDataProfileRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::privacy::dlp::v2::DeleteTableDataProfileRequest const&
                 request) {
        return child_->DeleteTableDataProfile(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::HybridInspectResponse>
DlpServiceLogging::HybridInspectDlpJob(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::HybridInspectDlpJobRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::privacy::dlp::v2::HybridInspectDlpJobRequest const& request) {
        return child_->HybridInspectDlpJob(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

Status DlpServiceLogging::FinishDlpJob(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::FinishDlpJobRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::privacy::dlp::v2::FinishDlpJobRequest const& request) {
        return child_->FinishDlpJob(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::Connection>
DlpServiceLogging::CreateConnection(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::CreateConnectionRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::privacy::dlp::v2::CreateConnectionRequest const& request) {
        return child_->CreateConnection(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::Connection> DlpServiceLogging::GetConnection(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::GetConnectionRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::privacy::dlp::v2::GetConnectionRequest const& request) {
        return child_->GetConnection(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::ListConnectionsResponse>
DlpServiceLogging::ListConnections(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::ListConnectionsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::privacy::dlp::v2::ListConnectionsRequest const& request) {
        return child_->ListConnections(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::SearchConnectionsResponse>
DlpServiceLogging::SearchConnections(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::SearchConnectionsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::privacy::dlp::v2::SearchConnectionsRequest const& request) {
        return child_->SearchConnections(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

Status DlpServiceLogging::DeleteConnection(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::DeleteConnectionRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::privacy::dlp::v2::DeleteConnectionRequest const& request) {
        return child_->DeleteConnection(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::privacy::dlp::v2::Connection>
DlpServiceLogging::UpdateConnection(
    grpc::ClientContext& context, Options const& options,
    google::privacy::dlp::v2::UpdateConnectionRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::privacy::dlp::v2::UpdateConnectionRequest const& request) {
        return child_->UpdateConnection(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dlp_v2_internal
}  // namespace cloud
}  // namespace google
