// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/datastore/admin/v1/datastore_admin.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATASTORE_ADMIN_V1_DATASTORE_ADMIN_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATASTORE_ADMIN_V1_DATASTORE_ADMIN_CLIENT_H

#include "google/cloud/datastore/admin/v1/datastore_admin_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace datastore_admin_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Google Cloud Datastore Admin API
///
/// The Datastore Admin API provides several admin services for Cloud Datastore.
///
/// Concepts: Project, namespace, kind, and entity as defined in the Google
/// Cloud Datastore API.
///
/// Operation: An Operation represents work being performed in the background.
///
/// EntityFilter: Allows specifying a subset of entities in a project. This is
/// specified as a combination of kinds and namespaces (either or both of which
/// may be all).
///
/// Export/Import Service:
///
/// - The Export/Import service provides the ability to copy all or a subset of
/// entities to/from Google Cloud Storage.
/// - Exported data may be imported into Cloud Datastore for any Google Cloud
/// Platform project. It is not restricted to the export source project. It is
/// possible to export from one project and then import into another.
/// - Exported data can also be loaded into Google BigQuery for analysis.
/// - Exports and imports are performed asynchronously. An Operation resource is
/// created for each export/import. The state (including any errors encountered)
/// of the export/import may be queried via the Operation resource.
///
/// Index Service:
///
/// - The index service manages Cloud Datastore composite indexes.
/// - Index creation and deletion are performed asynchronously.
/// An Operation resource is created for each such asynchronous operation.
/// The state of the operation (including any errors encountered)
/// may be queried via the Operation resource.
///
/// Operation Service:
///
/// - The Operations collection provides a record of actions performed for the
/// specified project (including any operations in progress). Operations are not
/// created directly but through calls on other collections or resources.
/// - An operation that is not yet done may be cancelled. The request to cancel
/// is asynchronous and the operation may continue to run for some time after
/// the request to cancel is made.
/// - An operation that is done may be deleted so that it is no longer listed as
/// part of the Operation collection.
/// - ListOperations returns all pending operations, but not completed
/// operations.
/// - Operations are created by service DatastoreAdmin, but are accessed via
/// service google.longrunning.Operations.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class DatastoreAdminClient {
 public:
  explicit DatastoreAdminClient(
      std::shared_ptr<DatastoreAdminConnection> connection, Options opts = {});
  ~DatastoreAdminClient();

  ///@{
  /// @name Copy and move support
  DatastoreAdminClient(DatastoreAdminClient const&) = default;
  DatastoreAdminClient& operator=(DatastoreAdminClient const&) = default;
  DatastoreAdminClient(DatastoreAdminClient&&) = default;
  DatastoreAdminClient& operator=(DatastoreAdminClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(DatastoreAdminClient const& a,
                         DatastoreAdminClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(DatastoreAdminClient const& a,
                         DatastoreAdminClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Exports a copy of all or a subset of entities from Google Cloud Datastore
  /// to another storage system, such as Google Cloud Storage. Recent updates to
  /// entities may not be reflected in the export. The export occurs in the
  /// background and its progress can be monitored and managed via the
  /// Operation resource that is created. The output of an export may only be
  /// used once the associated operation is done. If an export operation is
  /// cancelled before completion it may leave partial data behind in Google
  /// Cloud Storage.
  ///
  /// @param project_id  Required. Project ID against which to make the request.
  /// @param labels  Client-assigned labels.
  /// @param entity_filter  Description of what data from the project is included in the export.
  /// @param output_url_prefix  Required. Location for the export metadata and data files.
  ///  @n
  ///  The full resource URL of the external storage location. Currently, only
  ///  Google Cloud Storage is supported. So output_url_prefix should be of the
  ///  form: `gs://BUCKET_NAME[/NAMESPACE_PATH]`, where `BUCKET_NAME` is the
  ///  name of the Cloud Storage bucket and `NAMESPACE_PATH` is an optional Cloud
  ///  Storage namespace path (this is not a Cloud Datastore namespace). For more
  ///  information about Cloud Storage namespace paths, see
  ///  [Object name
  ///  considerations](https://cloud.google.com/storage/docs/naming#object-considerations).
  ///  @n
  ///  The resulting files will be nested deeper than the specified URL prefix.
  ///  The final output URL will be provided in the
  ///  [google.datastore.admin.v1.ExportEntitiesResponse.output_url][google.datastore.admin.v1.ExportEntitiesResponse.output_url]
  ///  field. That value should be used for subsequent ImportEntities operations.
  ///  @n
  ///  By nesting the data files deeper, the same Cloud Storage bucket can be used
  ///  in multiple ExportEntities operations without conflict.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.datastore.admin.v1.ExportEntitiesResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.datastore.admin.v1.ExportEntitiesRequest]: @googleapis_reference_link{google/datastore/admin/v1/datastore_admin.proto#L254}
  /// [google.datastore.admin.v1.ExportEntitiesResponse]: @googleapis_reference_link{google/datastore/admin/v1/datastore_admin.proto#L319}
  /// [google.datastore.admin.v1.ExportEntitiesResponse.output_url]: @googleapis_reference_link{google/datastore/admin/v1/datastore_admin.proto#L324}
  ///
  // clang-format on
  future<StatusOr<google::datastore::admin::v1::ExportEntitiesResponse>>
  ExportEntities(
      std::string const& project_id,
      std::map<std::string, std::string> const& labels,
      google::datastore::admin::v1::EntityFilter const& entity_filter,
      std::string const& output_url_prefix, Options opts = {});

  // clang-format off
  ///
  /// @copybrief ExportEntities
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ExportEntities(
      NoAwaitTag, std::string const& project_id,
      std::map<std::string, std::string> const& labels,
      google::datastore::admin::v1::EntityFilter const& entity_filter,
      std::string const& output_url_prefix, Options opts = {});

  // clang-format off
  ///
  /// Exports a copy of all or a subset of entities from Google Cloud Datastore
  /// to another storage system, such as Google Cloud Storage. Recent updates to
  /// entities may not be reflected in the export. The export occurs in the
  /// background and its progress can be monitored and managed via the
  /// Operation resource that is created. The output of an export may only be
  /// used once the associated operation is done. If an export operation is
  /// cancelled before completion it may leave partial data behind in Google
  /// Cloud Storage.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.datastore.admin.v1.ExportEntitiesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.datastore.admin.v1.ExportEntitiesResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.datastore.admin.v1.ExportEntitiesRequest]: @googleapis_reference_link{google/datastore/admin/v1/datastore_admin.proto#L254}
  /// [google.datastore.admin.v1.ExportEntitiesResponse]: @googleapis_reference_link{google/datastore/admin/v1/datastore_admin.proto#L319}
  ///
  // clang-format on
  future<StatusOr<google::datastore::admin::v1::ExportEntitiesResponse>>
  ExportEntities(
      google::datastore::admin::v1::ExportEntitiesRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ExportEntities
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ExportEntities(
      NoAwaitTag,
      google::datastore::admin::v1::ExportEntitiesRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ExportEntities
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::datastore::admin::v1::ExportEntitiesResponse>>
  ExportEntities(google::longrunning::Operation const& operation,
                 Options opts = {});

  // clang-format off
  ///
  /// Imports entities into Google Cloud Datastore. Existing entities with the
  /// same key are overwritten. The import occurs in the background and its
  /// progress can be monitored and managed via the Operation resource that is
  /// created. If an ImportEntities operation is cancelled, it is possible
  /// that a subset of the data has already been imported to Cloud Datastore.
  ///
  /// @param project_id  Required. Project ID against which to make the request.
  /// @param labels  Client-assigned labels.
  /// @param input_url  Required. The full resource URL of the external storage location.
  ///  Currently, only Google Cloud Storage is supported. So input_url should be
  ///  of the form:
  ///  `gs://BUCKET_NAME[/NAMESPACE_PATH]/OVERALL_EXPORT_METADATA_FILE`, where
  ///  `BUCKET_NAME` is the name of the Cloud Storage bucket, `NAMESPACE_PATH` is
  ///  an optional Cloud Storage namespace path (this is not a Cloud Datastore
  ///  namespace), and `OVERALL_EXPORT_METADATA_FILE` is the metadata file written
  ///  by the ExportEntities operation. For more information about Cloud Storage
  ///  namespace paths, see
  ///  [Object name
  ///  considerations](https://cloud.google.com/storage/docs/naming#object-considerations).
  ///  @n
  ///  For more information, see
  ///  [google.datastore.admin.v1.ExportEntitiesResponse.output_url][google.datastore.admin.v1.ExportEntitiesResponse.output_url].
  /// @param entity_filter  Optionally specify which kinds/namespaces are to be imported. If provided,
  ///  the list must be a subset of the EntityFilter used in creating the export,
  ///  otherwise a FAILED_PRECONDITION error will be returned. If no filter is
  ///  specified then all entities from the export are imported.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.datastore.admin.v1.ImportEntitiesMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.datastore.admin.v1.ExportEntitiesResponse.output_url]: @googleapis_reference_link{google/datastore/admin/v1/datastore_admin.proto#L324}
  /// [google.datastore.admin.v1.ImportEntitiesMetadata]: @googleapis_reference_link{google/datastore/admin/v1/datastore_admin.proto#L350}
  /// [google.datastore.admin.v1.ImportEntitiesRequest]: @googleapis_reference_link{google/datastore/admin/v1/datastore_admin.proto#L287}
  ///
  // clang-format on
  future<StatusOr<google::datastore::admin::v1::ImportEntitiesMetadata>>
  ImportEntities(
      std::string const& project_id,
      std::map<std::string, std::string> const& labels,
      std::string const& input_url,
      google::datastore::admin::v1::EntityFilter const& entity_filter,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ImportEntities
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ImportEntities(
      NoAwaitTag, std::string const& project_id,
      std::map<std::string, std::string> const& labels,
      std::string const& input_url,
      google::datastore::admin::v1::EntityFilter const& entity_filter,
      Options opts = {});

  // clang-format off
  ///
  /// Imports entities into Google Cloud Datastore. Existing entities with the
  /// same key are overwritten. The import occurs in the background and its
  /// progress can be monitored and managed via the Operation resource that is
  /// created. If an ImportEntities operation is cancelled, it is possible
  /// that a subset of the data has already been imported to Cloud Datastore.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.datastore.admin.v1.ImportEntitiesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.datastore.admin.v1.ImportEntitiesMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.datastore.admin.v1.ImportEntitiesMetadata]: @googleapis_reference_link{google/datastore/admin/v1/datastore_admin.proto#L350}
  /// [google.datastore.admin.v1.ImportEntitiesRequest]: @googleapis_reference_link{google/datastore/admin/v1/datastore_admin.proto#L287}
  ///
  // clang-format on
  future<StatusOr<google::datastore::admin::v1::ImportEntitiesMetadata>>
  ImportEntities(
      google::datastore::admin::v1::ImportEntitiesRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ImportEntities
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ImportEntities(
      NoAwaitTag,
      google::datastore::admin::v1::ImportEntitiesRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ImportEntities
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::datastore::admin::v1::ImportEntitiesMetadata>>
  ImportEntities(google::longrunning::Operation const& operation,
                 Options opts = {});

  // clang-format off
  ///
  /// Creates the specified index.
  /// A newly created index's initial state is `CREATING`. On completion of the
  /// returned [google.longrunning.Operation][google.longrunning.Operation], the
  /// state will be `READY`. If the index already exists, the call will return an
  /// `ALREADY_EXISTS` status.
  ///
  /// During index creation, the process could result in an error, in which
  /// case the index will move to the `ERROR` state. The process can be recovered
  /// by fixing the data that caused the error, removing the index with
  /// [delete][google.datastore.admin.v1.DatastoreAdmin.DeleteIndex], then
  /// re-creating the index with [create]
  /// [google.datastore.admin.v1.DatastoreAdmin.CreateIndex].
  ///
  /// Indexes with a single property cannot be created.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.datastore.admin.v1.CreateIndexRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.datastore.admin.v1.Index] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.datastore.admin.v1.CreateIndexRequest]: @googleapis_reference_link{google/datastore/admin/v1/datastore_admin.proto#L405}
  /// [google.datastore.admin.v1.DatastoreAdmin.DeleteIndex]: @googleapis_reference_link{google/datastore/admin/v1/datastore_admin.proto#L165}
  /// [google.datastore.admin.v1.Index]: @googleapis_reference_link{google/datastore/admin/v1/index.proto#L30}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  future<StatusOr<google::datastore::admin::v1::Index>> CreateIndex(
      google::datastore::admin::v1::CreateIndexRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateIndex
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateIndex(
      NoAwaitTag,
      google::datastore::admin::v1::CreateIndexRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateIndex
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::datastore::admin::v1::Index>> CreateIndex(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Deletes an existing index.
  /// An index can only be deleted if it is in a `READY` or `ERROR` state. On
  /// successful execution of the request, the index will be in a `DELETING`
  /// [state][google.datastore.admin.v1.Index.State]. And on completion of the
  /// returned [google.longrunning.Operation][google.longrunning.Operation], the
  /// index will be removed.
  ///
  /// During index deletion, the process could result in an error, in which
  /// case the index will move to the `ERROR` state. The process can be recovered
  /// by fixing the data that caused the error, followed by calling
  /// [delete][google.datastore.admin.v1.DatastoreAdmin.DeleteIndex] again.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.datastore.admin.v1.DeleteIndexRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.datastore.admin.v1.Index] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.datastore.admin.v1.DatastoreAdmin.DeleteIndex]: @googleapis_reference_link{google/datastore/admin/v1/datastore_admin.proto#L165}
  /// [google.datastore.admin.v1.DeleteIndexRequest]: @googleapis_reference_link{google/datastore/admin/v1/datastore_admin.proto#L416}
  /// [google.datastore.admin.v1.Index]: @googleapis_reference_link{google/datastore/admin/v1/index.proto#L30}
  /// [google.datastore.admin.v1.Index.State]: @googleapis_reference_link{google/datastore/admin/v1/index.proto#L69}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  future<StatusOr<google::datastore::admin::v1::Index>> DeleteIndex(
      google::datastore::admin::v1::DeleteIndexRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteIndex
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteIndex(
      NoAwaitTag,
      google::datastore::admin::v1::DeleteIndexRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteIndex
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::datastore::admin::v1::Index>> DeleteIndex(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Gets an index.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.datastore.admin.v1.GetIndexRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.datastore.admin.v1.Index])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.datastore.admin.v1.GetIndexRequest]: @googleapis_reference_link{google/datastore/admin/v1/datastore_admin.proto#L426}
  /// [google.datastore.admin.v1.Index]: @googleapis_reference_link{google/datastore/admin/v1/index.proto#L30}
  ///
  // clang-format on
  StatusOr<google::datastore::admin::v1::Index> GetIndex(
      google::datastore::admin::v1::GetIndexRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists the indexes that match the specified filters.  Datastore uses an
  /// eventually consistent query to fetch the list of indexes and may
  /// occasionally return stale results.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.datastore.admin.v1.ListIndexesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.datastore.admin.v1.Index], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.datastore.admin.v1.Index]: @googleapis_reference_link{google/datastore/admin/v1/index.proto#L30}
  /// [google.datastore.admin.v1.ListIndexesRequest]: @googleapis_reference_link{google/datastore/admin/v1/datastore_admin.proto#L436}
  ///
  // clang-format on
  StreamRange<google::datastore::admin::v1::Index> ListIndexes(
      google::datastore::admin::v1::ListIndexesRequest request,
      Options opts = {});

 private:
  std::shared_ptr<DatastoreAdminConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace datastore_admin_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATASTORE_ADMIN_V1_DATASTORE_ADMIN_CLIENT_H
