// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/datafusion/v1/datafusion.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAFUSION_V1_DATA_FUSION_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAFUSION_V1_DATA_FUSION_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/datafusion/v1/datafusion.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace datafusion_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class DataFusionConnectionIdempotencyPolicy {
 public:
  virtual ~DataFusionConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<DataFusionConnectionIdempotencyPolicy> clone() const;

  virtual google::cloud::Idempotency ListAvailableVersions(
      google::cloud::datafusion::v1::ListAvailableVersionsRequest request);

  virtual google::cloud::Idempotency ListInstances(
      google::cloud::datafusion::v1::ListInstancesRequest request);

  virtual google::cloud::Idempotency GetInstance(
      google::cloud::datafusion::v1::GetInstanceRequest const& request);

  virtual google::cloud::Idempotency CreateInstance(
      google::cloud::datafusion::v1::CreateInstanceRequest const& request);

  virtual google::cloud::Idempotency DeleteInstance(
      google::cloud::datafusion::v1::DeleteInstanceRequest const& request);

  virtual google::cloud::Idempotency UpdateInstance(
      google::cloud::datafusion::v1::UpdateInstanceRequest const& request);

  virtual google::cloud::Idempotency RestartInstance(
      google::cloud::datafusion::v1::RestartInstanceRequest const& request);
};

std::unique_ptr<DataFusionConnectionIdempotencyPolicy>
MakeDefaultDataFusionConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace datafusion_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAFUSION_V1_DATA_FUSION_CONNECTION_IDEMPOTENCY_POLICY_H
