// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/contentwarehouse/v1/document_schema_service.proto

#include "google/cloud/contentwarehouse/v1/document_schema_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace contentwarehouse_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

DocumentSchemaServiceConnectionIdempotencyPolicy::
    ~DocumentSchemaServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<DocumentSchemaServiceConnectionIdempotencyPolicy>
DocumentSchemaServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<DocumentSchemaServiceConnectionIdempotencyPolicy>(
      *this);
}

Idempotency
DocumentSchemaServiceConnectionIdempotencyPolicy::CreateDocumentSchema(
    google::cloud::contentwarehouse::v1::CreateDocumentSchemaRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
DocumentSchemaServiceConnectionIdempotencyPolicy::UpdateDocumentSchema(
    google::cloud::contentwarehouse::v1::UpdateDocumentSchemaRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DocumentSchemaServiceConnectionIdempotencyPolicy::GetDocumentSchema(
    google::cloud::contentwarehouse::v1::GetDocumentSchemaRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
DocumentSchemaServiceConnectionIdempotencyPolicy::DeleteDocumentSchema(
    google::cloud::contentwarehouse::v1::DeleteDocumentSchemaRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
DocumentSchemaServiceConnectionIdempotencyPolicy::ListDocumentSchemas(
    google::cloud::contentwarehouse::v1::
        ListDocumentSchemasRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

std::unique_ptr<DocumentSchemaServiceConnectionIdempotencyPolicy>
MakeDefaultDocumentSchemaServiceConnectionIdempotencyPolicy() {
  return std::make_unique<DocumentSchemaServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace contentwarehouse_v1
}  // namespace cloud
}  // namespace google
