// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/storage_pools/v1/storage_pools.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_STORAGE_POOLS_V1_STORAGE_POOLS_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_STORAGE_POOLS_V1_STORAGE_POOLS_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/compute/storage_pools/v1/storage_pools.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace compute_storage_pools_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class StoragePoolsConnectionIdempotencyPolicy {
 public:
  virtual ~StoragePoolsConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<StoragePoolsConnectionIdempotencyPolicy> clone()
      const;

  virtual google::cloud::Idempotency AggregatedListStoragePools(
      google::cloud::cpp::compute::storage_pools::v1::
          AggregatedListStoragePoolsRequest request);

  virtual google::cloud::Idempotency DeleteStoragePool(
      google::cloud::cpp::compute::storage_pools::v1::
          DeleteStoragePoolRequest const& request);

  virtual google::cloud::Idempotency GetStoragePool(
      google::cloud::cpp::compute::storage_pools::v1::
          GetStoragePoolRequest const& request);

  virtual google::cloud::Idempotency GetIamPolicy(
      google::cloud::cpp::compute::storage_pools::v1::GetIamPolicyRequest const&
          request);

  virtual google::cloud::Idempotency InsertStoragePool(
      google::cloud::cpp::compute::storage_pools::v1::
          InsertStoragePoolRequest const& request);

  virtual google::cloud::Idempotency ListStoragePools(
      google::cloud::cpp::compute::storage_pools::v1::ListStoragePoolsRequest
          request);

  virtual google::cloud::Idempotency ListDisks(
      google::cloud::cpp::compute::storage_pools::v1::ListDisksRequest request);

  virtual google::cloud::Idempotency SetIamPolicy(
      google::cloud::cpp::compute::storage_pools::v1::SetIamPolicyRequest const&
          request);

  virtual google::cloud::Idempotency TestIamPermissions(
      google::cloud::cpp::compute::storage_pools::v1::
          TestIamPermissionsRequest const& request);

  virtual google::cloud::Idempotency UpdateStoragePool(
      google::cloud::cpp::compute::storage_pools::v1::
          UpdateStoragePoolRequest const& request);
};

std::unique_ptr<StoragePoolsConnectionIdempotencyPolicy>
MakeDefaultStoragePoolsConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_storage_pools_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_STORAGE_POOLS_V1_STORAGE_POOLS_CONNECTION_IDEMPOTENCY_POLICY_H
