// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/snapshots/v1/snapshots.proto

#include "google/cloud/compute/snapshots/v1/internal/snapshots_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_snapshots_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

SnapshotsTracingConnection::SnapshotsTracingConnection(
    std::shared_ptr<compute_snapshots_v1::SnapshotsConnection> child)
    : child_(std::move(child)) {}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
SnapshotsTracingConnection::DeleteSnapshot(
    google::cloud::cpp::compute::snapshots::v1::DeleteSnapshotRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_snapshots_v1::SnapshotsConnection::DeleteSnapshot");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteSnapshot(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
SnapshotsTracingConnection::DeleteSnapshot(
    NoAwaitTag,
    google::cloud::cpp::compute::snapshots::v1::DeleteSnapshotRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_snapshots_v1::SnapshotsConnection::DeleteSnapshot");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteSnapshot(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
SnapshotsTracingConnection::DeleteSnapshot(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_snapshots_v1::SnapshotsConnection::DeleteSnapshot");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteSnapshot(operation));
}

StatusOr<google::cloud::cpp::compute::v1::Snapshot>
SnapshotsTracingConnection::GetSnapshot(
    google::cloud::cpp::compute::snapshots::v1::GetSnapshotRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_snapshots_v1::SnapshotsConnection::GetSnapshot");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetSnapshot(request));
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
SnapshotsTracingConnection::GetIamPolicy(
    google::cloud::cpp::compute::snapshots::v1::GetIamPolicyRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_snapshots_v1::SnapshotsConnection::GetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetIamPolicy(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
SnapshotsTracingConnection::InsertSnapshot(
    google::cloud::cpp::compute::snapshots::v1::InsertSnapshotRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_snapshots_v1::SnapshotsConnection::InsertSnapshot");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->InsertSnapshot(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
SnapshotsTracingConnection::InsertSnapshot(
    NoAwaitTag,
    google::cloud::cpp::compute::snapshots::v1::InsertSnapshotRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_snapshots_v1::SnapshotsConnection::InsertSnapshot");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->InsertSnapshot(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
SnapshotsTracingConnection::InsertSnapshot(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_snapshots_v1::SnapshotsConnection::InsertSnapshot");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->InsertSnapshot(operation));
}

StreamRange<google::cloud::cpp::compute::v1::Snapshot>
SnapshotsTracingConnection::ListSnapshots(
    google::cloud::cpp::compute::snapshots::v1::ListSnapshotsRequest request) {
  auto span = internal::MakeSpan(
      "compute_snapshots_v1::SnapshotsConnection::ListSnapshots");
  internal::OTelScope scope(span);
  auto sr = child_->ListSnapshots(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::cpp::compute::v1::Snapshot>(std::move(span),
                                                 std::move(sr));
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
SnapshotsTracingConnection::SetIamPolicy(
    google::cloud::cpp::compute::snapshots::v1::SetIamPolicyRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_snapshots_v1::SnapshotsConnection::SetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->SetIamPolicy(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
SnapshotsTracingConnection::SetLabels(
    google::cloud::cpp::compute::snapshots::v1::SetLabelsRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_snapshots_v1::SnapshotsConnection::SetLabels");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->SetLabels(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
SnapshotsTracingConnection::SetLabels(
    NoAwaitTag,
    google::cloud::cpp::compute::snapshots::v1::SetLabelsRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_snapshots_v1::SnapshotsConnection::SetLabels");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->SetLabels(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
SnapshotsTracingConnection::SetLabels(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_snapshots_v1::SnapshotsConnection::SetLabels");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->SetLabels(operation));
}

StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
SnapshotsTracingConnection::TestIamPermissions(
    google::cloud::cpp::compute::snapshots::v1::TestIamPermissionsRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_snapshots_v1::SnapshotsConnection::TestIamPermissions");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->TestIamPermissions(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<compute_snapshots_v1::SnapshotsConnection>
MakeSnapshotsTracingConnection(
    std::shared_ptr<compute_snapshots_v1::SnapshotsConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<SnapshotsTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_snapshots_v1_internal
}  // namespace cloud
}  // namespace google
