// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/routers/v1/routers.proto

#include "google/cloud/compute/routers/v1/routers_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_routers_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

RoutersClient::RoutersClient(std::shared_ptr<RoutersConnection> connection,
                             Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
RoutersClient::~RoutersClient() = default;

StreamRange<
    std::pair<std::string, google::cloud::cpp::compute::v1::RoutersScopedList>>
RoutersClient::AggregatedListRouters(std::string const& project, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::routers::v1::AggregatedListRoutersRequest
      request;
  request.set_project(project);
  return connection_->AggregatedListRouters(request);
}

StreamRange<
    std::pair<std::string, google::cloud::cpp::compute::v1::RoutersScopedList>>
RoutersClient::AggregatedListRouters(
    google::cloud::cpp::compute::routers::v1::AggregatedListRoutersRequest
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AggregatedListRouters(std::move(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RoutersClient::DeleteRouter(std::string const& project,
                            std::string const& region,
                            std::string const& router, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::routers::v1::DeleteRouterRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_router(router);
  return connection_->DeleteRouter(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
RoutersClient::DeleteRouter(NoAwaitTag, std::string const& project,
                            std::string const& region,
                            std::string const& router, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::routers::v1::DeleteRouterRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_router(router);
  return connection_->DeleteRouter(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RoutersClient::DeleteRouter(
    google::cloud::cpp::compute::routers::v1::DeleteRouterRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteRouter(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
RoutersClient::DeleteRouter(
    NoAwaitTag,
    google::cloud::cpp::compute::routers::v1::DeleteRouterRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteRouter(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RoutersClient::DeleteRouter(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteRouter(operation);
}

StatusOr<google::cloud::cpp::compute::v1::Router> RoutersClient::GetRouter(
    std::string const& project, std::string const& region,
    std::string const& router, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::routers::v1::GetRouterRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_router(router);
  return connection_->GetRouter(request);
}

StatusOr<google::cloud::cpp::compute::v1::Router> RoutersClient::GetRouter(
    google::cloud::cpp::compute::routers::v1::GetRouterRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetRouter(request);
}

StatusOr<google::cloud::cpp::compute::v1::NatIpInfoResponse>
RoutersClient::GetNatIpInfo(std::string const& project,
                            std::string const& region,
                            std::string const& router, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::routers::v1::GetNatIpInfoRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_router(router);
  return connection_->GetNatIpInfo(request);
}

StatusOr<google::cloud::cpp::compute::v1::NatIpInfoResponse>
RoutersClient::GetNatIpInfo(
    google::cloud::cpp::compute::routers::v1::GetNatIpInfoRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetNatIpInfo(request);
}

StatusOr<google::cloud::cpp::compute::v1::VmEndpointNatMappingsList>
RoutersClient::GetNatMappingInfo(std::string const& project,
                                 std::string const& region,
                                 std::string const& router, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::routers::v1::GetNatMappingInfoRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_router(router);
  return connection_->GetNatMappingInfo(request);
}

StatusOr<google::cloud::cpp::compute::v1::VmEndpointNatMappingsList>
RoutersClient::GetNatMappingInfo(
    google::cloud::cpp::compute::routers::v1::GetNatMappingInfoRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetNatMappingInfo(request);
}

StatusOr<google::cloud::cpp::compute::v1::RouterStatusResponse>
RoutersClient::GetRouterStatus(std::string const& project,
                               std::string const& region,
                               std::string const& router, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::routers::v1::GetRouterStatusRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_router(router);
  return connection_->GetRouterStatus(request);
}

StatusOr<google::cloud::cpp::compute::v1::RouterStatusResponse>
RoutersClient::GetRouterStatus(
    google::cloud::cpp::compute::routers::v1::GetRouterStatusRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetRouterStatus(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RoutersClient::InsertRouter(
    std::string const& project, std::string const& region,
    google::cloud::cpp::compute::v1::Router const& router_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::routers::v1::InsertRouterRequest request;
  request.set_project(project);
  request.set_region(region);
  *request.mutable_router_resource() = router_resource;
  return connection_->InsertRouter(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
RoutersClient::InsertRouter(
    NoAwaitTag, std::string const& project, std::string const& region,
    google::cloud::cpp::compute::v1::Router const& router_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::routers::v1::InsertRouterRequest request;
  request.set_project(project);
  request.set_region(region);
  *request.mutable_router_resource() = router_resource;
  return connection_->InsertRouter(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RoutersClient::InsertRouter(
    google::cloud::cpp::compute::routers::v1::InsertRouterRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertRouter(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
RoutersClient::InsertRouter(
    NoAwaitTag,
    google::cloud::cpp::compute::routers::v1::InsertRouterRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertRouter(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RoutersClient::InsertRouter(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertRouter(operation);
}

StreamRange<google::cloud::cpp::compute::v1::Router> RoutersClient::ListRouters(
    std::string const& project, std::string const& region, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::routers::v1::ListRoutersRequest request;
  request.set_project(project);
  request.set_region(region);
  return connection_->ListRouters(request);
}

StreamRange<google::cloud::cpp::compute::v1::Router> RoutersClient::ListRouters(
    google::cloud::cpp::compute::routers::v1::ListRoutersRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListRouters(std::move(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RoutersClient::PatchRouter(
    std::string const& project, std::string const& region,
    std::string const& router,
    google::cloud::cpp::compute::v1::Router const& router_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::routers::v1::PatchRouterRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_router(router);
  *request.mutable_router_resource() = router_resource;
  return connection_->PatchRouter(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation> RoutersClient::PatchRouter(
    NoAwaitTag, std::string const& project, std::string const& region,
    std::string const& router,
    google::cloud::cpp::compute::v1::Router const& router_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::routers::v1::PatchRouterRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_router(router);
  *request.mutable_router_resource() = router_resource;
  return connection_->PatchRouter(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RoutersClient::PatchRouter(
    google::cloud::cpp::compute::routers::v1::PatchRouterRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PatchRouter(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation> RoutersClient::PatchRouter(
    NoAwaitTag,
    google::cloud::cpp::compute::routers::v1::PatchRouterRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PatchRouter(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RoutersClient::PatchRouter(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PatchRouter(operation);
}

StatusOr<google::cloud::cpp::compute::v1::RoutersPreviewResponse>
RoutersClient::Preview(
    std::string const& project, std::string const& region,
    std::string const& router,
    google::cloud::cpp::compute::v1::Router const& router_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::routers::v1::PreviewRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_router(router);
  *request.mutable_router_resource() = router_resource;
  return connection_->Preview(request);
}

StatusOr<google::cloud::cpp::compute::v1::RoutersPreviewResponse>
RoutersClient::Preview(
    google::cloud::cpp::compute::routers::v1::PreviewRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->Preview(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RoutersClient::UpdateRouter(
    std::string const& project, std::string const& region,
    std::string const& router,
    google::cloud::cpp::compute::v1::Router const& router_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::routers::v1::UpdateRouterRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_router(router);
  *request.mutable_router_resource() = router_resource;
  return connection_->UpdateRouter(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
RoutersClient::UpdateRouter(
    NoAwaitTag, std::string const& project, std::string const& region,
    std::string const& router,
    google::cloud::cpp::compute::v1::Router const& router_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::routers::v1::UpdateRouterRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_router(router);
  *request.mutable_router_resource() = router_resource;
  return connection_->UpdateRouter(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RoutersClient::UpdateRouter(
    google::cloud::cpp::compute::routers::v1::UpdateRouterRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateRouter(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
RoutersClient::UpdateRouter(
    NoAwaitTag,
    google::cloud::cpp::compute::routers::v1::UpdateRouterRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateRouter(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RoutersClient::UpdateRouter(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateRouter(operation);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_routers_v1
}  // namespace cloud
}  // namespace google
