// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/resource_policies/v1/resource_policies.proto

#include "google/cloud/compute/resource_policies/v1/internal/resource_policies_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_resource_policies_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

ResourcePoliciesTracingConnection::ResourcePoliciesTracingConnection(
    std::shared_ptr<compute_resource_policies_v1::ResourcePoliciesConnection>
        child)
    : child_(std::move(child)) {}

StreamRange<std::pair<
    std::string, google::cloud::cpp::compute::v1::ResourcePoliciesScopedList>>
ResourcePoliciesTracingConnection::AggregatedListResourcePolicies(
    google::cloud::cpp::compute::resource_policies::v1::
        AggregatedListResourcePoliciesRequest request) {
  auto span = internal::MakeSpan(
      "compute_resource_policies_v1::ResourcePoliciesConnection::"
      "AggregatedListResourcePolicies");
  internal::OTelScope scope(span);
  auto sr = child_->AggregatedListResourcePolicies(std::move(request));
  return internal::MakeTracedStreamRange<
      std::pair<std::string,
                google::cloud::cpp::compute::v1::ResourcePoliciesScopedList>>(
      std::move(span), std::move(sr));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
ResourcePoliciesTracingConnection::DeleteResourcePolicy(
    google::cloud::cpp::compute::resource_policies::v1::
        DeleteResourcePolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_resource_policies_v1::ResourcePoliciesConnection::"
      "DeleteResourcePolicy");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteResourcePolicy(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
ResourcePoliciesTracingConnection::DeleteResourcePolicy(
    NoAwaitTag, google::cloud::cpp::compute::resource_policies::v1::
                    DeleteResourcePolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_resource_policies_v1::ResourcePoliciesConnection::"
      "DeleteResourcePolicy");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteResourcePolicy(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
ResourcePoliciesTracingConnection::DeleteResourcePolicy(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_resource_policies_v1::ResourcePoliciesConnection::"
      "DeleteResourcePolicy");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteResourcePolicy(operation));
}

StatusOr<google::cloud::cpp::compute::v1::ResourcePolicy>
ResourcePoliciesTracingConnection::GetResourcePolicy(
    google::cloud::cpp::compute::resource_policies::v1::
        GetResourcePolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_resource_policies_v1::ResourcePoliciesConnection::"
      "GetResourcePolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetResourcePolicy(request));
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
ResourcePoliciesTracingConnection::GetIamPolicy(
    google::cloud::cpp::compute::resource_policies::v1::
        GetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_resource_policies_v1::ResourcePoliciesConnection::GetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetIamPolicy(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
ResourcePoliciesTracingConnection::InsertResourcePolicy(
    google::cloud::cpp::compute::resource_policies::v1::
        InsertResourcePolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_resource_policies_v1::ResourcePoliciesConnection::"
      "InsertResourcePolicy");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->InsertResourcePolicy(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
ResourcePoliciesTracingConnection::InsertResourcePolicy(
    NoAwaitTag, google::cloud::cpp::compute::resource_policies::v1::
                    InsertResourcePolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_resource_policies_v1::ResourcePoliciesConnection::"
      "InsertResourcePolicy");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->InsertResourcePolicy(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
ResourcePoliciesTracingConnection::InsertResourcePolicy(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_resource_policies_v1::ResourcePoliciesConnection::"
      "InsertResourcePolicy");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->InsertResourcePolicy(operation));
}

StreamRange<google::cloud::cpp::compute::v1::ResourcePolicy>
ResourcePoliciesTracingConnection::ListResourcePolicies(
    google::cloud::cpp::compute::resource_policies::v1::
        ListResourcePoliciesRequest request) {
  auto span = internal::MakeSpan(
      "compute_resource_policies_v1::ResourcePoliciesConnection::"
      "ListResourcePolicies");
  internal::OTelScope scope(span);
  auto sr = child_->ListResourcePolicies(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::cpp::compute::v1::ResourcePolicy>(std::move(span),
                                                       std::move(sr));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
ResourcePoliciesTracingConnection::PatchResourcePolicy(
    google::cloud::cpp::compute::resource_policies::v1::
        PatchResourcePolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_resource_policies_v1::ResourcePoliciesConnection::"
      "PatchResourcePolicy");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->PatchResourcePolicy(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
ResourcePoliciesTracingConnection::PatchResourcePolicy(
    NoAwaitTag, google::cloud::cpp::compute::resource_policies::v1::
                    PatchResourcePolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_resource_policies_v1::ResourcePoliciesConnection::"
      "PatchResourcePolicy");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->PatchResourcePolicy(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
ResourcePoliciesTracingConnection::PatchResourcePolicy(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_resource_policies_v1::ResourcePoliciesConnection::"
      "PatchResourcePolicy");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->PatchResourcePolicy(operation));
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
ResourcePoliciesTracingConnection::SetIamPolicy(
    google::cloud::cpp::compute::resource_policies::v1::
        SetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_resource_policies_v1::ResourcePoliciesConnection::SetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->SetIamPolicy(request));
}

StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
ResourcePoliciesTracingConnection::TestIamPermissions(
    google::cloud::cpp::compute::resource_policies::v1::
        TestIamPermissionsRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_resource_policies_v1::ResourcePoliciesConnection::"
      "TestIamPermissions");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->TestIamPermissions(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<compute_resource_policies_v1::ResourcePoliciesConnection>
MakeResourcePoliciesTracingConnection(
    std::shared_ptr<compute_resource_policies_v1::ResourcePoliciesConnection>
        conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<ResourcePoliciesTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_resource_policies_v1_internal
}  // namespace cloud
}  // namespace google
