// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/cloudcontrolspartner/v1/monitoring.proto

#include "google/cloud/cloudcontrolspartner/v1/internal/cloud_controls_partner_monitoring_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace cloudcontrolspartner_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

CloudControlsPartnerMonitoringTracingStub::
    CloudControlsPartnerMonitoringTracingStub(
        std::shared_ptr<CloudControlsPartnerMonitoringStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::cloudcontrolspartner::v1::ListViolationsResponse>
CloudControlsPartnerMonitoringTracingStub::ListViolations(
    grpc::ClientContext& context, Options const& options,
    google::cloud::cloudcontrolspartner::v1::ListViolationsRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.cloudcontrolspartner.v1.CloudControlsPartnerMonitoring",
      "ListViolations");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListViolations(context, options, request));
}

StatusOr<google::cloud::cloudcontrolspartner::v1::Violation>
CloudControlsPartnerMonitoringTracingStub::GetViolation(
    grpc::ClientContext& context, Options const& options,
    google::cloud::cloudcontrolspartner::v1::GetViolationRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.cloudcontrolspartner.v1.CloudControlsPartnerMonitoring",
      "GetViolation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetViolation(context, options, request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<CloudControlsPartnerMonitoringStub>
MakeCloudControlsPartnerMonitoringTracingStub(
    std::shared_ptr<CloudControlsPartnerMonitoringStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<CloudControlsPartnerMonitoringTracingStub>(
      std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace cloudcontrolspartner_v1_internal
}  // namespace cloud
}  // namespace google
