// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/appengine/v1/appengine.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APPENGINE_V1_INTERNAL_VERSIONS_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APPENGINE_V1_INTERNAL_VERSIONS_TRACING_CONNECTION_H

#include "google/cloud/appengine/v1/versions_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace appengine_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class VersionsTracingConnection : public appengine_v1::VersionsConnection {
 public:
  ~VersionsTracingConnection() override = default;

  explicit VersionsTracingConnection(
      std::shared_ptr<appengine_v1::VersionsConnection> child);

  Options options() override { return child_->options(); }

  StreamRange<google::appengine::v1::Version> ListVersions(
      google::appengine::v1::ListVersionsRequest request) override;

  StatusOr<google::appengine::v1::Version> GetVersion(
      google::appengine::v1::GetVersionRequest const& request) override;

  future<StatusOr<google::appengine::v1::Version>> CreateVersion(
      google::appengine::v1::CreateVersionRequest const& request) override;

  StatusOr<google::longrunning::Operation> CreateVersion(
      NoAwaitTag,
      google::appengine::v1::CreateVersionRequest const& request) override;

  future<StatusOr<google::appengine::v1::Version>> CreateVersion(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::appengine::v1::Version>> UpdateVersion(
      google::appengine::v1::UpdateVersionRequest const& request) override;

  StatusOr<google::longrunning::Operation> UpdateVersion(
      NoAwaitTag,
      google::appengine::v1::UpdateVersionRequest const& request) override;

  future<StatusOr<google::appengine::v1::Version>> UpdateVersion(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::appengine::v1::OperationMetadataV1>> DeleteVersion(
      google::appengine::v1::DeleteVersionRequest const& request) override;

  StatusOr<google::longrunning::Operation> DeleteVersion(
      NoAwaitTag,
      google::appengine::v1::DeleteVersionRequest const& request) override;

  future<StatusOr<google::appengine::v1::OperationMetadataV1>> DeleteVersion(
      google::longrunning::Operation const& operation) override;

 private:
  std::shared_ptr<appengine_v1::VersionsConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<appengine_v1::VersionsConnection> MakeVersionsTracingConnection(
    std::shared_ptr<appengine_v1::VersionsConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace appengine_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APPENGINE_V1_INTERNAL_VERSIONS_TRACING_CONNECTION_H
