// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/alloydb/v1/service.proto

#include "google/cloud/alloydb/v1/internal/alloy_db_admin_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace alloydb_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

AlloyDBAdminTracingConnection::AlloyDBAdminTracingConnection(
    std::shared_ptr<alloydb_v1::AlloyDBAdminConnection> child)
    : child_(std::move(child)) {}

StreamRange<google::cloud::alloydb::v1::Cluster>
AlloyDBAdminTracingConnection::ListClusters(
    google::cloud::alloydb::v1::ListClustersRequest request) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::ListClusters");
  internal::OTelScope scope(span);
  auto sr = child_->ListClusters(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::alloydb::v1::Cluster>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::alloydb::v1::Cluster>
AlloyDBAdminTracingConnection::GetCluster(
    google::cloud::alloydb::v1::GetClusterRequest const& request) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::GetCluster");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetCluster(request));
}

future<StatusOr<google::cloud::alloydb::v1::Cluster>>
AlloyDBAdminTracingConnection::CreateCluster(
    google::cloud::alloydb::v1::CreateClusterRequest const& request) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::CreateCluster");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateCluster(request));
}

StatusOr<google::longrunning::Operation>
AlloyDBAdminTracingConnection::CreateCluster(
    NoAwaitTag,
    google::cloud::alloydb::v1::CreateClusterRequest const& request) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::CreateCluster");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->CreateCluster(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::alloydb::v1::Cluster>>
AlloyDBAdminTracingConnection::CreateCluster(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::CreateCluster");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateCluster(operation));
}

future<StatusOr<google::cloud::alloydb::v1::Cluster>>
AlloyDBAdminTracingConnection::UpdateCluster(
    google::cloud::alloydb::v1::UpdateClusterRequest const& request) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::UpdateCluster");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateCluster(request));
}

StatusOr<google::longrunning::Operation>
AlloyDBAdminTracingConnection::UpdateCluster(
    NoAwaitTag,
    google::cloud::alloydb::v1::UpdateClusterRequest const& request) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::UpdateCluster");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->UpdateCluster(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::alloydb::v1::Cluster>>
AlloyDBAdminTracingConnection::UpdateCluster(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::UpdateCluster");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateCluster(operation));
}

future<StatusOr<google::cloud::alloydb::v1::OperationMetadata>>
AlloyDBAdminTracingConnection::DeleteCluster(
    google::cloud::alloydb::v1::DeleteClusterRequest const& request) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::DeleteCluster");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteCluster(request));
}

StatusOr<google::longrunning::Operation>
AlloyDBAdminTracingConnection::DeleteCluster(
    NoAwaitTag,
    google::cloud::alloydb::v1::DeleteClusterRequest const& request) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::DeleteCluster");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->DeleteCluster(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::alloydb::v1::OperationMetadata>>
AlloyDBAdminTracingConnection::DeleteCluster(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::DeleteCluster");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteCluster(operation));
}

future<StatusOr<google::cloud::alloydb::v1::Cluster>>
AlloyDBAdminTracingConnection::PromoteCluster(
    google::cloud::alloydb::v1::PromoteClusterRequest const& request) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::PromoteCluster");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->PromoteCluster(request));
}

StatusOr<google::longrunning::Operation>
AlloyDBAdminTracingConnection::PromoteCluster(
    NoAwaitTag,
    google::cloud::alloydb::v1::PromoteClusterRequest const& request) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::PromoteCluster");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->PromoteCluster(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::alloydb::v1::Cluster>>
AlloyDBAdminTracingConnection::PromoteCluster(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::PromoteCluster");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->PromoteCluster(operation));
}

future<StatusOr<google::cloud::alloydb::v1::Cluster>>
AlloyDBAdminTracingConnection::RestoreCluster(
    google::cloud::alloydb::v1::RestoreClusterRequest const& request) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::RestoreCluster");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->RestoreCluster(request));
}

StatusOr<google::longrunning::Operation>
AlloyDBAdminTracingConnection::RestoreCluster(
    NoAwaitTag,
    google::cloud::alloydb::v1::RestoreClusterRequest const& request) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::RestoreCluster");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->RestoreCluster(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::alloydb::v1::Cluster>>
AlloyDBAdminTracingConnection::RestoreCluster(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::RestoreCluster");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->RestoreCluster(operation));
}

future<StatusOr<google::cloud::alloydb::v1::Cluster>>
AlloyDBAdminTracingConnection::CreateSecondaryCluster(
    google::cloud::alloydb::v1::CreateSecondaryClusterRequest const& request) {
  auto span = internal::MakeSpan(
      "alloydb_v1::AlloyDBAdminConnection::CreateSecondaryCluster");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateSecondaryCluster(request));
}

StatusOr<google::longrunning::Operation>
AlloyDBAdminTracingConnection::CreateSecondaryCluster(
    NoAwaitTag,
    google::cloud::alloydb::v1::CreateSecondaryClusterRequest const& request) {
  auto span = internal::MakeSpan(
      "alloydb_v1::AlloyDBAdminConnection::CreateSecondaryCluster");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->CreateSecondaryCluster(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::alloydb::v1::Cluster>>
AlloyDBAdminTracingConnection::CreateSecondaryCluster(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "alloydb_v1::AlloyDBAdminConnection::CreateSecondaryCluster");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateSecondaryCluster(operation));
}

StreamRange<google::cloud::alloydb::v1::Instance>
AlloyDBAdminTracingConnection::ListInstances(
    google::cloud::alloydb::v1::ListInstancesRequest request) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::ListInstances");
  internal::OTelScope scope(span);
  auto sr = child_->ListInstances(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::alloydb::v1::Instance>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::alloydb::v1::Instance>
AlloyDBAdminTracingConnection::GetInstance(
    google::cloud::alloydb::v1::GetInstanceRequest const& request) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::GetInstance");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetInstance(request));
}

future<StatusOr<google::cloud::alloydb::v1::Instance>>
AlloyDBAdminTracingConnection::CreateInstance(
    google::cloud::alloydb::v1::CreateInstanceRequest const& request) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::CreateInstance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateInstance(request));
}

StatusOr<google::longrunning::Operation>
AlloyDBAdminTracingConnection::CreateInstance(
    NoAwaitTag,
    google::cloud::alloydb::v1::CreateInstanceRequest const& request) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::CreateInstance");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->CreateInstance(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::alloydb::v1::Instance>>
AlloyDBAdminTracingConnection::CreateInstance(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::CreateInstance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateInstance(operation));
}

future<StatusOr<google::cloud::alloydb::v1::Instance>>
AlloyDBAdminTracingConnection::CreateSecondaryInstance(
    google::cloud::alloydb::v1::CreateSecondaryInstanceRequest const& request) {
  auto span = internal::MakeSpan(
      "alloydb_v1::AlloyDBAdminConnection::CreateSecondaryInstance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateSecondaryInstance(request));
}

StatusOr<google::longrunning::Operation>
AlloyDBAdminTracingConnection::CreateSecondaryInstance(
    NoAwaitTag,
    google::cloud::alloydb::v1::CreateSecondaryInstanceRequest const& request) {
  auto span = internal::MakeSpan(
      "alloydb_v1::AlloyDBAdminConnection::CreateSecondaryInstance");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->CreateSecondaryInstance(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::alloydb::v1::Instance>>
AlloyDBAdminTracingConnection::CreateSecondaryInstance(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "alloydb_v1::AlloyDBAdminConnection::CreateSecondaryInstance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateSecondaryInstance(operation));
}

future<StatusOr<google::cloud::alloydb::v1::BatchCreateInstancesResponse>>
AlloyDBAdminTracingConnection::BatchCreateInstances(
    google::cloud::alloydb::v1::BatchCreateInstancesRequest const& request) {
  auto span = internal::MakeSpan(
      "alloydb_v1::AlloyDBAdminConnection::BatchCreateInstances");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->BatchCreateInstances(request));
}

StatusOr<google::longrunning::Operation>
AlloyDBAdminTracingConnection::BatchCreateInstances(
    NoAwaitTag,
    google::cloud::alloydb::v1::BatchCreateInstancesRequest const& request) {
  auto span = internal::MakeSpan(
      "alloydb_v1::AlloyDBAdminConnection::BatchCreateInstances");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->BatchCreateInstances(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::alloydb::v1::BatchCreateInstancesResponse>>
AlloyDBAdminTracingConnection::BatchCreateInstances(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "alloydb_v1::AlloyDBAdminConnection::BatchCreateInstances");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->BatchCreateInstances(operation));
}

future<StatusOr<google::cloud::alloydb::v1::Instance>>
AlloyDBAdminTracingConnection::UpdateInstance(
    google::cloud::alloydb::v1::UpdateInstanceRequest const& request) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::UpdateInstance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateInstance(request));
}

StatusOr<google::longrunning::Operation>
AlloyDBAdminTracingConnection::UpdateInstance(
    NoAwaitTag,
    google::cloud::alloydb::v1::UpdateInstanceRequest const& request) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::UpdateInstance");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->UpdateInstance(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::alloydb::v1::Instance>>
AlloyDBAdminTracingConnection::UpdateInstance(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::UpdateInstance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateInstance(operation));
}

future<StatusOr<google::cloud::alloydb::v1::OperationMetadata>>
AlloyDBAdminTracingConnection::DeleteInstance(
    google::cloud::alloydb::v1::DeleteInstanceRequest const& request) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::DeleteInstance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteInstance(request));
}

StatusOr<google::longrunning::Operation>
AlloyDBAdminTracingConnection::DeleteInstance(
    NoAwaitTag,
    google::cloud::alloydb::v1::DeleteInstanceRequest const& request) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::DeleteInstance");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteInstance(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::alloydb::v1::OperationMetadata>>
AlloyDBAdminTracingConnection::DeleteInstance(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::DeleteInstance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteInstance(operation));
}

future<StatusOr<google::cloud::alloydb::v1::Instance>>
AlloyDBAdminTracingConnection::FailoverInstance(
    google::cloud::alloydb::v1::FailoverInstanceRequest const& request) {
  auto span = internal::MakeSpan(
      "alloydb_v1::AlloyDBAdminConnection::FailoverInstance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->FailoverInstance(request));
}

StatusOr<google::longrunning::Operation>
AlloyDBAdminTracingConnection::FailoverInstance(
    NoAwaitTag,
    google::cloud::alloydb::v1::FailoverInstanceRequest const& request) {
  auto span = internal::MakeSpan(
      "alloydb_v1::AlloyDBAdminConnection::FailoverInstance");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->FailoverInstance(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::alloydb::v1::Instance>>
AlloyDBAdminTracingConnection::FailoverInstance(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "alloydb_v1::AlloyDBAdminConnection::FailoverInstance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->FailoverInstance(operation));
}

future<StatusOr<google::cloud::alloydb::v1::Instance>>
AlloyDBAdminTracingConnection::InjectFault(
    google::cloud::alloydb::v1::InjectFaultRequest const& request) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::InjectFault");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->InjectFault(request));
}

StatusOr<google::longrunning::Operation>
AlloyDBAdminTracingConnection::InjectFault(
    NoAwaitTag, google::cloud::alloydb::v1::InjectFaultRequest const& request) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::InjectFault");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->InjectFault(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::alloydb::v1::Instance>>
AlloyDBAdminTracingConnection::InjectFault(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::InjectFault");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->InjectFault(operation));
}

future<StatusOr<google::cloud::alloydb::v1::Instance>>
AlloyDBAdminTracingConnection::RestartInstance(
    google::cloud::alloydb::v1::RestartInstanceRequest const& request) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::RestartInstance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->RestartInstance(request));
}

StatusOr<google::longrunning::Operation>
AlloyDBAdminTracingConnection::RestartInstance(
    NoAwaitTag,
    google::cloud::alloydb::v1::RestartInstanceRequest const& request) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::RestartInstance");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->RestartInstance(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::alloydb::v1::Instance>>
AlloyDBAdminTracingConnection::RestartInstance(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::RestartInstance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->RestartInstance(operation));
}

StreamRange<google::cloud::alloydb::v1::Backup>
AlloyDBAdminTracingConnection::ListBackups(
    google::cloud::alloydb::v1::ListBackupsRequest request) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::ListBackups");
  internal::OTelScope scope(span);
  auto sr = child_->ListBackups(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::alloydb::v1::Backup>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::alloydb::v1::Backup>
AlloyDBAdminTracingConnection::GetBackup(
    google::cloud::alloydb::v1::GetBackupRequest const& request) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::GetBackup");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetBackup(request));
}

future<StatusOr<google::cloud::alloydb::v1::Backup>>
AlloyDBAdminTracingConnection::CreateBackup(
    google::cloud::alloydb::v1::CreateBackupRequest const& request) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::CreateBackup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateBackup(request));
}

StatusOr<google::longrunning::Operation>
AlloyDBAdminTracingConnection::CreateBackup(
    NoAwaitTag,
    google::cloud::alloydb::v1::CreateBackupRequest const& request) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::CreateBackup");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->CreateBackup(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::alloydb::v1::Backup>>
AlloyDBAdminTracingConnection::CreateBackup(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::CreateBackup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateBackup(operation));
}

future<StatusOr<google::cloud::alloydb::v1::Backup>>
AlloyDBAdminTracingConnection::UpdateBackup(
    google::cloud::alloydb::v1::UpdateBackupRequest const& request) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::UpdateBackup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateBackup(request));
}

StatusOr<google::longrunning::Operation>
AlloyDBAdminTracingConnection::UpdateBackup(
    NoAwaitTag,
    google::cloud::alloydb::v1::UpdateBackupRequest const& request) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::UpdateBackup");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->UpdateBackup(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::alloydb::v1::Backup>>
AlloyDBAdminTracingConnection::UpdateBackup(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::UpdateBackup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateBackup(operation));
}

future<StatusOr<google::cloud::alloydb::v1::OperationMetadata>>
AlloyDBAdminTracingConnection::DeleteBackup(
    google::cloud::alloydb::v1::DeleteBackupRequest const& request) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::DeleteBackup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteBackup(request));
}

StatusOr<google::longrunning::Operation>
AlloyDBAdminTracingConnection::DeleteBackup(
    NoAwaitTag,
    google::cloud::alloydb::v1::DeleteBackupRequest const& request) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::DeleteBackup");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->DeleteBackup(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::alloydb::v1::OperationMetadata>>
AlloyDBAdminTracingConnection::DeleteBackup(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::DeleteBackup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteBackup(operation));
}

StreamRange<google::cloud::alloydb::v1::SupportedDatabaseFlag>
AlloyDBAdminTracingConnection::ListSupportedDatabaseFlags(
    google::cloud::alloydb::v1::ListSupportedDatabaseFlagsRequest request) {
  auto span = internal::MakeSpan(
      "alloydb_v1::AlloyDBAdminConnection::ListSupportedDatabaseFlags");
  internal::OTelScope scope(span);
  auto sr = child_->ListSupportedDatabaseFlags(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::alloydb::v1::SupportedDatabaseFlag>(std::move(span),
                                                         std::move(sr));
}

StatusOr<google::cloud::alloydb::v1::GenerateClientCertificateResponse>
AlloyDBAdminTracingConnection::GenerateClientCertificate(
    google::cloud::alloydb::v1::GenerateClientCertificateRequest const&
        request) {
  auto span = internal::MakeSpan(
      "alloydb_v1::AlloyDBAdminConnection::GenerateClientCertificate");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GenerateClientCertificate(request));
}

StatusOr<google::cloud::alloydb::v1::ConnectionInfo>
AlloyDBAdminTracingConnection::GetConnectionInfo(
    google::cloud::alloydb::v1::GetConnectionInfoRequest const& request) {
  auto span = internal::MakeSpan(
      "alloydb_v1::AlloyDBAdminConnection::GetConnectionInfo");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetConnectionInfo(request));
}

StreamRange<google::cloud::alloydb::v1::User>
AlloyDBAdminTracingConnection::ListUsers(
    google::cloud::alloydb::v1::ListUsersRequest request) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::ListUsers");
  internal::OTelScope scope(span);
  auto sr = child_->ListUsers(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::alloydb::v1::User>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::alloydb::v1::User>
AlloyDBAdminTracingConnection::GetUser(
    google::cloud::alloydb::v1::GetUserRequest const& request) {
  auto span = internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::GetUser");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetUser(request));
}

StatusOr<google::cloud::alloydb::v1::User>
AlloyDBAdminTracingConnection::CreateUser(
    google::cloud::alloydb::v1::CreateUserRequest const& request) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::CreateUser");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateUser(request));
}

StatusOr<google::cloud::alloydb::v1::User>
AlloyDBAdminTracingConnection::UpdateUser(
    google::cloud::alloydb::v1::UpdateUserRequest const& request) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::UpdateUser");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateUser(request));
}

Status AlloyDBAdminTracingConnection::DeleteUser(
    google::cloud::alloydb::v1::DeleteUserRequest const& request) {
  auto span =
      internal::MakeSpan("alloydb_v1::AlloyDBAdminConnection::DeleteUser");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteUser(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<alloydb_v1::AlloyDBAdminConnection>
MakeAlloyDBAdminTracingConnection(
    std::shared_ptr<alloydb_v1::AlloyDBAdminConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<AlloyDBAdminTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace alloydb_v1_internal
}  // namespace cloud
}  // namespace google
