// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/index_service.proto

#include "google/cloud/aiplatform/v1/index_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace aiplatform_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

IndexServiceClient::IndexServiceClient(
    std::shared_ptr<IndexServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
IndexServiceClient::~IndexServiceClient() = default;

future<StatusOr<google::cloud::aiplatform::v1::Index>>
IndexServiceClient::CreateIndex(
    std::string const& parent,
    google::cloud::aiplatform::v1::Index const& index, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::CreateIndexRequest request;
  request.set_parent(parent);
  *request.mutable_index() = index;
  return connection_->CreateIndex(request);
}

StatusOr<google::longrunning::Operation> IndexServiceClient::CreateIndex(
    NoAwaitTag, std::string const& parent,
    google::cloud::aiplatform::v1::Index const& index, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::CreateIndexRequest request;
  request.set_parent(parent);
  *request.mutable_index() = index;
  return connection_->CreateIndex(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::Index>>
IndexServiceClient::CreateIndex(
    google::cloud::aiplatform::v1::CreateIndexRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateIndex(request);
}

StatusOr<google::longrunning::Operation> IndexServiceClient::CreateIndex(
    NoAwaitTag,
    google::cloud::aiplatform::v1::CreateIndexRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateIndex(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::Index>>
IndexServiceClient::CreateIndex(google::longrunning::Operation const& operation,
                                Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateIndex(operation);
}

StatusOr<google::cloud::aiplatform::v1::Index> IndexServiceClient::GetIndex(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::GetIndexRequest request;
  request.set_name(name);
  return connection_->GetIndex(request);
}

StatusOr<google::cloud::aiplatform::v1::Index> IndexServiceClient::GetIndex(
    google::cloud::aiplatform::v1::GetIndexRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetIndex(request);
}

StreamRange<google::cloud::aiplatform::v1::Index>
IndexServiceClient::ListIndexes(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::ListIndexesRequest request;
  request.set_parent(parent);
  return connection_->ListIndexes(request);
}

StreamRange<google::cloud::aiplatform::v1::Index>
IndexServiceClient::ListIndexes(
    google::cloud::aiplatform::v1::ListIndexesRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListIndexes(std::move(request));
}

future<StatusOr<google::cloud::aiplatform::v1::Index>>
IndexServiceClient::UpdateIndex(
    google::cloud::aiplatform::v1::Index const& index,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::UpdateIndexRequest request;
  *request.mutable_index() = index;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateIndex(request);
}

StatusOr<google::longrunning::Operation> IndexServiceClient::UpdateIndex(
    NoAwaitTag, google::cloud::aiplatform::v1::Index const& index,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::UpdateIndexRequest request;
  *request.mutable_index() = index;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateIndex(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::Index>>
IndexServiceClient::UpdateIndex(
    google::cloud::aiplatform::v1::UpdateIndexRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateIndex(request);
}

StatusOr<google::longrunning::Operation> IndexServiceClient::UpdateIndex(
    NoAwaitTag,
    google::cloud::aiplatform::v1::UpdateIndexRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateIndex(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::Index>>
IndexServiceClient::UpdateIndex(google::longrunning::Operation const& operation,
                                Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateIndex(operation);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
IndexServiceClient::DeleteIndex(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::DeleteIndexRequest request;
  request.set_name(name);
  return connection_->DeleteIndex(request);
}

StatusOr<google::longrunning::Operation> IndexServiceClient::DeleteIndex(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::DeleteIndexRequest request;
  request.set_name(name);
  return connection_->DeleteIndex(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
IndexServiceClient::DeleteIndex(
    google::cloud::aiplatform::v1::DeleteIndexRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteIndex(request);
}

StatusOr<google::longrunning::Operation> IndexServiceClient::DeleteIndex(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeleteIndexRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteIndex(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
IndexServiceClient::DeleteIndex(google::longrunning::Operation const& operation,
                                Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteIndex(operation);
}

StatusOr<google::cloud::aiplatform::v1::UpsertDatapointsResponse>
IndexServiceClient::UpsertDatapoints(
    google::cloud::aiplatform::v1::UpsertDatapointsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpsertDatapoints(request);
}

StatusOr<google::cloud::aiplatform::v1::RemoveDatapointsResponse>
IndexServiceClient::RemoveDatapoints(
    google::cloud::aiplatform::v1::RemoveDatapointsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RemoveDatapoints(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1
}  // namespace cloud
}  // namespace google
