/* 
 * This file is part of dcaenc.
 *
 * Copyright (c) 2008-2012 Alexander E. Patrakov <patrakov@gmail.com>
 *
 * dcaenc is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * dcaenc is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with dcaenc; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef FLOAT_DATA_H
#define FLOAT_DATA_H

/*
 *  Official tables taken from:
 *  ETSI TS 102 114 V1.2.1
 *
 *  Copyright (C)  European Telecommunications Standards Institute 2002.
 *  Copyright (C) European Broadcasting Union 2002.
 *  All rights reserved.
 */

/* D.9.1 64x interpolation
 * The 128x LFE interpolation FIR is the same, scaled up by a factor of 2.
 */
static const double lfe_fir_64[] =
{
	2.6584343868307770E-004,
	8.1793652498163280E-005,
	9.4393239123746760E-005,
	1.0821702744578940E-004,
	1.2333714403212070E-004,
	1.3974857574794440E-004,
	1.5759580128360540E-004,
	1.7699223826639360E-004,
	1.9817386055365200E-004,
	2.2118473134469240E-004,
	2.4602311896160240E-004,
	2.7261159266345200E-004,
	3.0138631700538100E-004,
	3.3283955417573450E-004,
	3.6589911906048660E-004,
	4.0182814700528980E-004,
	4.4018754852004350E-004,
	4.8127761692740020E-004,
	5.2524596685543660E-004,
	5.7215924607589840E-004,
	6.2221300322562460E-004,
	6.7555153509601950E-004,
	7.3241489008069040E-004,
	7.9285167157649990E-004,
	8.5701106581836940E-004,
	9.2511920956894760E-004,
	9.9747709464281800E-004,
	1.0739302961155770E-003,
	1.1550235794857140E-003,
	1.2406768510118130E-003,
	1.3312589144334200E-003,
	1.4268938684836030E-003,
	1.5278297942131760E-003,
	1.6342115122824910E-003,
	1.7463274998590350E-003,
	1.8643775256350640E-003,
	1.9886041991412640E-003,
	2.1191518753767010E-003,
	2.2563596721738580E-003,
	2.4004334118217230E-003,
	2.5515670422464610E-003,
	2.7100932784378530E-003,
	2.8761904686689380E-003,
	3.0501529108732940E-003,
	3.2322725746780640E-003,
	3.4227769356220960E-003,
	3.6219672765582800E-003,
	3.8300913292914630E-003,
	4.0474990382790560E-003,
	4.2744171805679800E-003,
	4.5111598446965220E-003,
	4.7580120153725150E-003,
	5.0153112970292570E-003,
	5.2832840010523800E-003,
	5.5623454973101620E-003,
	5.8526843786239620E-003,
	6.1547122895717620E-003,
	6.4686913974583150E-003,
	6.7949919030070300E-003,
	7.1338820271193980E-003,
	7.4857366271317010E-003,
	7.8508658334612850E-003,
	8.2296309992671010E-003,
	8.6223213002085690E-003,
	9.0293306857347480E-003,
	9.4509534537792200E-003,
	9.8875602707266800E-003,
	1.0339494794607160E-002,
	1.0807084850966930E-002,
	1.1290682479739190E-002,
	1.1790650896728040E-002,
	1.2307321652770040E-002,
	1.2841059826314450E-002,
	1.3392185792326930E-002,
	1.3961089774966240E-002,
	1.4548087492585180E-002,
	1.5153550542891020E-002,
	1.5777811408042910E-002,
	1.6421230509877200E-002,
	1.7084129154682160E-002,
	1.7766902223229410E-002,
	1.8469827249646190E-002,
	1.9193304702639580E-002,
	1.9937623292207720E-002,
	2.0703161135315900E-002,
	2.1490212529897690E-002,
	2.2299138829112050E-002,
	2.3130238056182860E-002,
	2.3983856663107870E-002,
	2.4860285222530360E-002,
	2.5759860873222350E-002,
	2.6682861149311060E-002,
	2.7629608288407320E-002,
	2.8600392863154410E-002,
	2.9595496132969860E-002,
	3.0615204945206640E-002,
	3.1659796833992000E-002,
	3.2729536294937140E-002,
	3.3824689686298370E-002,
	3.4945506602525710E-002,
	3.6092240363359450E-002,
	3.7265110760927200E-002,
	3.8464374840259550E-002,
	3.9690230041742320E-002,
	4.0942888706922530E-002,
	4.2222552001476290E-002,
	4.3529424816370010E-002,
	4.4863656163215640E-002,
	4.6225443482398990E-002,
	4.7614917159080510E-002,
	4.9032241106033330E-002,
	5.0477534532547000E-002,
	5.1950931549072270E-002,
	5.3452525287866590E-002,
	5.4982420057058330E-002,
	5.6540694087743760E-002,
	5.8127421885728840E-002,
	5.9742655605077740E-002,
	6.1386436223983760E-002,
	6.3058786094188690E-002,
	6.4759708940982820E-002,
	6.6489234566688540E-002,
	6.8247318267822270E-002,
	7.0033922791481020E-002,
	7.1849010884761810E-002,
	7.3692522943019870E-002,
	7.5564362108707430E-002,
	7.7464438974857330E-002,
	7.9392634332180020E-002,
	8.1348828971385960E-002,
	8.3332858979702000E-002,
	8.5344567894935610E-002,
	8.7383769452571870E-002,
	8.9450262486934660E-002,
	9.1543838381767280E-002,
	9.3664251267910000E-002,
	9.5811240375041960E-002,
	9.7984537482261660E-002,
	1.0018386691808700E-001,
	1.0240890830755230E-001,
	1.0465932637453080E-001,
	1.0693479329347610E-001,
	1.0923493653535840E-001,
	1.1155936866998670E-001,
	1.1390769481658940E-001,
	1.1627949774265290E-001,
	1.1867434531450270E-001,
	1.2109176814556120E-001,
	1.2353130429983140E-001,
	1.2599244713783260E-001,
	1.2847468256950380E-001,
	1.3097748160362240E-001,
	1.3350030779838560E-001,
	1.3604259490966800E-001,
	1.3860376179218290E-001,
	1.4118319749832150E-001,
	1.4378026127815250E-001,
	1.4639437198638920E-001,
	1.4902481436729430E-001,
	1.5167096257209780E-001,
	1.5433208644390100E-001,
	1.5700751543045040E-001,
	1.5969651937484740E-001,
	1.6239835321903230E-001,
	1.6511227190494540E-001,
	1.6783750057220460E-001,
	1.7057323455810550E-001,
	1.7331869900226590E-001,
	1.7607308924198150E-001,
	1.7883554100990300E-001,
	1.8160524964332580E-001,
	1.8438133597373960E-001,
	1.8716295063495640E-001,
	1.8994916975498200E-001,
	1.9273911416530610E-001,
	1.9553191959857940E-001,
	1.9832661747932440E-001,
	2.0112232863903040E-001,
	2.0391805469989780E-001,
	2.0671287178993220E-001,
	2.0950584113597870E-001,
	2.1229594945907590E-001,
	2.1508227288722990E-001,
	2.1786379814147950E-001,
	2.2063951194286350E-001,
	2.2340846061706540E-001,
	2.2616961598396300E-001,
	2.2892196476459500E-001,
	2.3166447877883910E-001,
	2.3439615964889520E-001,
	2.3711597919464110E-001,
	2.3982289433479310E-001,
	2.4251587688922880E-001,
	2.4519388377666480E-001,
	2.4785590171813960E-001,
	2.5050088763237000E-001,
	2.5312781333923340E-001,
	2.5573557615280150E-001,
	2.5832322239875800E-001,
	2.6088967919349670E-001,
	2.6343390345573420E-001,
	2.6595494151115420E-001,
	2.6845166087150580E-001,
	2.7092313766479490E-001,
	2.7336826920509340E-001,
	2.7578607201576240E-001,
	2.7817553281784060E-001,
	2.8053569793701170E-001,
	2.8286558389663700E-001,
	2.8516408801078800E-001,
	2.8743034601211550E-001,
	2.8966337442398070E-001,
	2.9186218976974480E-001,
	2.9402589797973640E-001,
	2.9615348577499390E-001,
	2.9824411869049070E-001,
	3.0029675364494320E-001,
	3.0231067538261420E-001,
	3.0428490042686460E-001,
	3.0621853470802300E-001,
	3.0811080336570740E-001,
	3.0996081233024600E-001,
	3.1176769733428960E-001,
	3.1353080272674560E-001,
	3.1524917483329780E-001,
	3.1692212820053100E-001,
	3.1854888796806340E-001,
	3.2012873888015740E-001,
	3.2166096568107600E-001,
	3.2314485311508180E-001,
	3.2457971572875980E-001,
	3.2596495747566220E-001,
	3.2729989290237420E-001,
	3.2858389616012580E-001,
	3.2981643080711360E-001,
	3.3099696040153500E-001,
	3.3212485909461980E-001,
	3.3319962024688720E-001,
	3.3422079682350160E-001,
	3.3518791198730470E-001,
	3.3610042929649360E-001,
	3.3695802092552180E-001,
	3.3776029944419860E-001,
	3.3850681781768800E-001,
	3.3919724822044380E-001,
	3.3983129262924200E-001,
	3.4040865302085880E-001,
	3.4092903137207030E-001,
	3.4139221906661980E-001,
	3.4179797768592840E-001,
	3.4214612841606140E-001,
	3.4243649244308470E-001,
	3.4266895055770880E-001,
	3.4284341335296630E-001,
	3.4295973181724550E-001,
	3.4301793575286860E-001,
	3.4301793575286860E-001,
	3.4295973181724550E-001,
	3.4284341335296630E-001,
	3.4266895055770880E-001,
	3.4243649244308470E-001,
	3.4214612841606140E-001,
	3.4179797768592840E-001,
	3.4139221906661980E-001,
	3.4092903137207030E-001,
	3.4040865302085880E-001,
	3.3983129262924200E-001,
	3.3919724822044380E-001,
	3.3850681781768800E-001,
	3.3776029944419860E-001,
	3.3695802092552180E-001,
	3.3610042929649360E-001,
	3.3518791198730470E-001,
	3.3422079682350160E-001,
	3.3319962024688720E-001,
	3.3212485909461980E-001,
	3.3099696040153500E-001,
	3.2981643080711360E-001,
	3.2858389616012580E-001,
	3.2729989290237420E-001,
	3.2596495747566220E-001,
	3.2457971572875980E-001,
	3.2314485311508180E-001,
	3.2166096568107600E-001,
	3.2012873888015740E-001,
	3.1854888796806340E-001,
	3.1692212820053100E-001,
	3.1524917483329780E-001,
	3.1353080272674560E-001,
	3.1176769733428960E-001,
	3.0996081233024600E-001,
	3.0811080336570740E-001,
	3.0621853470802300E-001,
	3.0428490042686460E-001,
	3.0231067538261420E-001,
	3.0029675364494320E-001,
	2.9824411869049070E-001,
	2.9615348577499390E-001,
	2.9402589797973640E-001,
	2.9186218976974480E-001,
	2.8966337442398070E-001,
	2.8743034601211550E-001,
	2.8516408801078800E-001,
	2.8286558389663700E-001,
	2.8053569793701170E-001,
	2.7817553281784060E-001,
	2.7578607201576240E-001,
	2.7336826920509340E-001,
	2.7092313766479490E-001,
	2.6845166087150580E-001,
	2.6595494151115420E-001,
	2.6343390345573420E-001,
	2.6088967919349670E-001,
	2.5832322239875800E-001,
	2.5573557615280150E-001,
	2.5312781333923340E-001,
	2.5050088763237000E-001,
	2.4785590171813960E-001,
	2.4519388377666480E-001,
	2.4251587688922880E-001,
	2.3982289433479310E-001,
	2.3711597919464110E-001,
	2.3439615964889520E-001,
	2.3166447877883910E-001,
	2.2892196476459500E-001,
	2.2616961598396300E-001,
	2.2340846061706540E-001,
	2.2063951194286350E-001,
	2.1786379814147950E-001,
	2.1508227288722990E-001,
	2.1229594945907590E-001,
	2.0950584113597870E-001,
	2.0671287178993220E-001,
	2.0391805469989780E-001,
	2.0112232863903040E-001,
	1.9832661747932440E-001,
	1.9553191959857940E-001,
	1.9273911416530610E-001,
	1.8994916975498200E-001,
	1.8716295063495640E-001,
	1.8438133597373960E-001,
	1.8160524964332580E-001,
	1.7883554100990300E-001,
	1.7607308924198150E-001,
	1.7331869900226590E-001,
	1.7057323455810550E-001,
	1.6783750057220460E-001,
	1.6511227190494540E-001,
	1.6239835321903230E-001,
	1.5969651937484740E-001,
	1.5700751543045040E-001,
	1.5433208644390100E-001,
	1.5167096257209780E-001,
	1.4902481436729430E-001,
	1.4639437198638920E-001,
	1.4378026127815250E-001,
	1.4118319749832150E-001,
	1.3860376179218290E-001,
	1.3604259490966800E-001,
	1.3350030779838560E-001,
	1.3097748160362240E-001,
	1.2847468256950380E-001,
	1.2599244713783260E-001,
	1.2353130429983140E-001,
	1.2109176814556120E-001,
	1.1867434531450270E-001,
	1.1627949774265290E-001,
	1.1390769481658940E-001,
	1.1155936866998670E-001,
	1.0923493653535840E-001,
	1.0693479329347610E-001,
	1.0465932637453080E-001,
	1.0240890830755230E-001,
	1.0018386691808700E-001,
	9.7984537482261660E-002,
	9.5811240375041960E-002,
	9.3664251267910000E-002,
	9.1543838381767280E-002,
	8.9450262486934660E-002,
	8.7383769452571870E-002,
	8.5344567894935610E-002,
	8.3332858979702000E-002,
	8.1348828971385960E-002,
	7.9392634332180020E-002,
	7.7464438974857330E-002,
	7.5564362108707430E-002,
	7.3692522943019870E-002,
	7.1849010884761810E-002,
	7.0033922791481020E-002,
	6.8247318267822270E-002,
	6.6489234566688540E-002,
	6.4759708940982820E-002,
	6.3058786094188690E-002,
	6.1386436223983760E-002,
	5.9742655605077740E-002,
	5.8127421885728840E-002,
	5.6540694087743760E-002,
	5.4982420057058330E-002,
	5.3452525287866590E-002,
	5.1950931549072270E-002,
	5.0477534532547000E-002,
	4.9032241106033330E-002,
	4.7614917159080510E-002,
	4.6225443482398990E-002,
	4.4863656163215640E-002,
	4.3529424816370010E-002,
	4.2222552001476290E-002,
	4.0942888706922530E-002,
	3.9690230041742320E-002,
	3.8464374840259550E-002,
	3.7265110760927200E-002,
	3.6092240363359450E-002,
	3.4945506602525710E-002,
	3.3824689686298370E-002,
	3.2729536294937140E-002,
	3.1659796833992000E-002,
	3.0615204945206640E-002,
	2.9595496132969860E-002,
	2.8600392863154410E-002,
	2.7629608288407320E-002,
	2.6682861149311060E-002,
	2.5759860873222350E-002,
	2.4860285222530360E-002,
	2.3983856663107870E-002,
	2.3130238056182860E-002,
	2.2299138829112050E-002,
	2.1490212529897690E-002,
	2.0703161135315900E-002,
	1.9937623292207720E-002,
	1.9193304702639580E-002,
	1.8469827249646190E-002,
	1.7766902223229410E-002,
	1.7084129154682160E-002,
	1.6421230509877200E-002,
	1.5777811408042910E-002,
	1.5153550542891020E-002,
	1.4548087492585180E-002,
	1.3961089774966240E-002,
	1.3392185792326930E-002,
	1.2841059826314450E-002,
	1.2307321652770040E-002,
	1.1790650896728040E-002,
	1.1290682479739190E-002,
	1.0807084850966930E-002,
	1.0339494794607160E-002,
	9.8875602707266800E-003,
	9.4509534537792200E-003,
	9.0293306857347480E-003,
	8.6223213002085690E-003,
	8.2296309992671010E-003,
	7.8508658334612850E-003,
	7.4857366271317010E-003,
	7.1338820271193980E-003,
	6.7949919030070300E-003,
	6.4686913974583150E-003,
	6.1547122895717620E-003,
	5.8526843786239620E-003,
	5.5623454973101620E-003,
	5.2832840010523800E-003,
	5.0153112970292570E-003,
	4.7580120153725150E-003,
	4.5111598446965220E-003,
	4.2744171805679800E-003,
	4.0474990382790560E-003,
	3.8300913292914630E-003,
	3.6219672765582800E-003,
	3.4227769356220960E-003,
	3.2322725746780640E-003,
	3.0501529108732940E-003,
	2.8761904686689380E-003,
	2.7100932784378530E-003,
	2.5515670422464610E-003,
	2.4004334118217230E-003,
	2.2563596721738580E-003,
	2.1191518753767010E-003,
	1.9886041991412640E-003,
	1.8643775256350640E-003,
	1.7463274998590350E-003,
	1.6342115122824910E-003,
	1.5278297942131760E-003,
	1.4268938684836030E-003,
	1.3312589144334200E-003,
	1.2406768510118130E-003,
	1.1550235794857140E-003,
	1.0739302961155770E-003,
	9.9747709464281800E-004,
	9.2511920956894760E-004,
	8.5701106581836940E-004,
	7.9285167157649990E-004,
	7.3241489008069040E-004,
	6.7555153509601950E-004,
	6.2221300322562460E-004,
	5.7215924607589840E-004,
	5.2524596685543660E-004,
	4.8127761692740020E-004,
	4.4018754852004350E-004,
	4.0182814700528980E-004,
	3.6589911906048660E-004,
	3.3283955417573450E-004,
	3.0138631700538100E-004,
	2.7261159266345200E-004,
	2.4602311896160240E-004,
	2.2118473134469240E-004,
	1.9817386055365200E-004,
	1.7699223826639360E-004,
	1.5759580128360540E-004,
	1.3974857574794440E-004,
	1.2333714403212070E-004,
	1.0821702744578940E-004,
	9.4393239123746760E-005,
	8.1793652498163280E-005,
	2.6584343868307770E-004
};

/*
 * D.8 32-Band Interpolation FIR
 *
 * To be used with the "official" interpolation procedure,
 * which is deliberately obfuscated in the specification.
 *
 * reconstruction_fir[0][] = D.8.1 Perfect Reconstruction
 * reconstruction_fir[1][] = D.8.2 Non-Perfect Reconstruction
*/

static const double reconstruction_fir[2][512] = {
{
	+1.135985195E-010,
	+7.018770981E-011,
	-1.608403011E-008,
	-5.083275667E-008,
	-1.543309907E-007,
	-3.961981463E-007,
	-7.342250683E-007,
	-3.970030775E-007,
	-4.741137047E-007,
	-6.022448247E-007,
	-6.628192182E-007,
	-6.982898526E-007,
	-7.020648809E-007,
	-6.767839409E-007,
	-6.262345096E-007,
	-5.564140224E-007,
	+7.003467317E-007,
	+8.419976893E-007,
	+9.742954035E-007,
	+1.085227950E-006,
	+1.162929266E-006,
	+1.194632091E-006,
	+1.179182050E-006,
	+1.033426656E-006,
	+9.451737242E-007,
	+1.975324267E-006,
	+1.190443072E-006,
	+5.234479659E-007,
	+2.014677420E-007,
	+7.834767501E-008,
	-6.702406963E-010,
	-1.613285505E-009,
	-2.682709610E-009,
	-3.399493131E-009,
	+1.314406006E-008,
	+7.506701927E-009,
	+2.788728892E-008,
	+1.444918922E-007,
	+3.132386439E-007,
	+1.399798180E-006,
	+2.032118118E-006,
	+2.715013807E-006,
	+3.453840463E-006,
	+4.195037945E-006,
	+4.896494374E-006,
	+5.516381407E-006,
	+6.015239251E-006,
	+6.361419310E-006,
	+8.006985809E-006,
	+8.087732567E-006,
	+7.941360309E-006,
	+7.568834008E-006,
	+6.986399967E-006,
	+6.225028756E-006,
	+5.315936960E-006,
	+4.429412002E-006,
	+3.332600045E-006,
	+8.427224429E-007,
	+4.341498823E-007,
	+9.458596395E-008,
	+2.975164826E-008,
	+6.402664354E-008,
	-3.246264413E-008,
	-3.809887872E-008,
	+8.434094667E-008,
	+6.437721822E-008,
	+1.189317118E-006,
	+2.497214155E-006,
	+3.617151151E-006,
	+3.157242645E-006,
	+2.319611212E-006,
	+7.869333785E-006,
	+9.826449968E-006,
	+1.177108606E-005,
	+1.379448349E-005,
	+1.571428584E-005,
	+1.743183020E-005,
	+1.884208177E-005,
	+1.987093310E-005,
	+2.042970118E-005,
	-3.144468428E-005,
	-3.334947178E-005,
	-3.460439257E-005,
	-3.515914432E-005,
	-3.495384954E-005,
	-3.397853652E-005,
	-3.225446198E-005,
	-2.978993689E-005,
	-2.677291741E-005,
	-1.806914770E-005,
	-1.776598037E-005,
	-1.661818715E-005,
	-1.207003334E-005,
	-6.993315310E-006,
	-5.633860383E-007,
	-9.984935332E-007,
	-1.470520488E-006,
	-1.853591357E-006,
	+7.198007665E-007,
	+3.086857760E-006,
	+6.084746474E-006,
	+9.561075785E-006,
	+1.309637537E-005,
	+2.263354872E-005,
	+2.847247197E-005,
	+3.415624451E-005,
	+3.946387005E-005,
	+4.425736552E-005,
	+4.839275425E-005,
	+5.176846025E-005,
	+5.429694284E-005,
	+5.595519906E-005,
	+4.916387297E-006,
	+9.299508747E-006,
	+1.356193479E-005,
	+1.751866148E-005,
	+2.093936746E-005,
	+2.362549276E-005,
	+2.537086584E-005,
	+2.618136386E-005,
	+2.554462844E-005,
	+3.018750249E-005,
	+2.570833203E-005,
	+1.985177369E-005,
	+1.191342653E-005,
	+2.525620175E-006,
	-1.521241393E-005,
	-1.617751332E-005,
	+1.992636317E-005,
	+1.774702469E-005,
	+4.624524081E-005,
	+5.610509834E-005,
	+6.568001118E-005,
	+7.513730816E-005,
	+8.413690375E-005,
	+8.757545584E-005,
	+9.517164290E-005,
	+1.020687996E-004,
	+1.084438481E-004,
	+1.140582463E-004,
	+1.187910311E-004,
	+1.224978914E-004,
	+1.250260248E-004,
	+1.262027217E-004,
	+1.226499153E-004,
	+1.213575742E-004,
	+1.180980107E-004,
	+1.126275165E-004,
	+1.047207043E-004,
	+9.417100227E-005,
	+8.078388782E-005,
	+6.447290798E-005,
	+4.491530854E-005,
	+2.470704203E-005,
	-1.714242217E-006,
	-3.193307566E-005,
	-6.541742187E-005,
	-1.024175072E-004,
	-1.312203676E-004,
	-1.774113771E-004,
	-2.233728592E-004,
	-2.682086197E-004,
	-3.347633174E-004,
	-3.906481725E-004,
	-4.490280990E-004,
	-5.099929986E-004,
	-5.729619297E-004,
	-6.358824321E-004,
	-7.021900383E-004,
	-7.698345580E-004,
	-8.385353722E-004,
	-9.078957955E-004,
	-9.775133803E-004,
	-1.046945457E-003,
	-1.115717343E-003,
	-1.183370827E-003,
	-1.252829796E-003,
	-1.316190348E-003,
	-1.376571832E-003,
	-1.433344092E-003,
	-1.485876855E-003,
	-1.533520175E-003,
	-1.575609902E-003,
	-1.611457788E-003,
	-1.640390139E-003,
	-1.661288203E-003,
	-1.674512983E-003,
	-1.678415807E-003,
	-1.672798418E-003,
	-1.656501088E-003,
	-1.633993932E-003,
	-1.593449386E-003,
	+1.542080659E-003,
	+1.479332102E-003,
	+1.395521569E-003,
	+1.303116791E-003,
	+1.196175464E-003,
	+1.073757303E-003,
	+9.358961834E-004,
	+7.817269652E-004,
	+6.114174030E-004,
	+4.244441516E-004,
	+2.206075296E-004,
	-2.719412748E-007,
	-2.382978710E-004,
	-4.935106263E-004,
	-7.658848190E-004,
	-1.055365428E-003,
	-1.361547387E-003,
	-1.684492454E-003,
	-2.023874084E-003,
	-2.379294252E-003,
	-2.750317100E-003,
	-3.136433195E-003,
	-3.537061159E-003,
	-3.951539751E-003,
	-4.379155114E-003,
	-4.819062538E-003,
	-5.270531867E-003,
	-5.732392892E-003,
	-6.203945260E-003,
	-6.683901884E-003,
	-7.170005701E-003,
	-7.664063945E-003,
	-8.162760176E-003,
	-8.665001951E-003,
	-9.170533158E-003,
	-9.676489048E-003,
	-1.018219907E-002,
	-1.068630442E-002,
	-1.118756086E-002,
	-1.168460958E-002,
	-1.217562053E-002,
	-1.265939046E-002,
	-1.313448418E-002,
	-1.359948888E-002,
	-1.405300573E-002,
	-1.449365262E-002,
	-1.492007636E-002,
	-1.533095632E-002,
	-1.572482102E-002,
	-1.610082202E-002,
	-1.645756140E-002,
	-1.679391414E-002,
	-1.710879989E-002,
	-1.740120351E-002,
	-1.767017506E-002,
	-1.791484281E-002,
	-1.813439466E-002,
	-1.832821220E-002,
	-1.849545911E-002,
	-1.863567345E-002,
	-1.874836907E-002,
	-1.883326657E-002,
	-1.889026538E-002,
	-1.891860925E-002,
	+1.891860925E-002,
	+1.889026538E-002,
	+1.883326657E-002,
	+1.874836907E-002,
	+1.863567345E-002,
	+1.849545911E-002,
	+1.832821220E-002,
	+1.813439466E-002,
	+1.791484281E-002,
	+1.767017506E-002,
	+1.740120351E-002,
	+1.710879989E-002,
	+1.679391414E-002,
	+1.645756140E-002,
	+1.610082202E-002,
	+1.572482102E-002,
	+1.533095632E-002,
	+1.492007636E-002,
	+1.449365262E-002,
	+1.405300573E-002,
	+1.359948888E-002,
	+1.313448418E-002,
	+1.265939046E-002,
	+1.217562053E-002,
	+1.168460958E-002,
	+1.118756086E-002,
	+1.068630442E-002,
	+1.018219907E-002,
	+9.676489048E-003,
	+9.170533158E-003,
	+8.665001951E-003,
	+8.162760176E-003,
	+7.664063945E-003,
	+7.170005701E-003,
	+6.683901884E-003,
	+6.203945260E-003,
	+5.732392892E-003,
	+5.270531867E-003,
	+4.819062538E-003,
	+4.379155114E-003,
	+3.951539751E-003,
	+3.537061159E-003,
	+3.136433195E-003,
	+2.750317100E-003,
	+2.379294252E-003,
	+2.023874084E-003,
	+1.684492454E-003,
	+1.361547387E-003,
	+1.055365428E-003,
	+7.658848190E-004,
	+4.935106263E-004,
	+2.382978710E-004,
	+2.719412748E-007,
	-2.206075296E-004,
	-4.244441516E-004,
	-6.114174030E-004,
	-7.817269652E-004,
	-9.358961834E-004,
	-1.073757303E-003,
	-1.196175464E-003,
	-1.303116791E-003,
	-1.395521569E-003,
	-1.479332102E-003,
	-1.542080659E-003,
	+1.593449386E-003,
	+1.633993932E-003,
	+1.656501088E-003,
	+1.672798418E-003,
	+1.678415807E-003,
	+1.674512983E-003,
	+1.661288203E-003,
	+1.640390139E-003,
	+1.611457788E-003,
	+1.575609902E-003,
	+1.533520175E-003,
	+1.485876855E-003,
	+1.433344092E-003,
	+1.376571832E-003,
	+1.316190348E-003,
	+1.252829796E-003,
	+1.183370827E-003,
	+1.115717343E-003,
	+1.046945457E-003,
	+9.775133803E-004,
	+9.078957955E-004,
	+8.385353722E-004,
	+7.698345580E-004,
	+7.021900383E-004,
	+6.358824321E-004,
	+5.729619297E-004,
	+5.099929986E-004,
	+4.490280990E-004,
	+3.906481725E-004,
	+3.347633174E-004,
	+2.682086197E-004,
	+2.233728592E-004,
	+1.774113771E-004,
	+1.312203676E-004,
	+1.024175072E-004,
	+6.541742187E-005,
	+3.193307566E-005,
	+1.714242217E-006,
	-2.470704203E-005,
	-4.491530854E-005,
	-6.447290798E-005,
	-8.078388782E-005,
	-9.417100227E-005,
	-1.047207043E-004,
	-1.126275165E-004,
	-1.180980107E-004,
	-1.213575742E-004,
	-1.226499153E-004,
	-1.262027217E-004,
	-1.250260248E-004,
	-1.224978914E-004,
	-1.187910311E-004,
	-1.140582463E-004,
	-1.084438481E-004,
	-1.020687996E-004,
	-9.517164290E-005,
	-8.757545584E-005,
	-8.413690375E-005,
	-7.513730816E-005,
	-6.568001118E-005,
	-5.610509834E-005,
	-4.624524081E-005,
	-1.774702469E-005,
	-1.992636317E-005,
	+1.617751332E-005,
	+1.521241393E-005,
	-2.525620175E-006,
	-1.191342653E-005,
	-1.985177369E-005,
	-2.570833203E-005,
	-3.018750249E-005,
	-2.554462844E-005,
	-2.618136386E-005,
	-2.537086584E-005,
	-2.362549276E-005,
	-2.093936746E-005,
	-1.751866148E-005,
	-1.356193479E-005,
	-9.299508747E-006,
	-4.916387297E-006,
	-5.595519906E-005,
	-5.429694284E-005,
	-5.176846025E-005,
	-4.839275425E-005,
	-4.425736552E-005,
	-3.946387005E-005,
	-3.415624451E-005,
	-2.847247197E-005,
	-2.263354872E-005,
	-1.309637537E-005,
	-9.561075785E-006,
	-6.084746474E-006,
	-3.086857760E-006,
	-7.198007665E-007,
	+1.853591357E-006,
	+1.470520488E-006,
	+9.984935332E-007,
	+5.633860383E-007,
	+6.993315310E-006,
	+1.207003334E-005,
	+1.661818715E-005,
	+1.776598037E-005,
	+1.806914770E-005,
	+2.677291741E-005,
	+2.978993689E-005,
	+3.225446198E-005,
	+3.397853652E-005,
	+3.495384954E-005,
	+3.515914432E-005,
	+3.460439257E-005,
	+3.334947178E-005,
	+3.144468428E-005,
	-2.042970118E-005,
	-1.987093310E-005,
	-1.884208177E-005,
	-1.743183020E-005,
	-1.571428584E-005,
	-1.379448349E-005,
	-1.177108606E-005,
	-9.826449968E-006,
	-7.869333785E-006,
	-2.319611212E-006,
	-3.157242645E-006,
	-3.617151151E-006,
	-2.497214155E-006,
	-1.189317118E-006,
	-6.437721822E-008,
	-8.434094667E-008,
	+3.809887872E-008,
	+3.246264413E-008,
	-6.402664354E-008,
	-2.975164826E-008,
	-9.458596395E-008,
	-4.341498823E-007,
	-8.427224429E-007,
	-3.332600045E-006,
	-4.429412002E-006,
	-5.315936960E-006,
	-6.225028756E-006,
	-6.986399967E-006,
	-7.568834008E-006,
	-7.941360309E-006,
	-8.087732567E-006,
	-8.006985809E-006,
	-6.361419310E-006,
	-6.015239251E-006,
	-5.516381407E-006,
	-4.896494374E-006,
	-4.195037945E-006,
	-3.453840463E-006,
	-2.715013807E-006,
	-2.032118118E-006,
	-1.399798180E-006,
	-3.132386439E-007,
	-1.444918922E-007,
	-2.788728892E-008,
	-7.506701927E-009,
	-1.314406006E-008,
	+3.399493131E-009,
	+2.682709610E-009,
	+1.613285505E-009,
	+6.702406963E-010,
	-7.834767501E-008,
	-2.014677420E-007,
	-5.234479659E-007,
	-1.190443072E-006,
	-1.975324267E-006,
	-9.451737242E-007,
	-1.033426656E-006,
	-1.179182050E-006,
	-1.194632091E-006,
	-1.162929266E-006,
	-1.085227950E-006,
	-9.742954035E-007,
	-8.419976893E-007,
	-7.003467317E-007,
	+5.564140224E-007,
	+6.262345096E-007,
	+6.767839409E-007,
	+7.020648809E-007,
	+6.982898526E-007,
	+6.628192182E-007,
	+6.022448247E-007,
	+4.741137047E-007,
	+3.970030775E-007,
	+7.342250683E-007,
	+3.961981463E-007,
	+1.543309907E-007,
	+5.083275667E-008,
	+1.608403011E-008,
	-7.018770981E-011,
	-1.135985195E-010,
},
{
	-1.390191784E-007,
	-1.693738625E-007,
	-2.030677564E-007,
	-2.404238444E-007,
	-2.818143514E-007,
	-3.276689142E-007,
	-3.784752209E-007,
	-4.347855338E-007,
	-4.972276315E-007,
	-5.665120852E-007,
	-6.434325428E-007,
	-7.288739425E-007,
	-8.238164355E-007,
	-9.293416952E-007,
	-1.046637067E-006,
	-1.176999604E-006,
	-1.321840614E-006,
	-1.482681114E-006,
	-1.661159786E-006,
	-1.859034001E-006,
	-2.078171747E-006,
	-2.320550948E-006,
	-2.588257530E-006,
	-2.883470643E-006,
	-3.208459020E-006,
	-3.565570978E-006,
	-3.957220997E-006,
	-4.385879038E-006,
	-4.854050530E-006,
	-5.364252502E-006,
	-5.918994248E-006,
	-6.520755960E-006,
	-7.171964626E-006,
	-7.874960829E-006,
	-8.631964192E-006,
	-9.445050637E-006,
	-1.031611009E-005,
	-1.124680875E-005,
	-1.223855270E-005,
	-1.329243969E-005,
	-1.440921824E-005,
	-1.558924305E-005,
	-1.683242772E-005,
	-1.813820381E-005,
	-1.950545993E-005,
	-2.093250441E-005,
	-2.241701623E-005,
	-2.395598858E-005,
	-2.554569073E-005,
	-2.718161704E-005,
	-2.885844333E-005,
	-3.056998685E-005,
	-3.230916263E-005,
	-3.406793985E-005,
	-3.583733633E-005,
	-3.760734762E-005,
	-3.936696885E-005,
	-4.110412556E-005,
	-4.280570283E-005,
	-4.445751256E-005,
	-4.604430433E-005,
	-4.754976908E-005,
	-4.895655002E-005,
	-5.024627535E-005,
	+5.139957648E-005,
	+5.239612074E-005,
	+5.321469871E-005,
	+5.383323878E-005,
	+5.422891263E-005,
	+5.437819709E-005,
	+5.425697600E-005,
	+5.384063843E-005,
	+5.310418419E-005,
	+5.202236207E-005,
	+5.056979353E-005,
	+4.872112549E-005,
	+4.645117951E-005,
	+4.373511547E-005,
	+4.054862075E-005,
	+3.686808850E-005,
	+3.267079956E-005,
	+2.793515523E-005,
	+2.264085742E-005,
	+1.676913780E-005,
	+1.030297699E-005,
	+3.227306706E-006,
	-4.470633485E-006,
	-1.280130618E-005,
	-2.177240640E-005,
	-3.138873581E-005,
	-4.165195787E-005,
	-5.256036457E-005,
	-6.410864444E-005,
	-7.628766616E-005,
	-8.908427117E-005,
	-1.024810626E-004,
	-1.164562127E-004,
	-1.309833024E-004,
	-1.460311323E-004,
	-1.615635992E-004,
	-1.775395358E-004,
	-1.939126523E-004,
	-2.106313768E-004,
	-2.276388550E-004,
	-2.448728774E-004,
	-2.622658503E-004,
	-2.797449124E-004,
	-2.972317743E-004,
	-3.146430245E-004,
	-3.318900708E-004,
	-3.488793736E-004,
	-3.655125911E-004,
	-3.816867538E-004,
	-3.972945851E-004,
	-4.122247046E-004,
	-4.263620067E-004,
	-4.395879805E-004,
	-4.517810594E-004,
	-4.628172028E-004,
	-4.725702747E-004,
	-4.809123348E-004,
	-4.877146275E-004,
	-4.928477574E-004,
	-4.961824161E-004,
	-4.975944757E-004,
	-4.969481961E-004,
	-4.941228544E-004,
	-4.889960401E-004,
	+4.814492422E-004,
	+4.713678791E-004,
	+4.586426076E-004,
	+4.431701091E-004,
	+4.248536134E-004,
	+4.036037717E-004,
	+3.793396754E-004,
	+3.519894381E-004,
	+3.214911267E-004,
	+2.877934603E-004,
	+2.508567995E-004,
	+2.106537577E-004,
	+1.671699720E-004,
	+1.204049113E-004,
	+7.037253090E-005,
	+1.710198012E-005,
	-3.936182839E-005,
	-9.895755647E-005,
	-1.616069785E-004,
	-2.272142592E-004,
	-2.956659591E-004,
	-3.668301215E-004,
	-4.405563814E-004,
	-5.166754709E-004,
	-5.949990009E-004,
	-6.753197522E-004,
	-7.574109477E-004,
	-8.410271257E-004,
	-9.259034996E-004,
	-1.011756598E-003,
	-1.098284614E-003,
	-1.185167348E-003,
	-1.272067428E-003,
	-1.358630019E-003,
	-1.444484224E-003,
	-1.529243193E-003,
	-1.612505526E-003,
	-1.693855622E-003,
	-1.772865304E-003,
	-1.849094522E-003,
	-1.922092517E-003,
	-1.991399564E-003,
	-2.056547208E-003,
	-2.117061289E-003,
	-2.172462177E-003,
	-2.222266514E-003,
	-2.265989315E-003,
	-2.303145360E-003,
	-2.333251061E-003,
	-2.355825622E-003,
	-2.370394068E-003,
	-2.376487479E-003,
	-2.373647178E-003,
	-2.361423569E-003,
	-2.339380793E-003,
	-2.307097195E-003,
	-2.264167881E-003,
	-2.210205887E-003,
	-2.144844970E-003,
	-2.067740774E-003,
	-1.978572691E-003,
	-1.877046190E-003,
	-1.762894331E-003,
	-1.635878929E-003,
	+1.495792647E-003,
	+1.342460280E-003,
	+1.175740734E-003,
	+9.955273708E-004,
	+8.017504588E-004,
	+5.943773431E-004,
	+3.734139318E-004,
	+1.389056415E-004,
	-1.090620208E-004,
	-3.703625989E-004,
	-6.448282511E-004,
	-9.322494152E-004,
	-1.232374110E-003,
	-1.544908970E-003,
	-1.869517611E-003,
	-2.205822384E-003,
	-2.553403843E-003,
	-2.911801683E-003,
	-3.280514618E-003,
	-3.659002949E-003,
	-4.046686925E-003,
	-4.442950245E-003,
	-4.847140983E-003,
	-5.258570891E-003,
	-5.676518660E-003,
	-6.100233644E-003,
	-6.528933067E-003,
	-6.961807609E-003,
	-7.398022339E-003,
	-7.836719044E-003,
	-8.277016692E-003,
	-8.718019351E-003,
	-9.158811532E-003,
	-9.598465636E-003,
	-1.003604382E-002,
	-1.047059800E-002,
	-1.090117730E-002,
	-1.132682897E-002,
	-1.174659748E-002,
	-1.215953380E-002,
	-1.256469358E-002,
	-1.296114177E-002,
	-1.334795821E-002,
	-1.372423489E-002,
	-1.408908330E-002,
	-1.444163360E-002,
	-1.478104480E-002,
	-1.510649733E-002,
	-1.541720331E-002,
	-1.571240649E-002,
	-1.599138230E-002,
	-1.625344716E-002,
	-1.649795473E-002,
	-1.672429405E-002,
	-1.693190821E-002,
	-1.712027565E-002,
	-1.728892699E-002,
	-1.743743755E-002,
	-1.756543480E-002,
	-1.767260395E-002,
	-1.775865816E-002,
	-1.782339066E-002,
	-1.786663756E-002,
	-1.788828894E-002,
	+1.788828894E-002,
	+1.786663756E-002,
	+1.782339066E-002,
	+1.775865816E-002,
	+1.767260395E-002,
	+1.756543480E-002,
	+1.743743755E-002,
	+1.728892699E-002,
	+1.712027565E-002,
	+1.693190821E-002,
	+1.672429405E-002,
	+1.649795473E-002,
	+1.625344716E-002,
	+1.599138230E-002,
	+1.571240649E-002,
	+1.541720331E-002,
	+1.510649733E-002,
	+1.478104480E-002,
	+1.444163360E-002,
	+1.408908330E-002,
	+1.372423489E-002,
	+1.334795821E-002,
	+1.296114177E-002,
	+1.256469358E-002,
	+1.215953380E-002,
	+1.174659748E-002,
	+1.132682897E-002,
	+1.090117730E-002,
	+1.047059800E-002,
	+1.003604382E-002,
	+9.598465636E-003,
	+9.158811532E-003,
	+8.718019351E-003,
	+8.277016692E-003,
	+7.836719044E-003,
	+7.398022339E-003,
	+6.961807609E-003,
	+6.528933067E-003,
	+6.100233644E-003,
	+5.676518660E-003,
	+5.258570891E-003,
	+4.847140983E-003,
	+4.442950245E-003,
	+4.046686925E-003,
	+3.659002949E-003,
	+3.280514618E-003,
	+2.911801683E-003,
	+2.553403843E-003,
	+2.205822384E-003,
	+1.869517611E-003,
	+1.544908970E-003,
	+1.232374110E-003,
	+9.322494152E-004,
	+6.448282511E-004,
	+3.703625989E-004,
	+1.090620208E-004,
	-1.389056415E-004,
	-3.734139318E-004,
	-5.943773431E-004,
	-8.017504588E-004,
	-9.955273708E-004,
	-1.175740734E-003,
	-1.342460280E-003,
	-1.495792647E-003,
	+1.635878929E-003,
	+1.762894331E-003,
	+1.877046190E-003,
	+1.978572691E-003,
	+2.067740774E-003,
	+2.144844970E-003,
	+2.210205887E-003,
	+2.264167881E-003,
	+2.307097195E-003,
	+2.339380793E-003,
	+2.361423569E-003,
	+2.373647178E-003,
	+2.376487479E-003,
	+2.370394068E-003,
	+2.355825622E-003,
	+2.333251061E-003,
	+2.303145360E-003,
	+2.265989315E-003,
	+2.222266514E-003,
	+2.172462177E-003,
	+2.117061289E-003,
	+2.056547208E-003,
	+1.991399564E-003,
	+1.922092517E-003,
	+1.849094522E-003,
	+1.772865304E-003,
	+1.693855622E-003,
	+1.612505526E-003,
	+1.529243193E-003,
	+1.444484224E-003,
	+1.358630019E-003,
	+1.272067428E-003,
	+1.185167348E-003,
	+1.098284614E-003,
	+1.011756598E-003,
	+9.259034996E-004,
	+8.410271257E-004,
	+7.574109477E-004,
	+6.753197522E-004,
	+5.949990009E-004,
	+5.166754709E-004,
	+4.405563814E-004,
	+3.668301215E-004,
	+2.956659591E-004,
	+2.272142592E-004,
	+1.616069785E-004,
	+9.895755647E-005,
	+3.936182839E-005,
	-1.710198012E-005,
	-7.037253090E-005,
	-1.204049113E-004,
	-1.671699720E-004,
	-2.106537577E-004,
	-2.508567995E-004,
	-2.877934603E-004,
	-3.214911267E-004,
	-3.519894381E-004,
	-3.793396754E-004,
	-4.036037717E-004,
	-4.248536134E-004,
	-4.431701091E-004,
	-4.586426076E-004,
	-4.713678791E-004,
	-4.814492422E-004,
	+4.889960401E-004,
	+4.941228544E-004,
	+4.969481961E-004,
	+4.975944757E-004,
	+4.961824161E-004,
	+4.928477574E-004,
	+4.877146275E-004,
	+4.809123348E-004,
	+4.725702747E-004,
	+4.628172028E-004,
	+4.517810594E-004,
	+4.395879805E-004,
	+4.263620067E-004,
	+4.122247046E-004,
	+3.972945851E-004,
	+3.816867538E-004,
	+3.655125911E-004,
	+3.488793736E-004,
	+3.318900708E-004,
	+3.146430245E-004,
	+2.972317743E-004,
	+2.797449124E-004,
	+2.622658503E-004,
	+2.448728774E-004,
	+2.276388550E-004,
	+2.106313768E-004,
	+1.939126523E-004,
	+1.775395358E-004,
	+1.615635992E-004,
	+1.460311323E-004,
	+1.309833024E-004,
	+1.164562127E-004,
	+1.024810626E-004,
	+8.908427117E-005,
	+7.628766616E-005,
	+6.410864444E-005,
	+5.256036457E-005,
	+4.165195787E-005,
	+3.138873581E-005,
	+2.177240640E-005,
	+1.280130618E-005,
	+4.470633485E-006,
	-3.227306706E-006,
	-1.030297699E-005,
	-1.676913780E-005,
	-2.264085742E-005,
	-2.793515523E-005,
	-3.267079956E-005,
	-3.686808850E-005,
	-4.054862075E-005,
	-4.373511547E-005,
	-4.645117951E-005,
	-4.872112549E-005,
	-5.056979353E-005,
	-5.202236207E-005,
	-5.310418419E-005,
	-5.384063843E-005,
	-5.425697600E-005,
	-5.437819709E-005,
	-5.422891263E-005,
	-5.383323878E-005,
	-5.321469871E-005,
	-5.239612074E-005,
	-5.139957648E-005,
	+5.024627535E-005,
	+4.895655002E-005,
	+4.754976908E-005,
	+4.604430433E-005,
	+4.445751256E-005,
	+4.280570283E-005,
	+4.110412556E-005,
	+3.936696885E-005,
	+3.760734762E-005,
	+3.583733633E-005,
	+3.406793985E-005,
	+3.230916263E-005,
	+3.056998685E-005,
	+2.885844333E-005,
	+2.718161704E-005,
	+2.554569073E-005,
	+2.395598858E-005,
	+2.241701623E-005,
	+2.093250441E-005,
	+1.950545993E-005,
	+1.813820381E-005,
	+1.683242772E-005,
	+1.558924305E-005,
	+1.440921824E-005,
	+1.329243969E-005,
	+1.223855270E-005,
	+1.124680875E-005,
	+1.031611009E-005,
	+9.445050637E-006,
	+8.631964192E-006,
	+7.874960829E-006,
	+7.171964626E-006,
	+6.520755960E-006,
	+5.918994248E-006,
	+5.364252502E-006,
	+4.854050530E-006,
	+4.385879038E-006,
	+3.957220997E-006,
	+3.565570978E-006,
	+3.208459020E-006,
	+2.883470643E-006,
	+2.588257530E-006,
	+2.320550948E-006,
	+2.078171747E-006,
	+1.859034001E-006,
	+1.661159786E-006,
	+1.482681114E-006,
	+1.321840614E-006,
	+1.176999604E-006,
	+1.046637067E-006,
	+9.293416952E-007,
	+8.238164355E-007,
	+7.288739425E-007,
	+6.434325428E-007,
	+5.665120852E-007,
	+4.972276315E-007,
	+4.347855338E-007,
	+3.784752209E-007,
	+3.276689142E-007,
	+2.818143514E-007,
	+2.404238444E-007,
	+2.030677564E-007,
	+1.693738625E-007,
	+1.390191784E-007,
}
};

#endif
