/*  $Id: tconf.c,v 1.5 2004/10/02 16:10:21 marcusva Exp $
 *  
 *  This file is part of LingoTeach, the Language Teaching program 
 *  Copyright (C) 2001-2004 Marcus von Appen. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify 
 *  it under the terms of the GNU General Public License as published by 
 *  the Free Software Foundation; either version 2 of the License, or 
 *  (at your option) any later version.  
 *
 *  This program is distributed in the hope that it will be useful, 
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *  GNU General Public License for more details.  
 *
 *  You should have received a copy of the GNU General Public License 
 *  along with this program; if not, write to the Free Software 
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 */

#include "lingoteach.h"
#include <stdio.h>
#include <string.h>

#define FOK() fprintf(stdout,"Ok\n")

int 
main (int argc, char *argv[])
{
     lingConfig *settings = NULL;

     if (argc != 5)
     {
	  fprintf (stdout, "Usage: %s name file lang_dtd lesson_dtd\n",
		   argv[0]);
	  return -1;
     }
     
     fprintf (stdout, "Testing ling_conf_init_config()...");
     settings = ling_conf_init_config (argv[1], argv[2], argv[3], argv[4]);
     if (settings == NULL)
     {
	  fprintf (stdout, "Error: settings could not be initialized!\n");
	  return -1;
     }
     FOK ();

     fprintf (stdout, "Checking settings->appname...");
     if (strcmp (argv[1], settings->appname) != 0)
     {
	  fprintf (stdout, "Error: settings differ from input of name!\n");
	  fprintf (stdout, "Data: %s <-> %s!\n", settings->appname, argv[1]);
	  return -1;
     }
     FOK ();

     fprintf (stdout, "Checking settings->langfile...");
     if (strcmp (argv[2], settings->langfile) != 0)
     {
	  fprintf (stdout, "Error: settings differ from input of file!\n");
	  fprintf (stdout, "Data: %s <-> %s!\n", settings->langfile, argv[2]);
	  return -1;
     }
     FOK ();

     fprintf (stdout, "All tests OK:\n");
     fprintf (stdout, "Input: %s, %s, %s, %s\n", argv[1], argv[2], argv[3],
    	      argv[4]);
     fprintf (stdout, "Settings: %s, %s\n", settings->appname, 
	      settings->langfile);

     fprintf (stdout, "Cleaning up...");
     ling_conf_free_config (settings);
     FOK ();

     return 0;
}

