/*
 *  Copyright (C) 2005-2007 Renier Roth
 *  www.renier.de
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package de.renier.vdr.channel.editor.documents;

import java.awt.Toolkit;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

/**
 * WholeNumberDocument
 * 
 * @author <a href="mailto:editor@renier.de">Renier Roth</a>
 */
public class WholeNumberDocument extends PlainDocument {

  private static final long serialVersionUID = -2146767977001800880L;

  public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
    char[] source = str.toCharArray();
    char[] result = new char[source.length];
    int j = 0;

    for (int i = 0; i < result.length; i++) {
      if (Character.isDigit(source[i]))
        result[j++] = source[i];
      else {
        Toolkit.getDefaultToolkit().beep();
      }
    }
    super.insertString(offs, new String(result, 0, j), a);
  }
}